/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.DefaultPageTableModel;
import com.jidesoft.grid.JideTable;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.TableAdapter;
import com.jidesoft.grid.TableUtils;
import java.awt.GridLayout;
import java.awt.KeyboardFocusManager;
import java.util.TreeSet;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class PagedTablePane
extends JPanel
implements TableAdapter {
    private int \u067c = 2;
    private int \u067e = 20;
    private TableModel \u067f;
    private TableModel[] \u067d;
    private JTable[] \u0680;
    protected boolean _rowSelectionAllowed = true;
    protected boolean _columnSelectionAllowed = false;
    protected boolean _nonContiguousCellSelectionAllowed = false;

    public PagedTablePane(TableModel tableModel) {
        this(tableModel, 2);
    }

    public PagedTablePane(TableModel tableModel, int n2) {
        this.\u067f = tableModel;
        this.\u067c = n2;
        this.setLayout(new GridLayout(1, this.\u067c));
        this.\u067d = new TableModel[this.\u067c];
        this.\u0680 = new JTable[this.\u067c];
        for (int i2 = 0; i2 < this.\u067c; ++i2) {
            DefaultPageTableModel defaultPageTableModel = new DefaultPageTableModel(this.\u067f, this.\u067e);
            this.\u067d[i2] = defaultPageTableModel;
            this.\u0680[i2] = this.createTable(defaultPageTableModel);
            defaultPageTableModel.setCurrentPage(i2);
            this.add(new JScrollPane(this.\u0680[i2]));
        }
        TableUtils.synchronizeTableColumnWidth(this.\u0680);
        TableUtils.unifyTableRowSelection(this.\u0680);
    }

    @Override
    public void setModel(TableModel tableModel) {
        this.\u067f = tableModel;
        for (int i2 = 0; i2 < this.\u067c; ++i2) {
            DefaultPageTableModel defaultPageTableModel = new DefaultPageTableModel(this.\u067f, this.\u067e);
            this.\u067d[i2] = defaultPageTableModel;
            this.\u0680[i2].setModel(defaultPageTableModel);
            defaultPageTableModel.setCurrentPage(i2);
        }
    }

    @Override
    public TableModel getModel() {
        return this.\u067f;
    }

    protected JTable createTable(TableModel tableModel) {
        return new SortableTable(tableModel);
    }

    public JTable[] getTables() {
        return this.\u0680;
    }

    @Override
    public void setRowSelectionAllowed(boolean bl) {
        boolean bl2 = this._rowSelectionAllowed;
        this._rowSelectionAllowed = bl;
        if (bl2 != bl) {
            this.repaint();
            this.firePropertyChange("rowSelectionAllowed", bl2, bl);
            this.resynchronizeTablesSelection();
        }
    }

    @Override
    public boolean getRowSelectionAllowed() {
        return this._rowSelectionAllowed || this.isNonContiguousCellSelectionAllowed();
    }

    @Override
    public void setColumnSelectionAllowed(boolean bl) {
        boolean bl2 = this._columnSelectionAllowed;
        this._columnSelectionAllowed = bl;
        if (bl2 != bl) {
            this.repaint();
            this.firePropertyChange("columnSelectionAllowed", bl2, bl);
            this.resynchronizeTablesSelection();
        }
    }

    @Override
    public boolean getColumnSelectionAllowed() {
        return this._columnSelectionAllowed || this.isNonContiguousCellSelectionAllowed();
    }

    @Override
    public void setCellSelectionEnabled(boolean bl) {
        boolean bl2 = this.getCellSelectionEnabled();
        this.setRowSelectionAllowed(bl);
        this.setColumnSelectionAllowed(bl);
        this.firePropertyChange("cellSelectionEnabled", bl2, bl);
        this.resynchronizeTablesSelection();
    }

    @Override
    public boolean getCellSelectionEnabled() {
        return this.getRowSelectionAllowed() && this.getColumnSelectionAllowed();
    }

    public void setNonContiguousCellSelectionAllowed(boolean bl) {
        boolean bl2 = this._nonContiguousCellSelectionAllowed;
        this._nonContiguousCellSelectionAllowed = bl;
        if (bl2 != bl) {
            this.repaint();
            this.firePropertyChange("nonContiguousCellSelectionAllowed", bl2, bl);
            this.resynchronizeTablesSelection();
        }
    }

    public boolean isNonContiguousCellSelectionAllowed() {
        return this._nonContiguousCellSelectionAllowed;
    }

    protected void resynchronizeTablesSelection() {
        for (JTable jTable : this.\u0680) {
            if (jTable instanceof JideTable) {
                ((JideTable)jTable).setNonContiguousCellSelection(this.isNonContiguousCellSelectionAllowed());
            }
            jTable.setColumnSelectionAllowed(this.getColumnSelectionAllowed());
            jTable.setRowSelectionAllowed(this.getRowSelectionAllowed());
        }
    }

    @Override
    public int getRowCount() {
        int n2 = 0;
        for (JTable jTable : this.\u0680) {
            n2 += jTable.getRowCount();
        }
        return n2;
    }

    @Override
    public int getColumnCount() {
        TablePosition tablePosition = this.getTableAtRow(0);
        return tablePosition.\u0102 != null ? tablePosition.\u0102.getColumnCount() : 0;
    }

    public TablePosition getTableAtRow(int n2) {
        for (JTable jTable : this.\u0680) {
            if (n2 < jTable.getRowCount()) {
                return new TablePosition(jTable, n2, -1);
            }
            n2 -= jTable.getRowCount();
        }
        return null;
    }

    public TablePosition getTableAtCell(int n2, int n3) {
        TablePosition tablePosition = this.getTableAtRow(n2);
        return new TablePosition(tablePosition.\u0102, tablePosition.\u0103, n3);
    }

    @Override
    public String getColumnName(int n2) {
        TablePosition tablePosition = this.getTableAtRow(0);
        return tablePosition != null ? tablePosition.\u0102.getColumnName(n2) : "";
    }

    @Override
    public Class<?> getColumnClass(int n2) {
        TablePosition tablePosition = this.getTableAtRow(0);
        return tablePosition != null ? tablePosition.\u0102.getColumnClass(n2) : null;
    }

    @Override
    public Object getValueAt(int n2, int n3) {
        TablePosition tablePosition = this.getTableAtCell(n2, n3);
        return tablePosition != null ? tablePosition.\u0102.getValueAt(tablePosition.\u0103, tablePosition.\u0101) : null;
    }

    @Override
    public void setValueAt(Object object, int n2, int n3) {
        TablePosition tablePosition = this.getTableAtCell(n2, n3);
        if (tablePosition != null) {
            tablePosition.\u0102.setValueAt(object, tablePosition.\u0103, tablePosition.\u0101);
        }
    }

    @Override
    public boolean isCellEditable(int n2, int n3) {
        TablePosition tablePosition = this.getTableAtCell(n2, n3);
        return tablePosition != null ? Boolean.valueOf(tablePosition.\u0102.isCellEditable(tablePosition.\u0103, tablePosition.\u0101)) : null;
    }

    @Override
    public int getSelectedRow() {
        int n2 = 0;
        for (JTable jTable : this.\u0680) {
            int n3 = jTable.getSelectedRow();
            if (n3 != -1) {
                return n3 + n2;
            }
            n2 += jTable.getRowCount();
        }
        return -1;
    }

    @Override
    public int getSelectedColumn() {
        TablePosition tablePosition = this.getTableAtRow(0);
        return tablePosition != null ? tablePosition.\u0102.getSelectedColumn() : -1;
    }

    @Override
    public int[] getSelectedRows() {
        int n2 = 0;
        int[][] nArrayArray = new int[this.\u0680.length][];
        int n3 = this.\u0680.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            JTable jTable = this.\u0680[i2];
            nArrayArray[i2] = jTable.getSelectedRows();
            for (int n4 : nArrayArray[i2]) {
                n4 += n2;
            }
            n2 += jTable.getRowCount();
        }
        return this.\u0101(nArrayArray);
    }

    @Override
    public int convertColumnIndexToView(int n2) {
        TablePosition tablePosition = this.getTableAtRow(0);
        return tablePosition.\u0102 != null ? tablePosition.\u0102.convertColumnIndexToView(n2) : -1;
    }

    @Override
    public int convertColumnIndexToModel(int n2) {
        TablePosition tablePosition = this.getTableAtRow(0);
        return tablePosition.\u0102 != null ? tablePosition.\u0102.convertColumnIndexToModel(n2) : -1;
    }

    private int[] \u0101(int[] ... nArray) {
        int n2 = 0;
        for (int[] nArray2 : nArray) {
            n2 += nArray2.length;
        }
        int[] nArray3 = new int[n2];
        int n3 = 0;
        for (int[] nArray4 : nArray) {
            System.arraycopy(nArray4, 0, nArray3, n3, nArray4.length);
            n3 += nArray4.length;
        }
        return nArray3;
    }

    private int[] \u0102(int[] ... nArray) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        int[][] object = nArray;
        int n2 = object.length;
        for (int iterator = 0; iterator < n2; ++iterator) {
            int[] nArray2;
            for (int n3 : nArray2 = object[iterator]) {
                treeSet.add(n3);
            }
        }
        int[] nArray3 = new int[treeSet.size()];
        n2 = 0;
        for (Integer n4 : treeSet) {
            nArray3[n2] = n4;
            ++n2;
        }
        return nArray3;
    }

    @Override
    public int[] getSelectedColumns() {
        TablePosition tablePosition = this.getTableAtRow(0);
        return tablePosition.\u0102 != null ? tablePosition.\u0102.getSelectedColumns() : null;
    }

    @Override
    public int getSelectedRowCount() {
        return this.getSelectedRows().length;
    }

    @Override
    public int getSelectedColumnCount() {
        return this.getSelectedColumns().length;
    }

    @Override
    public boolean isRowSelected(int n2) {
        for (JTable jTable : this.\u0680) {
            boolean bl = jTable.isRowSelected(n2);
            if (bl) {
                return true;
            }
            n2 -= jTable.getRowCount();
        }
        return false;
    }

    @Override
    public boolean isColumnSelected(int n2) {
        TablePosition tablePosition = this.getTableAtRow(0);
        return tablePosition != null && tablePosition.\u0102.isColumnSelected(n2);
    }

    @Override
    public boolean isCellSelected(int n2, int n3) {
        return !(!this.getRowSelectionAllowed() && !this.getColumnSelectionAllowed() || this.getRowSelectionAllowed() && !this.isRowSelected(n2) || this.getColumnSelectionAllowed() && !this.isColumnSelected(n3));
    }

    @Override
    public void clearSelection() {
        for (JTable jTable : this.\u0680) {
            jTable.clearSelection();
        }
    }

    @Override
    public void changeSelection(int n2, int n3, boolean bl, boolean bl2) {
        TablePosition tablePosition = this.getTableAtCell(n2, n3);
        if (this.isAncestorOf(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner())) {
            tablePosition.\u0102.requestFocus();
        }
        tablePosition.\u0102.changeSelection(tablePosition.\u0103, tablePosition.\u0101, bl, bl2);
    }

    public static class TablePosition {
        JTable \u0102;
        int \u0103 = -1;
        int \u0101 = 1;

        public TablePosition(JTable jTable, int n2, int n3) {
            this.\u0102 = jTable;
            this.\u0103 = n2;
            this.\u0101 = n3;
        }

        public JTable getTable() {
            return this.\u0102;
        }

        public int getRow() {
            return this.\u0103;
        }

        public int getColumn() {
            return this.\u0101;
        }
    }
}

