/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.CategorizedTable;
import com.jidesoft.grid.CellRendererPaneEx;
import com.jidesoft.grid.ContextSensitiveCellRenderer;
import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.Node;
import com.jidesoft.jdk.JdkSpecificClass;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;

public class ExpandablePanel
extends CellRendererPaneEx {
    public static final int TEXT_ICON_GAP = 4;
    public static final int LEFT_MARGIN = 16;
    public static boolean VERTICAL_CENTER_ALIGNMENT = true;
    protected Node _node;
    protected JTable _table;
    protected Icon _expandedIcon;
    protected Icon _collapsedIcon;
    protected Color _disabledForeground;
    protected Color _disabledBackground;
    protected boolean _isSelected;
    protected boolean _hasFocus;
    private static Map<String, Boolean> \u010b;

    public ExpandablePanel(JTable jTable, Icon icon, Icon icon2, Color color, Color color2) {
        this._table = jTable;
        this._expandedIcon = icon;
        this._collapsedIcon = icon2;
        this._disabledBackground = color;
        this._disabledForeground = color2;
        this.initComponents();
    }

    public ExpandablePanel(JTable jTable, Component component, Icon icon, Icon icon2, Color color, Color color2) {
        this(jTable, icon, icon2, color, color2);
        this._actualRenderer = component;
    }

    protected void initComponents() {
        this.applyComponentOrientation(this._table.getComponentOrientation());
    }

    public void setNode(Node node) {
        this._node = node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics graphics) {
        int n2;
        super.paint(graphics);
        this.paintBackground(graphics);
        this.paintBorder(graphics);
        int n3 = 16;
        int n4 = 0;
        boolean bl = this._actualRenderer instanceof JComponent && "true".equals(((JComponent)this._actualRenderer).getClientProperty("isVertical"));
        int n5 = this._table.getRowHeight() - this._table.getIntercellSpacing().height;
        n4 = this.paintIcon(graphics, n4);
        int n6 = bl ? this.getWidth() : this.getWidth() - n4;
        int n7 = n2 = !bl ? this.getHeight() : this.getHeight() - n4;
        if (this._actualRenderer != null) {
            this._actualRenderer.setFont(this.getFont());
            Rectangle rectangle = !bl ? (this.getComponentOrientation().isLeftToRight() ? new Rectangle(n4, this._table.getIntercellSpacing().height / 2, n6, n2) : (this._actualRenderer.getPreferredSize().width < n6 ? new Rectangle(n6 - this._actualRenderer.getPreferredSize().width, this._table.getIntercellSpacing().height / 2, this._actualRenderer.getPreferredSize().width, n2) : new Rectangle(this._table.getIntercellSpacing().width, this._table.getIntercellSpacing().height / 2, n6 - this._table.getIntercellSpacing().width, n2))) : (this.getComponentOrientation().isLeftToRight() ? new Rectangle(this._table.getIntercellSpacing().width / 2, n4 + this._table.getIntercellSpacing().height / 2, this.getWidth(), n2) : new Rectangle(this._table.getIntercellSpacing().width / 2, this._table.getIntercellSpacing().height / 2, this.getWidth(), n2));
            int n8 = -1;
            try {
                if (this._actualRenderer instanceof ContextSensitiveCellRenderer) {
                    n8 = ((ContextSensitiveCellRenderer)this._actualRenderer).getVerticalAlignment();
                    ((ContextSensitiveCellRenderer)this._actualRenderer).setVerticalAlignment(1);
                } else if (this._actualRenderer instanceof JLabel) {
                    n8 = ((JLabel)this._actualRenderer).getVerticalAlignment();
                    ((JLabel)this._actualRenderer).setVerticalAlignment(1);
                }
                ((JComponent)this._actualRenderer).setOpaque(false);
                this.paintComponent(graphics, this._actualRenderer, this._table, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
            }
            finally {
                ((JComponent)this._actualRenderer).setOpaque(true);
                if (n8 != -1) {
                    if (this._actualRenderer instanceof ContextSensitiveCellRenderer) {
                        ((ContextSensitiveCellRenderer)this._actualRenderer).setVerticalAlignment(n8);
                    } else if (this._actualRenderer instanceof JLabel) {
                        ((JLabel)this._actualRenderer).setVerticalAlignment(n8);
                    }
                }
                if (this._actualRenderer.getParent() != null) {
                    this._actualRenderer.getParent().remove(this._actualRenderer);
                }
            }
        } else {
            graphics.setFont(this._table.getFont());
            if (this.isSelected()) {
                graphics.setColor(this._table.getSelectionForeground());
            } else {
                graphics.setColor(this._table.getForeground());
            }
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n9 = (n5 - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent() + 1;
            String string = this._node != null ? this._node.toString() : "";
            int n10 = SwingUtilities.computeStringWidth(fontMetrics, string);
            if (n10 > n6) {
                int n11;
                String string2 = "...";
                int n12 = SwingUtilities.computeStringWidth(fontMetrics, string2);
                for (n11 = 0; n11 < string.length() && (n12 += fontMetrics.charWidth(string.charAt(n11))) <= n6; ++n11) {
                }
                string = string.substring(0, n11) + string2;
                n10 = SwingUtilities.computeStringWidth(fontMetrics, string);
            }
            JideSwingUtilities.drawString(this._table, graphics, string, this.getComponentOrientation().isLeftToRight() ? n4 : this.getWidth() - n4 - n3 - n10, n9);
        }
        this.paintFocus(graphics);
    }

    protected int paintIcon(Graphics graphics, int n2) {
        Icon icon;
        boolean bl = this._actualRenderer instanceof JComponent && "true".equals(((JComponent)this._actualRenderer).getClientProperty("isVertical"));
        int n3 = this._table.getRowHeight() - this._table.getIntercellSpacing().height;
        boolean bl2 = this.isExpandIconVisible(this._table);
        if (bl2 && this._node instanceof Expandable && ((Expandable)this._node).hasChildren() && (icon = ((Expandable)this._node).isExpanded() && ((Expandable)this._node).getChildrenCount() > 0 ? this._expandedIcon : (!((Expandable)this._node).isExpanded() ? this._collapsedIcon : null)) != null && ((Expandable)this._node).isExpandable()) {
            Rectangle rectangle = new Rectangle();
            boolean bl3 = JdkSpecificClass.isSynthIcon(icon);
            if (!bl) {
                int n4 = 1 + n2 + (16 - icon.getIconWidth()) / 2 + this._table.getIntercellSpacing().width / 2;
                rectangle.x = this.getComponentOrientation().isLeftToRight() ? n4 : this.getWidth() - n2 - icon.getIconWidth() - (16 - icon.getIconWidth()) / 2 - this._table.getIntercellSpacing().width / 2;
                rectangle.y = n2 + (n3 - icon.getIconHeight()) / 2 + this._table.getIntercellSpacing().height / 2;
                rectangle.width = icon.getIconWidth();
                rectangle.height = icon.getIconHeight();
                if (bl3) {
                    JdkSpecificClass.paintTableCellIcon(this._table, icon, graphics, rectangle.x, rectangle.y);
                } else {
                    icon.paintIcon(this, graphics, rectangle.x, rectangle.y);
                }
                n2 = n4 + rectangle.width;
            } else {
                rectangle.y = n2 + (16 - icon.getIconHeight()) / 2 + this._table.getIntercellSpacing().height / 2;
                rectangle.x = 1 + n2 + (16 - icon.getIconWidth()) / 2 + this._table.getIntercellSpacing().width / 2;
                rectangle.width = icon.getIconWidth();
                rectangle.height = icon.getIconHeight();
                if (bl3) {
                    JdkSpecificClass.paintTableCellIcon(this._table, icon, graphics, rectangle.x, rectangle.y);
                } else {
                    icon.paintIcon(this, graphics, rectangle.x, rectangle.y);
                }
                n2 = rectangle.y + rectangle.height;
            }
            n2 += 4;
        }
        return n2;
    }

    protected void paintFocus(Graphics graphics) {
        Border border;
        Color color = super.getBackground();
        if (this.isSelected()) {
            super.setBackground(this._table.getSelectionBackground());
        } else {
            super.setBackground(color);
        }
        if (this.isHasFocus() && (border = UIDefaultsLookup.getBorder("Table.focusCellHighlightBorder")) != null) {
            try {
                border.paintBorder(this, graphics, 0, 0, this.getWidth(), this.getHeight());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.setBackground(color);
    }

    protected void paintBackground(Graphics graphics) {
        if (this.isPaintBackground()) {
            if (this._actualRenderer != null && this._actualRenderer.isOpaque() && !(this._actualRenderer.getBackground() instanceof UIResource)) {
                graphics.setColor(this._actualRenderer.getBackground());
            } else {
                graphics.setColor(this.getBackground());
            }
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    protected void paintDecoration(Graphics graphics) {
        graphics.setColor(new Color(226, 222, 205));
        graphics.drawLine(0, this.getHeight() - 3, this.getWidth(), this.getHeight() - 3);
        graphics.setColor(new Color(214, 210, 194));
        graphics.drawLine(0, this.getHeight() - 2, this.getWidth(), this.getHeight() - 2);
        graphics.setColor(this._table.getGridColor());
        graphics.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
        graphics.drawLine(this.getWidth() - 1, 0, this.getWidth() - 1, this.getHeight() - 1);
    }

    public boolean isSelected() {
        return this._isSelected;
    }

    public void setSelected(boolean bl) {
        this._isSelected = bl;
    }

    public boolean isHasFocus() {
        return this._hasFocus;
    }

    public void setHasFocus(boolean bl) {
        this._hasFocus = bl;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = this._actualRenderer != null ? this._actualRenderer.getPreferredSize() : super.getPreferredSize();
        int n2 = this._node instanceof Expandable && ((Expandable)this._node).hasChildren() ? 21 : 4;
        return new Dimension(dimension.width + n2, dimension.height);
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this._actualRenderer != null) {
            this._actualRenderer.setBackground(color);
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this._actualRenderer != null) {
            this._actualRenderer.setForeground(color);
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this._actualRenderer != null) {
            this._actualRenderer.setFont(font);
        }
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        if (this._actualRenderer instanceof JComponent) {
            return ((JComponent)this._actualRenderer).getToolTipText(mouseEvent);
        }
        return "";
    }

    public boolean isExpandIconVisible(JTable jTable) {
        return !(jTable instanceof CategorizedTable) || ((CategorizedTable)jTable).isExpandIconVisible();
    }
}

