/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.event;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.axis.Axis;
import com.jidesoft.chart.event.PanEvent;
import com.jidesoft.chart.event.PanListener;
import com.jidesoft.chart.model.IdentityTransform;
import com.jidesoft.chart.model.InvertibleTransform;
import com.jidesoft.range.AbstractRange;
import com.jidesoft.range.CategoryRange;
import com.jidesoft.range.NumericRange;
import com.jidesoft.range.Range;
import com.jidesoft.range.TimeRange;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Timer;

public class ChartPanner {
    private Chart \u010a;
    private boolean \u010c;
    private boolean \u0109;
    private boolean \u0106 = false;
    private double \u0108 = 0.1;
    private Range<?> \u0104;
    private Range<?> \u010e;
    private Point2D[] \u0107 = new Point2D[3];
    private Point2D[] \u0102 = new Point2D[3];
    private Point2D \u0103;
    private Point2D \u010d;
    private Timer \u0101;
    private int \u0105 = 20;
    private List<PanListener> \u010b = new CopyOnWriteArrayList<PanListener>();

    public ChartPanner(Chart chart) {
        this(chart, true, true);
    }

    public ChartPanner(Chart chart, boolean bl, boolean bl2) {
        this.\u010a = chart;
        this.setHorizontalPan(bl);
        this.setVerticalPan(bl2);
    }

    public boolean isHorizontalPan() {
        return this.\u010c;
    }

    public void setHorizontalPan(boolean bl) {
        this.\u010c = bl;
    }

    public boolean isVerticalPan() {
        return this.\u0109;
    }

    public void setVerticalPan(boolean bl) {
        this.\u0109 = bl;
    }

    public boolean isContinuous() {
        return this.\u0106;
    }

    public void setContinuous(boolean bl) {
        this.\u0106 = bl;
    }

    public void resetSpeeds() {
        this.\u0101(this.\u0107);
        this.\u0101(this.\u0102);
    }

    private void \u0101(Point2D[] point2DArray) {
        for (int i2 = 0; i2 < point2DArray.length; ++i2) {
            point2DArray[i2] = new Point2D.Double(0.0, 0.0);
        }
    }

    private Point2D \u0102(Point2D[] point2DArray) {
        double d2 = 0.0;
        double d3 = 0.0;
        for (Point2D point2D : point2DArray) {
            d2 += point2D.getX();
            d3 += point2D.getY();
        }
        return new Point2D.Double(d2 / (double)point2DArray.length, d3 / (double)point2DArray.length);
    }

    public double getFrictionCoefficient() {
        return this.\u0108;
    }

    public void setFrictionCoefficient(double d2) {
        if (d2 <= 0.0 || d2 >= 1.0) {
            throw new IllegalArgumentException("Friction coefficient must be between 0 and 1");
        }
        this.\u0108 = d2;
    }

    public void addPanListener(PanListener panListener) {
        this.\u010b.add(panListener);
    }

    public void removePanListener(PanListener panListener) {
        this.\u010b.remove(panListener);
    }

    protected void firePan() {
        this.firePan(new PanEvent(this));
    }

    protected void firePan(int n2, int n3) {
        this.firePan(new PanEvent(this, n2, n3));
    }

    protected void firePan(PanEvent panEvent) {
        for (PanListener panListener : this.\u010b) {
            panListener.panChanged(panEvent);
        }
        this.\u010a.repaint();
    }

    public Range<?> getXLimits() {
        return this.\u0104;
    }

    public void setXLimits(Range<?> range) {
        this.\u0104 = range;
    }

    public Range<?> getYLimits() {
        return this.\u010e;
    }

    public void setYLimits(Range<?> range) {
        this.\u010e = range;
    }

    public void drag(Point point, Point point2) {
        Point2D point2D = this.\u010a.calculateUserPoint(point);
        Point2D point2D2 = this.\u010a.calculateUserPoint(point2);
        if (point2D != null && point2D2 != null) {
            int n2 = point2.x - point.x;
            int n3 = point2.y - point.y;
            double d2 = point2D2.getX() - point2D.getX();
            double d3 = point2D2.getY() - point2D.getY();
            this.\u0107[0] = this.\u0107[1];
            this.\u0107[1] = this.\u0107[2];
            this.\u0107[2] = new Point2D.Double(n2, n3);
            this.\u0102[0] = this.\u0102[1];
            this.\u0102[1] = this.\u0102[2];
            this.\u0102[2] = new Point2D.Double(d2, d3);
            this.\u0103 = this.\u0102(this.\u0107);
            this.\u010d = this.\u0102(this.\u0102);
            this.\u0101(n2, n3, this.\u0106 ? this.\u010d.getX() : d2, this.\u0106 ? this.\u010d.getY() : d3);
            if (this.\u0106) {
                if (this.\u0101 != null && this.\u0101.isRunning()) {
                    this.\u0101.stop();
                }
                ActionListener actionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        double d2 = 1.0 - ChartPanner.this.\u0108;
                        ChartPanner.this.\u0103 = new Point2D.Double(ChartPanner.this.\u0103.getX() * d2, ChartPanner.this.\u0103.getY() * d2);
                        ChartPanner.this.\u010d = new Point2D.Double(ChartPanner.this.\u010d.getX() * d2, ChartPanner.this.\u010d.getY() * d2);
                        ChartPanner.this.\u0101(ChartPanner.this.\u0103.getX(), ChartPanner.this.\u0103.getY(), ChartPanner.this.\u010d.getX(), ChartPanner.this.\u010d.getY());
                        if (Math.abs(ChartPanner.this.\u0103.getX()) < 1.0 && Math.abs(ChartPanner.this.\u0103.getY()) < 1.0) {
                            ChartPanner.this.\u0101.stop();
                            ChartPanner.this.\u0101 = null;
                        }
                    }
                };
                this.\u0101 = new Timer(this.\u0105, actionListener);
                this.\u0101.start();
            }
        }
    }

    private void \u0101(double d2, double d3, double d4, double d5) {
        Point2D point2D;
        Point2D.Double double_;
        Point2D.Double double_2;
        double d6;
        double d7;
        InvertibleTransform<Double> invertibleTransform;
        Axis axis = this.\u010a.getXAxis();
        Axis axis2 = this.\u010a.getYAxis();
        TimeRange timeRange = axis.getRange();
        TimeRange timeRange2 = axis2.getRange();
        double d8 = timeRange.minimum();
        double d9 = timeRange2.minimum();
        Point2D point2D2 = this.\u010a.calculatePixelPoint2D(new Point2D.Double(d8, d9));
        double d10 = timeRange.maximum();
        double d11 = timeRange2.maximum();
        Point2D point2D3 = this.\u010a.calculatePixelPoint2D(new Point2D.Double(d10, d11));
        if (this.\u010c) {
            AbstractRange abstractRange;
            if (timeRange instanceof TimeRange) {
                abstractRange = new TimeRange((long)(timeRange.minimum() - d4), (long)(timeRange.maximum() - d4));
            } else if (timeRange instanceof CategoryRange) {
                abstractRange = timeRange;
                invertibleTransform = (CategoryRange)((Object)timeRange);
                if (((CategoryRange)((Object)invertibleTransform)).getCategoryValues().size() == 0) {
                    return;
                }
                d7 = timeRange.minimum() - d4;
                d6 = timeRange.maximum() - d4;
                double_2 = new Point2D.Double(((CategoryRange)((Object)invertibleTransform)).position((Double)((CategoryRange)((Object)invertibleTransform)).lower()) - 1, axis2.minimum());
                double_ = new Point2D.Double(((CategoryRange)((Object)invertibleTransform)).position((Double)((CategoryRange)((Object)invertibleTransform)).upper()) + 1, axis2.maximum());
                point2D2 = this.\u010a.calculatePixelPoint(double_2);
                point2D3 = this.\u010a.calculatePixelPoint(double_);
                if (d4 < 0.0 && point2D3.getX() > (double)this.\u010a.getXEnd()) {
                    ((CategoryRange)((Object)invertibleTransform)).setMinimum(d7);
                    ((CategoryRange)((Object)invertibleTransform)).setMaximum(d6);
                } else if (d4 > 0.0 && point2D2.getX() < (double)this.\u010a.getXStart()) {
                    ((CategoryRange)((Object)invertibleTransform)).setMinimum(d7);
                    ((CategoryRange)((Object)invertibleTransform)).setMaximum(d6);
                }
            } else {
                invertibleTransform = axis.getAxisTransform();
                if (invertibleTransform == null || invertibleTransform instanceof IdentityTransform) {
                    abstractRange = new NumericRange(timeRange.minimum() - d4, timeRange.maximum() - d4);
                } else {
                    Point2D point2D4 = this.\u010a.calculateUserPoint(new Point((int)(point2D2.getX() - d2), (int)(point2D2.getY() - d3)));
                    point2D = this.\u010a.calculateUserPoint(new Point((int)(point2D3.getX() - d2), (int)(point2D3.getY() - d3)));
                    abstractRange = new NumericRange(point2D4.getX(), point2D.getX());
                }
            }
            if (this.\u0104 != null) {
                if (abstractRange.minimum() >= this.\u0104.minimum() && abstractRange.maximum() <= this.\u0104.maximum()) {
                    axis.setRange(abstractRange);
                } else {
                    d2 = 0.0;
                }
            } else {
                axis.setRange(abstractRange);
            }
        }
        if (this.\u0109) {
            AbstractRange abstractRange;
            if (timeRange2 instanceof TimeRange) {
                abstractRange = new TimeRange((long)(timeRange2.minimum() - d5), (long)(timeRange2.maximum() - d5));
            } else if (timeRange2 instanceof CategoryRange) {
                abstractRange = timeRange2;
                invertibleTransform = (CategoryRange)((Object)timeRange2);
                if (((CategoryRange)((Object)invertibleTransform)).getCategoryValues().size() == 0) {
                    return;
                }
                d7 = ((CategoryRange)((Object)invertibleTransform)).minimum() - d5;
                d6 = ((CategoryRange)((Object)invertibleTransform)).maximum() - d5;
                double_2 = new Point2D.Double(axis.minimum(), ((CategoryRange)((Object)invertibleTransform)).position((Double)((CategoryRange)((Object)invertibleTransform)).lower()) - 1);
                double_ = new Point2D.Double(axis.maximum(), ((CategoryRange)((Object)invertibleTransform)).position((Double)((CategoryRange)((Object)invertibleTransform)).upper()) + 1);
                point2D3 = this.\u010a.calculatePixelPoint(double_);
                point2D2 = this.\u010a.calculatePixelPoint(double_2);
                if (d5 > 0.0 && point2D2.getY() > (double)this.\u010a.getYStart()) {
                    ((CategoryRange)((Object)invertibleTransform)).setMinimum(d7);
                    ((CategoryRange)((Object)invertibleTransform)).setMaximum(d6);
                } else if (d5 < 0.0 && point2D3.getY() < (double)this.\u010a.getYEnd()) {
                    ((CategoryRange)((Object)invertibleTransform)).setMinimum(d7);
                    ((CategoryRange)((Object)invertibleTransform)).setMaximum(d6);
                }
            } else {
                invertibleTransform = axis2.getAxisTransform();
                if (invertibleTransform == null || invertibleTransform instanceof IdentityTransform) {
                    abstractRange = new NumericRange(timeRange2.minimum() - d5, timeRange2.maximum() - d5);
                } else {
                    Point2D point2D5 = this.\u010a.calculateUserPoint(new Point((int)(point2D2.getX() - d2), (int)(point2D2.getY() - d3)));
                    point2D = this.\u010a.calculateUserPoint(new Point((int)(point2D3.getX() - d2), (int)(point2D3.getY() - d3)));
                    abstractRange = new NumericRange(point2D5.getY(), point2D.getY());
                }
            }
            if (this.\u010e != null) {
                if (abstractRange.minimum() >= this.\u010e.minimum() && abstractRange.maximum() <= this.\u010e.maximum()) {
                    axis2.setRange(abstractRange);
                } else {
                    d3 = 0.0;
                }
            } else {
                axis2.setRange(abstractRange);
            }
        }
        this.firePan((int)d2, (int)d3);
    }
}

