/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jydocking;

import de.javasoft.swing.JYTabbedPane;
import de.javasoft.swing.jydocking.Dockbar;
import de.javasoft.swing.jydocking.DockbarManager;
import de.javasoft.swing.jydocking.DockingManager;
import de.javasoft.swing.jydocking.DockingPort;
import de.javasoft.swing.jydocking.DockingPortTracker;
import de.javasoft.swing.jydocking.DockingUtility;
import de.javasoft.swing.jydocking.IDockable;
import de.javasoft.swing.jydocking.IDockingConstants;
import de.javasoft.swing.jydocking.IDockingPort;
import de.javasoft.swing.jydocking.Perspective;
import de.javasoft.swing.jydocking.PerspectiveModel;
import java.awt.Component;
import java.awt.Container;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DockingPath
implements Cloneable,
IDockingConstants,
Serializable {
    private static final long serialVersionUID = 9019675117741910838L;
    private transient String stringForm;
    private String rootPortID;
    private ArrayList<PerspectiveModel.SplitNode> nodes;
    private String siblingID;
    private boolean tabbed;

    public DockingPath() {
        this.nodes = new ArrayList();
    }

    public static DockingPath create(String string) {
        IDockable iDockable = DockingPath.findDockable(string);
        return DockingPath.create(iDockable);
    }

    static DockingPath create(IDockable iDockable) {
        if (iDockable == null || !DockingPath.isDocked(iDockable)) {
            return null;
        }
        DockingPath dockingPath = new DockingPath(iDockable);
        JComponent jComponent = iDockable.getComponent();
        Container container = jComponent.getParent();
        while (!DockingPath.isDockingRoot(container)) {
            if (container instanceof IDockingPort) {
                PerspectiveModel.SplitNode splitNode = DockingPath.createNode((IDockingPort)((Object)container));
                dockingPath.addNode(splitNode);
            }
            container = container.getParent();
        }
        if (DockingPath.isDockingRoot(container)) {
            dockingPath.setRootPortId(((IDockingPort)((Object)container)).getID());
        }
        dockingPath.initialize();
        return dockingPath;
    }

    static PerspectiveModel.SplitNode createNode(IDockable iDockable) {
        Container container = iDockable.getComponent().getParent();
        return container instanceof IDockingPort ? DockingPath.createNode((IDockingPort)((Object)container)) : null;
    }

    static PerspectiveModel.SplitNode createNode(IDockingPort iDockingPort) {
        Container container = iDockingPort.getComponent().getParent();
        return container instanceof JSplitPane ? DockingPath.createNode(iDockingPort, (JSplitPane)container) : null;
    }

    private static PerspectiveModel.SplitNode createNode(IDockingPort iDockingPort, JSplitPane jSplitPane) {
        int n = jSplitPane.getOrientation();
        boolean bl = jSplitPane.getLeftComponent() == iDockingPort;
        int n2 = 0;
        String string = null;
        if (bl) {
            n2 = n == 0 ? 1 : 2;
            string = DockingPath.getSiblingID(jSplitPane.getRightComponent());
        } else {
            n2 = n == 0 ? 3 : 4;
            string = DockingPath.getSiblingID(jSplitPane.getLeftComponent());
        }
        return new PerspectiveModel.SplitNode(n, n2, DockingUtility.calcSplitRatio(jSplitPane), string);
    }

    private static String getSiblingID(Component component) {
        IDockable iDockable;
        if (component instanceof IDockingPort) {
            component = ((IDockingPort)((Object)component)).getDockedComponent();
        }
        return (iDockable = DockingPath.findDockable(component)) == null ? null : iDockable.getID();
    }

    private static boolean isDockingRoot(Container container) {
        return container instanceof IDockingPort && ((IDockingPort)((Object)container)).isRoot();
    }

    private DockingPath(IDockable iDockable) {
        this.siblingID = this.findSiblingID(iDockable);
        this.tabbed = iDockable.getComponent().getParent() instanceof JTabbedPane || iDockable.getComponent().getParent().getParent() instanceof JYTabbedPane;
        this.nodes = new ArrayList();
    }

    String getSiblingID() {
        return this.siblingID;
    }

    void setSiblingId(String string) {
        this.siblingID = string;
    }

    private DockingPath(String string, boolean bl, ArrayList<PerspectiveModel.SplitNode> arrayList) {
        this.siblingID = string;
        this.tabbed = bl;
        this.nodes = arrayList;
    }

    List<PerspectiveModel.SplitNode> getNodes() {
        return this.nodes;
    }

    IDockingPort getRootDockingPort() {
        return DockingPortTracker.getRootDockingPort(this.rootPortID);
    }

    String getRootPortId() {
        return this.rootPortID;
    }

    void setRootPortId(String string) {
        this.rootPortID = string;
    }

    private void addNode(PerspectiveModel.SplitNode splitNode) {
        this.nodes.add(splitNode);
    }

    private void initialize() {
        Collections.reverse(this.nodes);
    }

    private String findSiblingID(IDockable iDockable) {
        IDockable iDockable2;
        JSplitPane jSplitPane;
        JComponent jComponent = iDockable.getComponent();
        JSplitPane jSplitPane2 = jSplitPane = jComponent.getParent() instanceof JSplitPane ? (JSplitPane)jComponent.getParent() : null;
        if (jSplitPane == null) {
            return null;
        }
        Component component = jSplitPane.getLeftComponent();
        if (jComponent == component) {
            component = jSplitPane.getRightComponent();
        }
        return (iDockable2 = DockingPath.findDockable(component)) == null ? null : iDockable2.getID();
    }

    public boolean restore(String string, Perspective perspective) {
        return this.restore(DockingManager.getDockable(string), perspective);
    }

    public boolean restore(IDockable iDockable, Perspective perspective) {
        if (DockingPath.isDocked(iDockable)) {
            return false;
        }
        IDockingPort iDockingPort = this.getRootDockingPort();
        if (iDockingPort == null) {
            iDockingPort = DockingPortTracker.getRootDockingPort(DockingUtility.getActiveWindow());
        }
        String string = "CENTER";
        IDockingPort iDockingPort2 = iDockingPort;
        for (PerspectiveModel.SplitNode splitNode : this.nodes) {
            JSplitPane jSplitPane;
            Component component = iDockingPort2.getDockedComponent();
            string = this.getRegion(splitNode, component);
            JSplitPane jSplitPane2 = jSplitPane = component instanceof JSplitPane ? (JSplitPane)component : null;
            if (jSplitPane == null || jSplitPane.getOrientation() != splitNode.getOrientation()) {
                boolean bl = this.dockBrokenPath(iDockable, iDockingPort2, perspective, string, splitNode);
                if (!bl) break;
                return bl;
            }
            component = splitNode.getRegion() == 2 || splitNode.getRegion() == 1 ? jSplitPane.getLeftComponent() : jSplitPane.getRightComponent();
            iDockingPort2 = (IDockingPort)((Object)component);
        }
        return this.dockFullPath(iDockable, iDockingPort2, perspective, string);
    }

    private boolean dockBrokenPath(IDockable iDockable, IDockingPort iDockingPort, Perspective perspective, String string, PerspectiveModel.SplitNode splitNode) {
        PerspectiveModel.SplitNode splitNode2;
        JComponent jComponent = iDockingPort.getDockedComponent();
        if (jComponent instanceof JSplitPane) {
            return this.dockExtendedPath(iDockable, iDockingPort, perspective, string, splitNode);
        }
        if (jComponent instanceof JTabbedPane) {
            return this.dock(iDockable, iDockingPort, perspective, "CENTER", null);
        }
        IDockable iDockable2 = DockingPath.findDockable(jComponent);
        if (iDockable2 == null || this.tabbed) {
            return this.dock(iDockable, iDockingPort, perspective, "CENTER", null);
        }
        String string2 = iDockable2.getID();
        if (string2.equals((splitNode2 = this.getLastNode()).getSiblingId())) {
            string = this.getRegion(splitNode2, jComponent);
            splitNode = splitNode2;
        }
        return this.dock(iDockable, iDockingPort, perspective, string, splitNode);
    }

    private boolean dockFullPath(IDockable iDockable, IDockingPort iDockingPort, Perspective perspective, String string) {
        JComponent jComponent = iDockingPort.getDockedComponent();
        if (jComponent instanceof JTabbedPane) {
            return this.dock(iDockable, iDockingPort, perspective, "CENTER", null);
        }
        IDockable iDockable2 = DockingPath.findDockable(jComponent);
        if (iDockable2 != null) {
            JComponent jComponent2 = iDockable.getComponent();
            if (iDockingPort.isDockingAllowed(jComponent2, "CENTER")) {
                return this.dock(iDockable, iDockingPort, perspective, "CENTER", null);
            }
            IDockingPort iDockingPort2 = (IDockingPort)((Object)SwingUtilities.getAncestorOfClass(IDockingPort.class, iDockingPort.getComponent()));
            if (iDockingPort2 != null) {
                iDockingPort = iDockingPort2;
            }
            return this.dock(iDockable, iDockingPort, perspective, string, this.getLastNode());
        }
        return this.dockExtendedPath(iDockable, iDockingPort, perspective, string, this.getLastNode());
    }

    private boolean dockExtendedPath(IDockable iDockable, IDockingPort iDockingPort, Perspective perspective, String string, PerspectiveModel.SplitNode splitNode) {
        JComponent jComponent = iDockingPort.getDockedComponent();
        if (jComponent != null && !(jComponent instanceof JSplitPane)) {
            throw new RuntimeException("Illegaal docked: " + jComponent);
        }
        PerspectiveModel.SplitNode splitNode2 = this.getLastNode();
        String string2 = splitNode2 == null ? null : splitNode2.getSiblingId();
        Set<IDockable> set = iDockingPort.getDockables();
        Iterator<IDockable> iterator = set.iterator();
        while (string2 != null && iterator.hasNext()) {
            IDockable iDockable2 = iterator.next();
            if (!iDockable2.getID().equals(string2)) continue;
            IDockingPort iDockingPort2 = iDockable2.getDockingPort();
            String string3 = this.getRegion(splitNode2, iDockable2.getComponent());
            return this.dock(iDockable, iDockingPort2, perspective, string3, splitNode);
        }
        return this.dock(iDockable, iDockingPort, perspective, string, splitNode);
    }

    private String getRegion(PerspectiveModel.SplitNode splitNode, Component component) {
        if (component == null) {
            return "CENTER";
        }
        return DockingUtility.getRegion(splitNode.getRegion());
    }

    PerspectiveModel.SplitNode getLastNode() {
        return this.nodes.size() == 0 ? null : this.nodes.get(this.nodes.size() - 1);
    }

    private boolean dock(IDockable iDockable, IDockingPort iDockingPort, Perspective perspective, String string, PerspectiveModel.SplitNode splitNode) {
        boolean bl = DockingManager.dock(iDockable, iDockingPort, perspective, string);
        if (this.tabbed || splitNode == null) {
            return bl;
        }
        this.resizeSplitPane(iDockable, splitNode.getSplitRatio());
        return bl;
    }

    private void resizeSplitPane(IDockable iDockable, float f) {
        Dockbar dockbar;
        Container container;
        Container container2 = iDockable.getComponent().getParent();
        Container container3 = container = container2 == null ? null : container2.getParent();
        if (!(container instanceof JSplitPane)) {
            return;
        }
        JSplitPane jSplitPane = (JSplitPane)container;
        int n = jSplitPane.getOrientation();
        int n2 = n == 0 ? jSplitPane.getParent().getHeight() : jSplitPane.getParent().getWidth();
        DockbarManager dockbarManager = DockbarManager.getCurrent(iDockable);
        Dockbar dockbar2 = dockbar = dockbarManager == null ? null : dockbarManager.getDockbar(iDockable);
        if (dockbar != null && dockbar.getComponentCount() == 2) {
            n2 += dockbar.getPlacement() == 3 ? dockbar.getHeight() : dockbar.getWidth();
        }
        this.validateSplitDividerLocation(jSplitPane, n2, f);
    }

    private void validateSplitDividerLocation(JSplitPane jSplitPane, int n, float f) {
        JSplitPane jSplitPane2;
        int n2 = jSplitPane.getDividerLocation();
        int n3 = jSplitPane.getDividerSize();
        if (n2 > n || f < 0.0f) {
            f = (float)n2 / (float)(jSplitPane.getOrientation() == 0 ? jSplitPane.getHeight() : jSplitPane.getWidth());
        }
        float f2 = jSplitPane.getOrientation() == 0 ? jSplitPane.getRightComponent().getMinimumSize().height : jSplitPane.getRightComponent().getMinimumSize().width;
        float f3 = 1.0f - f2 / (float)(n - n3);
        f = Math.min(f, f3);
        float f4 = jSplitPane.getOrientation() == 0 ? jSplitPane.getLeftComponent().getMinimumSize().height : jSplitPane.getLeftComponent().getMinimumSize().width;
        float f5 = f4 / (float)(n - n3);
        f = Math.max(f, f5);
        jSplitPane.setDividerLocation((int)((float)(n - n3) * f));
        if (jSplitPane.getLeftComponent() instanceof DockingPort && ((DockingPort)jSplitPane.getLeftComponent()).getDockedComponent() instanceof JSplitPane) {
            jSplitPane2 = (JSplitPane)((DockingPort)jSplitPane.getLeftComponent()).getDockedComponent();
            if (jSplitPane.getOrientation() == jSplitPane2.getOrientation()) {
                this.validateSplitDividerLocation(jSplitPane2, (int)((float)(n - n3) * f), -1.0f);
            }
        }
        if (jSplitPane.getRightComponent() instanceof DockingPort && ((DockingPort)jSplitPane.getRightComponent()).getDockedComponent() instanceof JSplitPane) {
            jSplitPane2 = (JSplitPane)((DockingPort)jSplitPane.getRightComponent()).getDockedComponent();
            if (jSplitPane.getOrientation() == jSplitPane2.getOrientation()) {
                this.validateSplitDividerLocation(jSplitPane2, (int)((float)(n - n3) * (1.0f - f)), -1.0f);
            }
        }
    }

    private static IDockable findDockable(Component component) {
        return DockingManager.getDockable(component);
    }

    private static IDockable findDockable(String string) {
        return DockingManager.getDockable(string);
    }

    private static boolean isDocked(IDockable iDockable) {
        return DockingManager.isDocked(iDockable);
    }

    public int getDepth() {
        return this.nodes.size();
    }

    PerspectiveModel.SplitNode getNode(int n) {
        return n < 0 || n >= this.getDepth() ? null : this.nodes.get(n);
    }

    public String toString() {
        if (this.stringForm == null) {
            StringBuffer stringBuffer = new StringBuffer("/RootPort[id=").append(this.rootPortID).append("]");
            for (PerspectiveModel.SplitNode splitNode : this.nodes) {
                stringBuffer.append("/").append(splitNode.toString());
            }
            stringBuffer.append("/Dockable");
            this.stringForm = stringBuffer.toString();
        }
        return this.stringForm;
    }

    public Object clone() {
        ArrayList<PerspectiveModel.SplitNode> arrayList = null;
        if (this.nodes != null) {
            arrayList = new ArrayList<PerspectiveModel.SplitNode>(this.nodes.size());
            for (PerspectiveModel.SplitNode iDockingConstants2 : this.nodes) {
                arrayList.add((PerspectiveModel.SplitNode)iDockingConstants2.clone());
            }
        }
        DockingPath dockingPath = new DockingPath(this.siblingID, this.tabbed, arrayList);
        dockingPath.rootPortID = this.rootPortID;
        return dockingPath;
    }
}

