/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.Locale;
import java.util.Objects;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class HtmlTextPane
extends JTextPane {
    public HtmlTextPane() {
        this.setEditable(false);
        this.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent event) {
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    GUIHelper.showURL(event.getURL().toExternalForm());
                }
            }
        });
    }

    public void updateText(String originalText) {
        String newText;
        String text = InstallerUtil.sanitizeHTML(originalText);
        try {
            newText = this.getText();
        }
        catch (Exception e) {
            newText = "";
        }
        if (!Objects.equals(newText, text)) {
            boolean html = text.toLowerCase(Locale.ENGLISH).contains("<html");
            if (html) {
                this.setEditorKit(new HTMLEditorKit());
                Font font = UIManager.getFont("TextField.font");
                StyleSheet css = ((HTMLDocument)this.getDocument()).getStyleSheet();
                css.addRule("body {font-size : " + font.getSize() + "pt; }");
                css.addRule("body {font-family :" + font.getFontName() + "; }");
                css.addRule("body {background-color : #FFFFFF}");
            } else {
                this.setEditorKit(new StyledEditorKit());
                this.setText("");
                this.setEditorKit(new StyledEditorKit());
                this.setFont(UIManager.getFont("TextField.font"));
            }
            this.setText(text);
            this.setCaretPosition(0);
            this.scrollRectToVisible(new Rectangle(0, 0, 0, 0));
        }
    }
}

