/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.launcher.integration;

import com.install4j.runtime.installer.helper.launching.LaunchDescriptor;
import com.install4j.runtime.installer.helper.launching.LaunchHelper;
import com.install4j.runtime.installer.platform.macos.MacFileSystem;
import com.install4j.runtime.installer.platform.macos.MacLog;
import com.install4j.runtime.installer.platform.win32.Common;
import com.install4j.runtime.launcher.integration.AutomaticUpdate;
import com.install4j.runtime.launcher.integration.LockFile;
import java.io.File;
import java.io.IOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SingleBundleUpdater {
    private static final String LOG_PREFIX = "install4j bundle updater: ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block33: {
            SingleBundleUpdater.log("starting");
            Common.init();
            File sourceBundle = new File(args[0]);
            File destinationBundle = new File(new File(args[1]), sourceBundle.getName());
            if (!sourceBundle.getPath().endsWith(".app") || !destinationBundle.getPath().endsWith(".app")) {
                SingleBundleUpdater.log("wrong parameters " + sourceBundle.getPath() + ", " + destinationBundle.getPath());
                System.exit(1);
            }
            boolean restartLauncher = Boolean.parseBoolean(args[2]);
            List<String> launcherArguments = Arrays.asList(args).subList(3, args.length);
            LockFile.waitForLockFile();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                SingleBundleUpdater.log(e);
            }
            File backupDir = null;
            boolean success = false;
            try {
                backupDir = SingleBundleUpdater.moveBundle(sourceBundle, destinationBundle);
                success = true;
                MacFileSystem.notifyBundleChange(destinationBundle);
            }
            catch (Throwable e) {
                SingleBundleUpdater.log(e);
            }
            SingleBundleUpdater.log("result: " + success + ", restart: " + restartLauncher);
            try {
                AutomaticUpdate.checkRegularExit(success, false);
                if (restartLauncher) {
                    File launchBundle;
                    File file = launchBundle = success ? destinationBundle : AutomaticUpdate.getCurrentSingleBundle();
                    if (launchBundle != null) {
                        ArrayList<String> command = new ArrayList<String>();
                        command.add("/usr/bin/open");
                        command.add(launchBundle.getAbsolutePath());
                        if (!launcherArguments.isEmpty()) {
                            command.add("--args");
                            command.addAll(launcherArguments);
                        }
                        try {
                            new ProcessBuilder(command).start();
                        }
                        catch (IOException e) {
                            SingleBundleUpdater.log(e);
                        }
                    }
                }
                if (!success) break block33;
            }
            catch (Throwable throwable) {
                if (success) {
                    try {
                        if (destinationBundle.getAbsolutePath().startsWith("/Applications/")) {
                            SingleBundleUpdater.log("changing group of " + destinationBundle.getAbsolutePath() + " to admin");
                            LaunchHelper.launchApplication(new LaunchDescriptor(new File("/usr/sbin/chown")).arguments("-R", ":admin", destinationBundle.getAbsolutePath()).wait(false));
                        }
                    }
                    catch (Throwable t) {
                        SingleBundleUpdater.log(t);
                    }
                    boolean newBundleLocation = false;
                    try {
                        File currentSingleBundle = AutomaticUpdate.getCurrentSingleBundle();
                        boolean bl = newBundleLocation = currentSingleBundle != null && !destinationBundle.getCanonicalFile().equals(currentSingleBundle.getCanonicalFile());
                        if (newBundleLocation) {
                            SingleBundleUpdater.log("removing previous bundle at " + currentSingleBundle);
                            SingleBundleUpdater.deleteRecursive(currentSingleBundle);
                        }
                    }
                    catch (IOException e) {
                        SingleBundleUpdater.log(e);
                    }
                    if (backupDir != null) {
                        if (newBundleLocation) {
                            SingleBundleUpdater.log("keeping backup at " + backupDir + " because a different app was replaced");
                        } else {
                            SingleBundleUpdater.log("removing backup at " + backupDir);
                            SingleBundleUpdater.deleteRecursive(backupDir);
                            if (backupDir.exists()) {
                                SingleBundleUpdater.log("could not fully remove backup at " + backupDir);
                            }
                        }
                    }
                }
                SingleBundleUpdater.log("exiting");
                System.exit(0);
                throw throwable;
            }
            try {
                if (destinationBundle.getAbsolutePath().startsWith("/Applications/")) {
                    SingleBundleUpdater.log("changing group of " + destinationBundle.getAbsolutePath() + " to admin");
                    LaunchHelper.launchApplication(new LaunchDescriptor(new File("/usr/sbin/chown")).arguments("-R", ":admin", destinationBundle.getAbsolutePath()).wait(false));
                }
            }
            catch (Throwable t) {
                SingleBundleUpdater.log(t);
            }
            boolean newBundleLocation = false;
            try {
                File currentSingleBundle = AutomaticUpdate.getCurrentSingleBundle();
                boolean bl = newBundleLocation = currentSingleBundle != null && !destinationBundle.getCanonicalFile().equals(currentSingleBundle.getCanonicalFile());
                if (newBundleLocation) {
                    SingleBundleUpdater.log("removing previous bundle at " + currentSingleBundle);
                    SingleBundleUpdater.deleteRecursive(currentSingleBundle);
                }
            }
            catch (IOException e) {
                SingleBundleUpdater.log(e);
            }
            if (backupDir != null) {
                if (newBundleLocation) {
                    SingleBundleUpdater.log("keeping backup at " + backupDir + " because a different app was replaced");
                } else {
                    SingleBundleUpdater.log("removing backup at " + backupDir);
                    SingleBundleUpdater.deleteRecursive(backupDir);
                    if (backupDir.exists()) {
                        SingleBundleUpdater.log("could not fully remove backup at " + backupDir);
                    }
                }
            }
        }
        SingleBundleUpdater.log("exiting");
        System.exit(0);
    }

    private static File getNonExistingBackupDir(File directory, String baseName) {
        File result = null;
        for (int index = 1; index < 1000000 && (result == null || result.exists()); ++index) {
            result = new File(directory, "." + index + "." + baseName);
        }
        return result;
    }

    private static File moveBundle(File sourceBundle, File destinationBundle) throws IOException, InterruptedException {
        File backupDir = SingleBundleUpdater.doBackup(destinationBundle);
        SingleBundleUpdater.log("moving bundle from " + sourceBundle + " to " + destinationBundle);
        try {
            try {
                SingleBundleUpdater.executeMove(false, sourceBundle, destinationBundle, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (AtomicMoveNotSupportedException e) {
                SingleBundleUpdater.executeMove(true, sourceBundle, destinationBundle, new StandardCopyOption[0]);
            }
        }
        catch (Throwable t) {
            SingleBundleUpdater.restoreBackup(backupDir, destinationBundle);
            throw t;
        }
        return backupDir;
    }

    private static void restoreBackup(File backupDir, File destinationBundle) {
        if (backupDir != null) {
            SingleBundleUpdater.log("restoring backup from " + backupDir + " to " + destinationBundle);
            SingleBundleUpdater.deleteRecursive(destinationBundle);
            try {
                try {
                    SingleBundleUpdater.executeMove(false, backupDir, destinationBundle, StandardCopyOption.ATOMIC_MOVE);
                }
                catch (AtomicMoveNotSupportedException e) {
                    SingleBundleUpdater.executeMove(false, backupDir, destinationBundle, new StandardCopyOption[0]);
                }
            }
            catch (Throwable t2) {
                SingleBundleUpdater.log(t2);
            }
        }
    }

    private static void executeMove(boolean fallbackToCopy, File sourceBundle, File destinationBundle, StandardCopyOption ... copyOptions) throws IOException {
        try {
            Files.move(sourceBundle.toPath(), destinationBundle.toPath(), copyOptions);
        }
        catch (IOException e) {
            if (fallbackToCopy) {
                SingleBundleUpdater.log("fallback to copy for move from " + sourceBundle + " to " + destinationBundle);
                destinationBundle.mkdirs();
                SingleBundleUpdater.copyDirectory(sourceBundle, destinationBundle);
            }
            throw e;
        }
    }

    private static void copyDirectory(File sourceDir, File targetDir) throws IOException {
        File[] files = sourceDir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            File sourceFile = new File(sourceDir, file.getName()).getCanonicalFile();
            File targetFile = new File(targetDir, sourceFile.getName());
            if (sourceFile.isDirectory()) {
                if (!targetFile.exists() && !targetFile.mkdirs()) {
                    throw new IOException("Cannot create " + targetDir.getPath());
                }
                SingleBundleUpdater.copyDirectory(sourceFile, targetFile);
                continue;
            }
            Files.copy(sourceFile.toPath(), targetFile.toPath(), new CopyOption[0]);
        }
    }

    private static File doBackup(File destinationBundle) throws IOException {
        File backupDir = null;
        if (destinationBundle.exists()) {
            backupDir = SingleBundleUpdater.getNonExistingBackupDir(destinationBundle.getParentFile(), destinationBundle.getName());
            SingleBundleUpdater.log("backing up " + destinationBundle + " to " + backupDir);
            try {
                SingleBundleUpdater.executeMove(false, destinationBundle, backupDir, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (AtomicMoveNotSupportedException e) {
                SingleBundleUpdater.executeMove(false, destinationBundle, backupDir, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        return backupDir;
    }

    private static void deleteRecursive(File file) {
        if (!file.getPath().endsWith(".app")) {
            SingleBundleUpdater.log("did not execute delete for " + file.getPath());
        } else {
            SingleBundleUpdater.deleteRecursiveInt(file);
        }
    }

    private static void deleteRecursiveInt(File file) {
        File[] children;
        if (file.isDirectory() && (children = file.listFiles()) != null) {
            for (File child : children) {
                SingleBundleUpdater.deleteRecursiveInt(child);
            }
        }
        file.delete();
    }

    private static void log(String message) {
        MacLog.log(LOG_PREFIX + message);
    }

    private static void log(Throwable e) {
        MacLog.log(LOG_PREFIX, e);
    }
}

