/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.filechooser;

import com.install4j.api.Util;
import com.install4j.runtime.alert.Alert;
import com.install4j.runtime.filechooser.AbstractFileSystemChooser;
import com.install4j.runtime.filechooser.FileAccessMode;
import com.install4j.runtime.filechooser.FileChooserQuestion;
import com.install4j.runtime.filechooser.MacosFileChooser;
import com.install4j.runtime.filechooser.MultiFileFilter;
import com.install4j.runtime.filechooser.SwingFileChooser;
import com.install4j.runtime.filechooser.WindowsFileChooser;
import com.install4j.runtime.util.I4jLibraryHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class FileChooser
extends AbstractFileSystemChooser<FileChooser> {
    private FileAccessMode fileAccessMode = FileAccessMode.OPEN;
    private List<MultiFileFilter> fileFilters = new ArrayList<MultiFileFilter>();
    private MultiFileFilter selectedFileFilter;
    private Collection<FileChooserQuestion> fileChooserQuestions = new ArrayList<FileChooserQuestion>();
    private boolean multiple = false;

    public static FileChooser create() {
        if (Alert.isNoNativeDialogs()) {
            return new SwingFileChooser();
        }
        if (Util.isAtLeastWindowsVista() && I4jLibraryHelper.isI4jLibraryAvailable()) {
            return new WindowsFileChooser();
        }
        if (Util.isMacOS()) {
            return new MacosFileChooser();
        }
        return new SwingFileChooser();
    }

    protected FileChooser() {
    }

    protected abstract Collection<File> getSelectedFilesInternal();

    @Override
    protected Collection<File> getAllFiles() {
        return this.getSelectedFilesInternal();
    }

    public Collection<File> getSelectedFiles() {
        this.checkSelected();
        if (!this.multiple) {
            throw new RuntimeException("File chooser was not configured for multiple selection");
        }
        return this.getSelectedFilesInternal();
    }

    public File getSelectedFile() {
        this.checkSelected();
        if (this.multiple) {
            throw new RuntimeException("File chooser was not configured for single selection");
        }
        Collection<File> files = this.getSelectedFilesInternal();
        assert (files.size() == 1);
        return files.iterator().next();
    }

    public FileAccessMode getFileAccessMode() {
        return this.fileAccessMode;
    }

    public FileChooser fileAccessMode(FileAccessMode fileAccessMode) {
        this.fileAccessMode = fileAccessMode;
        return this;
    }

    public List<MultiFileFilter> getFileFilters() {
        return this.fileFilters;
    }

    public FileChooser fileFilters(List<MultiFileFilter> fileFilters) {
        this.fileFilters = fileFilters;
        return this;
    }

    public FileChooser addFileFilter(MultiFileFilter fileFilter) {
        if (fileFilter != null) {
            this.fileFilters.add(fileFilter);
        }
        return this;
    }

    public MultiFileFilter getSelectedFileFilter() {
        return this.selectedFileFilter;
    }

    public FileChooser selectedFileFilter(MultiFileFilter selectedFileFilter) {
        this.selectedFileFilter = selectedFileFilter;
        return this;
    }

    public Collection<FileChooserQuestion> getFileChooserQuestions() {
        return this.fileChooserQuestions;
    }

    public FileChooser fileChooserQuestions(Collection<FileChooserQuestion> fileChooserQuestions) {
        this.fileChooserQuestions = fileChooserQuestions;
        return this;
    }

    public FileChooser addFileChooserQuestion(FileChooserQuestion fileChooserQuestion) {
        this.fileChooserQuestions.add(fileChooserQuestion);
        return this;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public FileChooser multiple(boolean multiple) {
        this.multiple = multiple;
        return this;
    }
}

