/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.filechooser;

import com.install4j.api.Util;
import com.install4j.runtime.util.WindowsLafHelper;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class CustomFileChooser
extends JFileChooser
implements HierarchyListener {
    private static File lastDir = null;
    private JComponent lowerAccessory;

    public CustomFileChooser() {
        if (Boolean.getBoolean("ejt.noShellFolder")) {
            this.putClientProperty("FileChooser.useShellFolder", Boolean.FALSE);
        }
        this.init(false);
    }

    public CustomFileChooser(String currentDirectoryPath) {
        super(currentDirectoryPath);
        this.init(currentDirectoryPath != null);
    }

    public CustomFileChooser(File currentDirectory) {
        super(currentDirectory);
        this.init(currentDirectory != null);
    }

    @Override
    public void hierarchyChanged(HierarchyEvent event) {
        JDialog dialog;
        if ((event.getChangeFlags() & 1L) != 0L && (dialog = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, this)) != null) {
            dialog.setBackground(UIManager.getColor("control"));
        }
    }

    @Override
    public void approveSelection() {
        lastDir = this.getCurrentDirectory();
        super.approveSelection();
    }

    @Override
    public void setCurrentDirectory(File currentDirectory) {
        if (currentDirectory == null) {
            currentDirectory = lastDir;
        }
        super.setCurrentDirectory(currentDirectory);
    }

    private void init(boolean directorySet) {
        this.putClientProperty("JFileChooser.appBundleIsTraversable", "always");
        this.putClientProperty("JFileChooser.packageIsTraversable", "always");
        this.addHierarchyListener(this);
        if (!directorySet && lastDir != null) {
            this.setCurrentDirectory(lastDir);
        }
    }

    public JComponent getLowerAccessory() {
        return this.lowerAccessory;
    }

    public void setLowerAccessory(JComponent lowerAccessory) {
        this.lowerAccessory = lowerAccessory;
    }

    @Override
    public int showDialog(Component parent, String approveButtonText) {
        return super.showDialog(parent, Util.isMacOS() ? null : approveButtonText);
    }

    @Override
    protected JDialog createDialog(Component component) {
        Window parentWindow;
        boolean macOS = Util.isMacOS();
        JDialog dialog = super.createDialog(macOS ? null : component);
        this.addLowerAccessory(dialog);
        if (macOS && (parentWindow = component instanceof Window ? (Window)component : (Window)SwingUtilities.getAncestorOfClass(Window.class, component)) != null) {
            Rectangle bounds = parentWindow.getBounds();
            int deltaX = bounds.width - dialog.getWidth();
            int deltaY = bounds.height - dialog.getHeight();
            bounds.x += deltaX / 2;
            bounds.width -= deltaX;
            bounds.y += deltaY / 2;
            bounds.height -= deltaY;
            if (bounds.x < 0) {
                bounds.translate(-bounds.x, 0);
            }
            if (bounds.y < 0) {
                bounds.translate(0, -bounds.y);
            }
            dialog.setBounds(bounds);
        }
        return dialog;
    }

    private void addLowerAccessory(JDialog dialog) {
        if (this.lowerAccessory == null) {
            return;
        }
        Container contentPane = dialog.getContentPane();
        contentPane.add((Component)this.lowerAccessory, "South");
        dialog.pack();
    }

    public static JPanel createLowerAccessoryPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        int left = 5;
        if (WindowsLafHelper.isWindowsLaF()) {
            left = 100;
        }
        panel.setBorder(BorderFactory.createEmptyBorder(2, left, 5, 5));
        return panel;
    }
}

