/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.registry;

import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.registry.PreferencesReadAction;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class ReadPreferenceKeyAction
extends PreferencesReadAction {
    private String key = "";
    private String variableName = "";
    private boolean useDefault = false;
    private String defaultValue = "";

    public String getKey() {
        return ReadPreferenceKeyAction.replaceVariables(this.key);
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public boolean isUseDefault() {
        return this.useDefault;
    }

    public void setUseDefault(boolean useDefault) {
        this.useDefault = useDefault;
    }

    public String getDefaultValue() {
        return ReadPreferenceKeyAction.replaceVariables(this.defaultValue);
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public boolean execute(Context context) throws UserCanceledException {
        return this.executePreferencesReader(new ReadKeyPreferencesReader(this.getKey(), this.isUseDefault() ? this.getDefaultValue() : null, this.getVariableName()), context);
    }

    private static class ReadKeyPreferencesReader
    implements PreferencesReadAction.PreferencesReader {
        private String key;
        private String defaultValue;
        private String variableName;

        public ReadKeyPreferencesReader(String key, String defaultValue, String variableName) {
            this.key = key;
            this.defaultValue = defaultValue;
            this.variableName = variableName;
        }

        @Override
        public boolean readFromPreferences(Preferences packageNode, Context context) throws BackingStoreException {
            String value = packageNode.get(this.key, this.defaultValue);
            if (value != null) {
                context.setVariable(this.variableName, value);
                return true;
            }
            return false;
        }
    }
}

