/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.net;

import com.install4j.api.context.Context;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.net.AbstractHttpRequestAction;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.NoPercentageProgressDelegate;
import com.install4j.runtime.installer.frontend.VariableResourceBundleWrapper;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.content.Uploader;
import java.io.File;
import java.io.IOException;

public class UploadFileAction
extends AbstractHttpRequestAction {
    private File file;
    private boolean showProgress = true;
    private boolean showFileName = true;
    private boolean retryIfInterrupted = true;

    public File getFile() {
        return UploadFileAction.replaceVariables(this.file);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public boolean isShowProgress() {
        return this.showProgress;
    }

    public void setShowProgress(boolean showProgress) {
        this.showProgress = showProgress;
    }

    public boolean isShowFileName() {
        return this.showFileName;
    }

    public void setShowFileName(boolean showFileName) {
        this.showFileName = showFileName;
    }

    public boolean isRetryIfInterrupted() {
        return this.retryIfInterrupted;
    }

    public void setRetryIfInterrupted(boolean retryIfInterrupted) {
        this.retryIfInterrupted = retryIfInterrupted;
    }

    @Override
    public boolean execute(Context context) throws UserCanceledException {
        VariableResourceBundleWrapper messages = Messages.getMessages();
        File file = context.getDestinationFile(this.getFile());
        ProgressInterface progressInterface = context.getProgressInterface();
        if (this.showProgress) {
            if (this.showFileName) {
                String fileName = file.getName();
                progressInterface.setStatusMessage("<html><nobr>" + Messages.format(messages.getString("UploadingWithFileName"), "<b>" + fileName + "</b>") + "</nobr>");
            } else {
                progressInterface.setStatusMessage(messages.getString("Uploading"));
            }
        } else {
            progressInterface = new NoPercentageProgressDelegate(progressInterface);
        }
        try {
            Uploader uploader = this.createUploader(context, this.showProgress ? progressInterface : null);
            return UploadFileAction.doUpload(uploader, context, file, this.getUrl(), this.isRetryIfInterrupted());
        }
        catch (IOException e) {
            Logger.getInstance().error(this, "Could not upload file");
            Logger.getInstance().log(e);
            return false;
        }
    }

    private Uploader createUploader(Context context, ProgressInterface progressInterface) {
        Uploader uploader = new Uploader(context, progressInterface);
        this.applyCommonProperties(uploader);
        return uploader;
    }

    private static boolean doUpload(Uploader uploader, Context context, File file, String url, boolean retryIfInterrupted) throws IOException, UserCanceledException {
        boolean retry;
        do {
            try {
                int responseCode = uploader.upload(url, file);
                boolean success = responseCode / 200 == 1;
                Logger.getInstance().log(null, "Upload finished with response code " + responseCode, success);
                return success;
            }
            catch (IOException e) {
                if (retryIfInterrupted) {
                    Logger.getInstance().error(null, "Could not upload file");
                    Logger.getInstance().log(e);
                    retry = UploadFileAction.askRetry("UploadInterrupted");
                    continue;
                }
                throw e;
            }
            catch (UserCanceledException e) {
                if (context.isCancelling()) {
                    throw e;
                }
                return false;
            }
        } while (retry);
        return false;
    }

    @Override
    public boolean isRollbackSupported() {
        return false;
    }
}

