/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.misc;

import com.install4j.api.Util;
import com.install4j.api.beans.PropertyLoggingInterceptor;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.launching.InputRedirection;
import com.install4j.runtime.installer.helper.launching.InputRedirectionMode;
import com.install4j.runtime.installer.helper.launching.LaunchDescriptor;
import com.install4j.runtime.installer.helper.launching.LaunchHelper;
import com.install4j.runtime.installer.helper.launching.OutputRedirection;
import com.install4j.runtime.installer.helper.launching.OutputRedirectionMode;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class RunExecutableAction
extends SystemInstallOrUninstallAction
implements PropertyLoggingInterceptor {
    public static final String PROPERTY_ARGUMENTS = "arguments";
    private File executable;
    private File workingDirectory;
    private String[] arguments;
    private boolean useRollbackExecutable = false;
    private File rollbackExecutable;
    private File rollbackWorkingDirectory;
    private String[] rollbackArguments;
    private boolean wait = false;
    private boolean waitForStreams = true;
    private String returnCodeVariable = "";
    private int timeout = 0;
    private boolean logArguments = false;
    private OutputRedirectionMode stdoutRedirectionMode = OutputRedirectionMode.NONE;
    private String stdoutVariableName = "";
    private File stdoutFile;
    private boolean failOnStdoutFileError = false;
    private OutputRedirectionMode stderrRedirectionMode = OutputRedirectionMode.NONE;
    private File stderrFile;
    private String stderrVariableName = "";
    private boolean failOnStderrFileError = false;
    private InputRedirectionMode stdinRedirectionMode = InputRedirectionMode.NONE;
    private File stdinFile;
    private String stdinString = "";
    private boolean failOnStdinFileError = false;
    private boolean includeParentEnvironmentVariables = true;
    private Map<String, String> environmentVariables = new LinkedHashMap<String, String>();
    private boolean showWindowsConsole = false;
    private boolean keepConsoleWindow = false;

    public File getExecutable() {
        return RunExecutableAction.replaceVariables(this.executable);
    }

    public void setExecutable(File executable) {
        this.executable = executable;
    }

    public File getWorkingDirectory() {
        return RunExecutableAction.replaceVariables(this.workingDirectory);
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public String[] getArguments() {
        return RunExecutableAction.replaceVariables(this.arguments);
    }

    public void setArguments(String[] arguments) {
        this.arguments = arguments;
    }

    public boolean isUseRollbackExecutable() {
        return this.useRollbackExecutable;
    }

    public void setUseRollbackExecutable(boolean useRollbackExecutable) {
        this.useRollbackExecutable = useRollbackExecutable;
    }

    public File getRollbackExecutable() {
        return RunExecutableAction.replaceVariables(this.rollbackExecutable);
    }

    public void setRollbackExecutable(File rollbackExecutable) {
        this.rollbackExecutable = rollbackExecutable;
    }

    public File getRollbackWorkingDirectory() {
        return RunExecutableAction.replaceVariables(this.rollbackWorkingDirectory);
    }

    public void setRollbackWorkingDirectory(File rollbackWorkingDirectory) {
        this.rollbackWorkingDirectory = rollbackWorkingDirectory;
    }

    public String[] getRollbackArguments() {
        return RunExecutableAction.replaceVariables(this.rollbackArguments);
    }

    public void setRollbackArguments(String[] rollbackArguments) {
        this.rollbackArguments = rollbackArguments;
    }

    public boolean isWait() {
        return this.wait;
    }

    public void setWait(boolean wait) {
        this.wait = wait;
    }

    public boolean isWaitForStreams() {
        return this.waitForStreams;
    }

    public void setWaitForStreams(boolean waitForStreams) {
        this.waitForStreams = waitForStreams;
    }

    public String getReturnCodeVariable() {
        return this.returnCodeVariable;
    }

    public void setReturnCodeVariable(String returnCodeVariable) {
        this.returnCodeVariable = returnCodeVariable;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean isLogArguments() {
        return this.logArguments;
    }

    public void setLogArguments(boolean logArguments) {
        this.logArguments = logArguments;
    }

    public OutputRedirectionMode getStdoutRedirectionMode() {
        return this.stdoutRedirectionMode;
    }

    public void setStdoutRedirectionMode(OutputRedirectionMode stdoutRedirectionMode) {
        this.stdoutRedirectionMode = stdoutRedirectionMode;
    }

    public String getStdoutVariableName() {
        return RunExecutableAction.replaceVariables(this.stdoutVariableName);
    }

    public void setStdoutVariableName(String stdoutVariableName) {
        this.stdoutVariableName = stdoutVariableName;
    }

    public File getStdoutFile() {
        return RunExecutableAction.replaceVariables(this.stdoutFile);
    }

    public void setStdoutFile(File stdoutFile) {
        this.stdoutFile = stdoutFile;
    }

    public boolean isFailOnStdoutFileError() {
        return this.failOnStdoutFileError;
    }

    public void setFailOnStdoutFileError(boolean failOnStdoutFileError) {
        this.failOnStdoutFileError = failOnStdoutFileError;
    }

    public OutputRedirectionMode getStderrRedirectionMode() {
        return this.stderrRedirectionMode;
    }

    public void setStderrRedirectionMode(OutputRedirectionMode stderrRedirectionMode) {
        this.stderrRedirectionMode = stderrRedirectionMode;
    }

    public String getStderrVariableName() {
        return RunExecutableAction.replaceVariables(this.stderrVariableName);
    }

    public void setStderrVariableName(String stderrVariableName) {
        this.stderrVariableName = stderrVariableName;
    }

    public File getStderrFile() {
        return RunExecutableAction.replaceVariables(this.stderrFile);
    }

    public void setStderrFile(File stderrFile) {
        this.stderrFile = stderrFile;
    }

    public boolean isFailOnStderrFileError() {
        return this.failOnStderrFileError;
    }

    public void setFailOnStderrFileError(boolean failOnStderrFileError) {
        this.failOnStderrFileError = failOnStderrFileError;
    }

    public InputRedirectionMode getStdinRedirectionMode() {
        return this.stdinRedirectionMode;
    }

    public void setStdinRedirectionMode(InputRedirectionMode stdinRedirectionMode) {
        this.stdinRedirectionMode = stdinRedirectionMode;
    }

    public String getStdinString() {
        return RunExecutableAction.replaceVariables(this.stdinString);
    }

    public void setStdinString(String stdinString) {
        this.stdinString = stdinString;
    }

    public File getStdinFile() {
        return RunExecutableAction.replaceVariables(this.stdinFile);
    }

    public void setStdinFile(File stdinFile) {
        this.stdinFile = stdinFile;
    }

    public boolean isFailOnStdinFileError() {
        return this.failOnStdinFileError;
    }

    public void setFailOnStdinFileError(boolean failOnStdinFileError) {
        this.failOnStdinFileError = failOnStdinFileError;
    }

    public boolean isIncludeParentEnvironmentVariables() {
        return this.includeParentEnvironmentVariables;
    }

    public void setIncludeParentEnvironmentVariables(boolean includeParentEnvironmentVariables) {
        this.includeParentEnvironmentVariables = includeParentEnvironmentVariables;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void setEnvironmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public boolean isShowWindowsConsole() {
        return this.showWindowsConsole;
    }

    public void setShowWindowsConsole(boolean showWindowsConsole) {
        this.showWindowsConsole = showWindowsConsole;
    }

    public boolean isKeepConsoleWindow() {
        return this.keepConsoleWindow;
    }

    public void setKeepConsoleWindow(boolean keepConsoleWindow) {
        this.keepConsoleWindow = keepConsoleWindow;
    }

    @Override
    public Object getLogValueForProperty(String propertyName, Object propertyValue) {
        if (Objects.equals(propertyName, PROPERTY_ARGUMENTS) && !this.logArguments) {
            return "[logging of arguments is disabled]";
        }
        return propertyValue;
    }

    @Override
    public boolean execute(Context context) throws UserCanceledException {
        return this.runExecutable(this.getExecutable(), this.getWorkingDirectory(), this.getArguments(), context);
    }

    private boolean runExecutable(File executable, File workingDirectory, String[] arguments, Context context) {
        Integer returnValue;
        File workingDir;
        for (workingDir = context.getDestinationFile(workingDirectory); workingDir != null && !workingDir.exists(); workingDir = workingDir.getParentFile()) {
        }
        Logger.getInstance().info(this, "used working dir: " + workingDir);
        File usedExecutable = this.getUsedExecutable(workingDir, context, executable);
        if (!usedExecutable.exists()) {
            Logger.getInstance().error(this, "executable does not exist: " + usedExecutable.getAbsolutePath());
            return false;
        }
        OutputRedirection stdoutRedirection = new OutputRedirection(this.getStdoutRedirectionMode(), this.getStdoutVariableName(), this.getStdoutFile(), this.isFailOnStdoutFileError());
        OutputRedirection stderrRedirection = new OutputRedirection(this.getStderrRedirectionMode(), this.getStderrVariableName(), this.getStderrFile(), this.isFailOnStderrFileError());
        InputRedirection stdinRedirection = new InputRedirection(this.getStdinRedirectionMode(), this.getStdinString(), this.getStdinFile(), this.isFailOnStdinFileError());
        LaunchDescriptor launchDescriptor = new LaunchDescriptor(usedExecutable).workingDirectory(workingDir).arguments(arguments).specificEnvironmentVariables(this.environmentVariables).includeParentEnvironmentVariables(this.includeParentEnvironmentVariables).showWindowsConsole(this.showWindowsConsole).keepConsoleWindow(this.keepConsoleWindow).useNohup(!this.wait && !Util.isWindows() && !Util.isMacOS()).stdoutRedirection(stdoutRedirection).stderrRedirection(stderrRedirection).stdinRedirection(stdinRedirection).wait(this.wait).waitForStreams(this.waitForStreams).timeout(this.timeout);
        if (Util.isMacOS() && HelperCommunication.getInstance().isElevatedHelper()) {
            launchDescriptor.suidRoot(true);
        }
        if ((returnValue = LaunchHelper.launchApplication(launchDescriptor)) == null) {
            return false;
        }
        if (this.wait) {
            int code = returnValue;
            if (this.returnCodeVariable.length() > 0) {
                context.setVariable(this.returnCodeVariable, returnValue);
            }
            if (code != 0) {
                Logger.getInstance().error(this, "return value is " + code);
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isRollbackSupported() {
        return this.useRollbackExecutable;
    }

    @Override
    public void rollback(InstallerContext context) {
        super.rollback(context);
        this.runExecutable(this.getRollbackExecutable(), this.getRollbackWorkingDirectory(), this.getRollbackArguments(), context);
    }

    private File getUsedExecutable(File workingDir, Context context, File executable) {
        File workingDirExecutable;
        File usedExecutable = this.maybeWithExtension(context.getDestinationFile(executable));
        if (!usedExecutable.exists() && !executable.isAbsolute() && (workingDirExecutable = this.maybeWithExtension(new File(workingDir, executable.getPath()))).exists()) {
            usedExecutable = workingDirExecutable;
        }
        return usedExecutable;
    }

    private File maybeWithExtension(File file) {
        if (Util.isWindows() && !file.exists() && !file.getPath().toLowerCase(Locale.ENGLISH).endsWith(".exe")) {
            File fileWithExtension = new File(file.getPath() + ".exe");
            if (fileWithExtension.exists()) {
                return fileWithExtension;
            }
            return file;
        }
        return file;
    }
}

