/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.beans.actions.files.ArchiveFileOperationRoot;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.frontend.ProgressAdapter;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public abstract class AbstractZipFileAction
extends SystemInstallOrUninstallAction {
    private File zipFile;
    private ArchiveFileOperationRoot zipRoot = ArchiveFileOperationRoot.INSTALLATION_DIRECTORY;
    private boolean showProgress = true;
    private String fileNameEncoding;

    public boolean isShowProgress() {
        return this.showProgress;
    }

    public void setShowProgress(boolean showProgress) {
        this.showProgress = showProgress;
    }

    public File getZipFile() {
        return AbstractZipFileAction.replaceVariables(this.zipFile);
    }

    public void setZipFile(File zipFile) {
        this.zipFile = zipFile;
    }

    public ArchiveFileOperationRoot getZipRoot() {
        return this.zipRoot;
    }

    public void setZipRoot(ArchiveFileOperationRoot zipRoot) {
        this.zipRoot = zipRoot;
    }

    public String getFileNameEncoding() {
        return AbstractZipFileAction.replaceVariables(this.fileNameEncoding);
    }

    public void setFileNameEncoding(String fileNameEncoding) {
        this.fileNameEncoding = fileNameEncoding;
    }

    protected abstract File getTargetDirectory(Context var1);

    protected abstract boolean passesFileFilter(String var1, Context var2);

    protected void createFile(File destFile, ZipInputStream zipIn, ZipEntry zipEntry, long currentSize, ProgressAdapter progressAdapter) throws UserCanceledException, IOException {
        this.createDirectory(destFile.getParentFile());
        FileUtil.extractFile(zipIn, destFile, currentSize, progressAdapter, false);
    }

    protected void createDirectory(File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.mkdirs();
        }
    }

    @Override
    public boolean execute(Context context) throws UserCanceledException {
        File usedSourceFile = this.resolveRelativeFile(this.getZipFile(), this.getZipRoot(), context);
        if (!usedSourceFile.exists()) {
            Logger.getInstance().error(this, usedSourceFile + " does not exist");
            return false;
        }
        try {
            return this.zipActions(context, usedSourceFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            Logger.getInstance().error(this, "exception " + e);
            Logger.getInstance().log(e);
            return false;
        }
    }

    protected boolean zipActions(Context context, File usedSourceFile) throws IOException, UserCanceledException {
        this.extractZip(context, usedSourceFile, this.getTargetDirectory(context));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractZip(Context context, File sourceFile, File destDir) throws IOException, UserCanceledException {
        ProgressAdapter progressInterface = new ProgressAdapter(context.getProgressInterface(), 0, this.getExtractionPercent());
        boolean showProgress = this.isShowProgress();
        ArrayList<Long> fileSizes = new ArrayList<Long>();
        long maxProgress = Long.MAX_VALUE;
        if (showProgress) {
            progressInterface.setPercentCompleted(0);
            if (this.isShowFileNames()) {
                progressInterface.setDetailMessage("");
            }
            maxProgress = this.getMaxProgress(sourceFile, fileSizes);
        }
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(sourceFile));
        try (ZipInputStream zipIn = AbstractZipFileAction.createZipInputStream(in, this.getFileNameEncoding());){
            long currentProgress = 0L;
            int index = 0;
            ZipEntry zipEntry = zipIn.getNextEntry();
            while (zipEntry != null) {
                if (context.isCancelling()) {
                    throw new UserCanceledException();
                }
                String entryName = AbstractZipFileAction.getEntryName(zipEntry);
                if (this.passesFileFilter(entryName, context)) {
                    if (showProgress && this.isShowFileNames()) {
                        progressInterface.setDetailMessage(InstallerUtil.cleanupName(entryName));
                    }
                    long nextProgress = currentProgress + 153600L;
                    long currentSize = fileSizes.isEmpty() ? 0L : (Long)fileSizes.get(index++);
                    File destFile = new File(destDir, entryName);
                    this.saveInfo(destFile, zipEntry);
                    if (zipEntry.isDirectory()) {
                        this.createDirectory(destFile);
                        destFile.setLastModified(zipEntry.getTime());
                        this.directoryCreated(destFile);
                    } else {
                        nextProgress += currentSize;
                        ProgressAdapter progressAdapter = null;
                        if (showProgress) {
                            progressAdapter = new ProgressAdapter(progressInterface, (int)(currentProgress * 100L / maxProgress), (int)(nextProgress * 100L / maxProgress));
                        }
                        this.createFile(destFile, zipIn, zipEntry, currentSize, progressAdapter);
                        this.fileCreated(destFile);
                    }
                    if (context.isCancelling()) {
                        throw new UserCanceledException();
                    }
                    currentProgress = nextProgress;
                    if (showProgress) {
                        progressInterface.setPercentCompleted((int)(currentProgress * 100L / maxProgress));
                    }
                }
                zipEntry = zipIn.getNextEntry();
            }
        }
        finally {
            if (showProgress) {
                progressInterface.setPercentCompleted(100);
                if (this.isShowFileNames()) {
                    progressInterface.setDetailMessage("");
                }
            }
        }
    }

    protected void saveInfo(File destFile, ZipEntry zipEntry) {
    }

    private static ZipInputStream createZipInputStream(InputStream in, String encoding) {
        if (encoding != null && !encoding.isEmpty()) {
            try {
                return new ZipInputStream(in, Charset.forName(encoding));
            }
            catch (UnsupportedCharsetException e) {
                Logger.getInstance().log(e);
                return new ZipInputStream(in);
            }
        }
        return new ZipInputStream(in);
    }

    public boolean isShowFileNames() {
        return true;
    }

    protected int getExtractionPercent() {
        return 100;
    }

    protected void directoryCreated(File destFile) {
    }

    protected void fileCreated(File destFile) {
    }

    protected boolean matchesFileFilter(String entryName, Context context, ScriptProperty fileFilter) {
        File entryFile = new File(entryName);
        return ContextImpl.runBooleanScript(context, fileFilter, this, entryFile, entryName.endsWith(File.separator));
    }

    private static String getEntryName(ZipEntry zipEntry) {
        String zipName = zipEntry.getName();
        zipName = InstallerUtil.isWindows() ? zipName.replace('/', '\\') : zipName.replace('\\', '/');
        return zipName;
    }

    private long getMaxProgress(File sourceFile, List<Long> fileSizes) throws IOException {
        long maxProgress = 0L;
        try (ZipFile zipFile = AbstractZipFileAction.openZipFile(sourceFile, this.getFileNameEncoding());){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                long size = zipEntry.isDirectory() ? 0L : zipEntry.getSize();
                fileSizes.add(size);
                maxProgress += size + 153600L;
            }
            long l = maxProgress;
            return l;
        }
    }

    private static ZipFile openZipFile(File file, String encoding) throws IOException {
        if (encoding != null && !encoding.isEmpty()) {
            try {
                return new ZipFile(file, Charset.forName(encoding));
            }
            catch (UnsupportedCharsetException e) {
                Logger.getInstance().log(e);
                return new ZipFile(file);
            }
        }
        return new ZipFile(file);
    }
}

