/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc;

public class Host {
    private static final String COLON = ":";
    private String host;
    private int port = 0;

    public Host(String address) {
        int colon = address.lastIndexOf(COLON);
        if (colon != -1) {
            this.host = address.substring(0, colon);
            String portValue = address.substring(colon + 1);
            if (portValue.length() > 0) {
                this.port = Integer.parseInt(portValue);
            }
        } else {
            this.host = address;
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Host host = (Host)o;
        if (this.port != host.port) {
            return false;
        }
        return !(this.host != null ? !this.host.equals(host.host) : host.host != null);
    }

    public int hashCode() {
        int result = this.host != null ? this.host.hashCode() : 0;
        result = 31 * result + this.port;
        return result;
    }

    public String toString() {
        StringBuilder address = new StringBuilder();
        address.append(this.host);
        if (this.port != 0) {
            address.append(COLON);
            address.append(this.port);
        }
        return address.toString();
    }
}

