/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.xml;

import com.nuodb.impl.xml.Doc;
import com.nuodb.impl.xml.Item;
import com.nuodb.xml.XmlException;

public class Text
extends Item {
    String text;

    public Text() {
    }

    public Text(String bodyText) {
        this.text = bodyText;
    }

    public Text(Doc doc) throws XmlException {
        this.parse(doc);
    }

    @Override
    public void parse(Doc doc) throws XmlException {
        this.text = doc.parseText();
    }

    @Override
    public boolean isTag() {
        return false;
    }

    @Override
    public void prettyPrint(int column) {
        this.space(column);
        int len = this.text.length();
        while (len > 0 && !Character.isWhitespace(this.text.charAt(len - 1))) {
        }
        int chars = 0;
        for (int n = 0; n < len; ++n) {
            char c = this.text.charAt(n);
            if (chars <= 0 && Character.isWhitespace(c)) continue;
            if (chars == 0) {
                System.out.print('\"');
            }
            System.out.print(c);
            if (++chars <= 30) continue;
            System.out.println("...");
            break;
        }
        if (chars > 0) {
            System.out.print('\"');
        }
    }

    @Override
    public String getValue() {
        return this.text;
    }
}

