/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.stats.metrics;

import com.nuodb.impl.util.Preconditions;
import com.nuodb.stats.metrics.MetricPoint;
import com.nuodb.xml.Tag;
import com.nuodb.xml.TagFactory;
import com.nuodb.xml.XmlException;
import java.util.Date;

public class MetricPointImpl
implements MetricPoint {
    private double value;
    private long timestamp;

    public MetricPointImpl() {
    }

    public MetricPointImpl(MetricPoint mp) {
        this(mp.getValue(), mp.getTimestamp());
    }

    public MetricPointImpl(double value, long timestamp) {
        this.value = value;
        this.timestamp = timestamp;
    }

    public MetricPointImpl(Tag tag) throws XmlException {
        Preconditions.checkArgument("MetricPoint".equals(tag.getName()), "not a MetricPoint tag: %s", tag);
        this.value = Double.parseDouble(tag.getAttribute("Val"));
        this.timestamp = tag.getLongAttribute("Ts");
    }

    @Override
    public MetricPoint encode(Tag element) {
        element.addAttribute("Ts", this.timestamp);
        element.addAttribute("Val", Double.toString(this.value));
        return this;
    }

    @Override
    public Tag toTag() {
        Tag tag = TagFactory.createTag("MetricPoint");
        this.encode(tag);
        return tag;
    }

    @Override
    public MetricPoint setValue(double value) {
        this.value = value;
        return this;
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public MetricPoint setTimeStamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return "MP[" + new Date(this.timestamp) + "(" + this.timestamp + ")," + this.value + "]";
    }
}

