/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.agent;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.UUID;
import java.util.logging.Logger;

public class IdentityUtils {
    public static final String STABLE_ID_FILE = "stableId.cfg";
    public static final String UNSTABLE_ID_FILE = "unstableId.out";

    public static String generateId() {
        String newId = "uuid:" + UUID.randomUUID().toString();
        return newId;
    }

    public static String generateStableID(File idFile, boolean override) {
        String newId = null;
        try {
            BufferedReader in = new BufferedReader(new FileReader(idFile));
            newId = in.readLine();
            in.close();
        }
        catch (FileNotFoundException in) {
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Failed to read stableId " + idFile.getAbsolutePath() + ": " + ioe.toString());
        }
        if (newId == null || override) {
            newId = IdentityUtils.generateId();
            try {
                idFile.getParentFile().mkdirs();
                try (PrintWriter out = new PrintWriter(idFile);){
                    out.println(newId);
                }
            }
            catch (Exception we) {
                throw new IllegalStateException("Failed to write stableId " + idFile.getAbsolutePath() + ": " + we.toString());
            }
        }
        return newId;
    }

    public static boolean createDir(File dir, Logger logger) {
        boolean created = false;
        RuntimeException error = null;
        try {
            if (dir.exists()) {
                return true;
            }
            created = dir.mkdirs();
            if (created && logger != null) {
                logger.info("Created " + dir.getAbsolutePath());
            }
        }
        catch (RuntimeException e) {
            error = e;
        }
        if (!created && logger != null) {
            logger.severe(String.format("Failed to created dir [%s] %s", dir.getAbsolutePath(), error != null ? error.getMessage() : ""));
        }
        return true;
    }
}

