/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.etree.value.scalar;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.dsi.dataengine.utilities.TypeMetadata;
import com.amazon.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.amazon.sqlengine.executor.etree.ETDataRequest;
import com.amazon.sqlengine.executor.etree.value.ETValueExpr;
import com.amazon.sqlengine.executor.etree.value.SqlDataIntegrityChecker;
import com.amazon.sqlengine.executor.etree.value.scalar.ETScalarFn;
import com.amazon.support.exceptions.ErrorException;
import java.math.BigInteger;
import java.util.List;

public class ETAbsFn
extends ETScalarFn {
    private short m_argType;
    private boolean m_isSigned;

    public ETAbsFn(IColumn iColumn, List<ETValueExpr> list, List<IColumn> list2) throws ErrorException {
        super(iColumn, list, list2);
        assert (1 == this.getNumChildren());
        TypeMetadata typeMetadata = list2.get(0).getTypeMetadata();
        short s = typeMetadata.getType();
        if (s != iColumn.getTypeMetadata().getType()) {
            throw new IllegalArgumentException("Invalid return type for ABS scalar function.");
        }
        switch (s) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                if (iColumn.getTypeMetadata().isSigned()) {
                    throw new IllegalArgumentException("Invalid return type for ABS scalar function.");
                }
            }
            case -7: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                this.m_argType = s;
                this.m_isSigned = typeMetadata.isSigned();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid argument type: " + s);
            }
        }
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        ISqlDataWrapper iSqlDataWrapper = this.getArgumentData(0);
        if (iSqlDataWrapper.isNull()) {
            eTDataRequest.getData().setNull();
            return false;
        }
        switch (this.m_argType) {
            case 6: 
            case 8: {
                eTDataRequest.getData().setDouble(Math.abs(iSqlDataWrapper.getDouble()));
                break;
            }
            case 7: {
                eTDataRequest.getData().setReal(Math.abs(iSqlDataWrapper.getReal()));
                break;
            }
            case 4: {
                long l = iSqlDataWrapper.getInteger();
                assert (SqlDataIntegrityChecker.checkInteger(l, this.m_isSigned));
                eTDataRequest.getData().setInteger(Math.abs(l));
                break;
            }
            case 5: {
                int n = iSqlDataWrapper.getSmallInt();
                assert (SqlDataIntegrityChecker.checkSmallInt(n, this.m_isSigned));
                eTDataRequest.getData().setSmallInt(Math.abs(n));
                break;
            }
            case -6: {
                short s = iSqlDataWrapper.getTinyInt();
                assert (SqlDataIntegrityChecker.checkSmallInt(s, this.m_isSigned));
                eTDataRequest.getData().setTinyInt((short)Math.abs(s));
                break;
            }
            case -5: {
                BigInteger bigInteger = iSqlDataWrapper.getBigInt();
                assert (SqlDataIntegrityChecker.checkBigInt(bigInteger, this.m_isSigned));
                eTDataRequest.getData().setBigInt(bigInteger.abs());
                break;
            }
            case 2: 
            case 3: {
                eTDataRequest.getData().setExactNumber(iSqlDataWrapper.getExactNumber().abs());
                break;
            }
            case -7: {
                eTDataRequest.getData().setBoolean(iSqlDataWrapper.getBoolean());
            }
            default: {
                throw new IllegalStateException("unknown type: " + this.m_argType);
            }
        }
        return false;
    }
}

