/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.dsiext.dataengine.metadata;

import com.amazon.dsi.core.impl.DSIDriver;
import com.amazon.dsi.dataengine.utilities.DSITypeUtilities;
import com.amazon.dsi.dataengine.utilities.DataWrapper;
import com.amazon.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.amazon.dsi.utilities.DSIMessageKey;
import com.amazon.sqlengine.dsiext.dataengine.IMetadataHelper;
import com.amazon.sqlengine.dsiext.dataengine.Identifier;
import com.amazon.sqlengine.dsiext.dataengine.metadata.DSIExtPartiallyFilteredMetadataSource;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.util.Map;

public class DSIExtTablesMetadataSource
extends DSIExtPartiallyFilteredMetadataSource {
    private ILogger m_logger;
    private Identifier m_curRow = null;
    private Identifier m_nextRow = null;

    public DSIExtTablesMetadataSource(ILogger iLogger, Map<MetadataSourceColumnTag, String> map, IMetadataHelper iMetadataHelper, boolean bl) {
        super(map, iMetadataHelper, MetadataSourceColumnTag.TABLE_NAME, bl);
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        this.m_logger = iLogger;
        this.getNext();
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public void closeCursor() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, l, l2});
        switch (metadataSourceColumnTag) {
            case CATALOG_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_curRow.getCatalog(), dataWrapper, l, l2);
            }
            case SCHEMA_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_curRow.getSchema(), dataWrapper, l, l2);
            }
            case TABLE_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_curRow.getName(), dataWrapper, l, l2);
            }
            case TABLE_TYPE: {
                return DSITypeUtilities.outputVarCharStringData("TABLE", dataWrapper, l, l2);
            }
            case REMARKS: {
                return DSITypeUtilities.outputVarCharStringData("", dataWrapper, l, l2);
            }
        }
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_METADATA_COLUMN_TAG.name(), metadataSourceColumnTag.name());
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_nextRow != null;
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_nextRow == null) {
            return false;
        }
        this.getNext();
        return true;
    }

    private void getNext() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_curRow = this.m_nextRow;
        this.m_nextRow = this.getNextProcedureOrTable();
    }
}

