/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.dsiext.dataengine.metadata;

import com.amazon.dsi.core.impl.DSIDriver;
import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.dsi.dataengine.utilities.DSITypeUtilities;
import com.amazon.dsi.dataengine.utilities.DataWrapper;
import com.amazon.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.amazon.dsi.dataengine.utilities.Nullable;
import com.amazon.dsi.dataengine.utilities.TypeMetadata;
import com.amazon.dsi.dataengine.utilities.TypeUtilities;
import com.amazon.dsi.utilities.DSIMessageKey;
import com.amazon.sqlengine.dsiext.dataengine.DSIExtJResultSet;
import com.amazon.sqlengine.dsiext.dataengine.IMetadataHelper;
import com.amazon.sqlengine.dsiext.dataengine.Identifier;
import com.amazon.sqlengine.dsiext.dataengine.OpenTableType;
import com.amazon.sqlengine.dsiext.dataengine.SqlDataEngine;
import com.amazon.sqlengine.dsiext.dataengine.metadata.DSIExtPartiallyFilteredMetadataSource;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;

public class DSIExtColumnsMetadataSource
extends DSIExtPartiallyFilteredMetadataSource {
    private ILogger m_logger;
    private SqlDataEngine m_dataEngine;
    private LinkedList<IColumn> m_columns;
    private LinkedList<Integer> m_columnIndexes;

    public DSIExtColumnsMetadataSource(ILogger iLogger, Map<MetadataSourceColumnTag, String> map, IMetadataHelper iMetadataHelper, SqlDataEngine sqlDataEngine) {
        super(map, iMetadataHelper, MetadataSourceColumnTag.TABLE_NAME, sqlDataEngine.getIsODBC2());
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        this.m_logger = iLogger;
        this.m_dataEngine = sqlDataEngine;
        this.m_columns = new LinkedList();
        this.m_columnIndexes = new LinkedList();
        this.m_columns.add(null);
        this.m_columnIndexes.add(null);
        this.loadNext();
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.closeCursor();
    }

    @Override
    public void closeCursor() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_columns = null;
        this.m_columnIndexes = null;
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, l, l2});
        IColumn iColumn = this.m_columns.peek();
        switch (metadataSourceColumnTag) {
            case CATALOG_NAME: {
                return DSITypeUtilities.outputVarCharStringData(iColumn.getCatalogName(), dataWrapper, l, l2);
            }
            case SCHEMA_NAME: {
                return DSITypeUtilities.outputVarCharStringData(iColumn.getSchemaName(), dataWrapper, l, l2);
            }
            case TABLE_NAME: {
                return DSITypeUtilities.outputVarCharStringData(iColumn.getTableName(), dataWrapper, l, l2);
            }
            case COLUMN_NAME: {
                return DSITypeUtilities.outputVarCharStringData(iColumn.getName(), dataWrapper, l, l2);
            }
            case DATA_TYPE: {
                dataWrapper.setSmallInt(this.NormalizeDateTimeTypeForODBC2(iColumn.getTypeMetadata().getType()));
                return false;
            }
            case DATA_TYPE_NAME: {
                return DSITypeUtilities.outputVarCharStringData(iColumn.getTypeMetadata().getTypeName(), dataWrapper, l, l2);
            }
            case COLUMN_SIZE: {
                dataWrapper.setInteger((int)TypeUtilities.getColumnSize(iColumn.getTypeMetadata(), iColumn.getColumnLength()));
                return false;
            }
            case BUFFER_LENGTH: {
                TypeMetadata typeMetadata = iColumn.getTypeMetadata();
                short s = typeMetadata.getType();
                long l3 = -8 == s || -9 == s || -10 == s ? iColumn.getColumnLength() * 2L : (typeMetadata.isCharacterOrBinaryType() ? iColumn.getColumnLength() : (long)TypeUtilities.getSizeInBytes(s));
                dataWrapper.setInteger(l3);
                return false;
            }
            case DECIMAL_DIGITS: {
                TypeMetadata typeMetadata = iColumn.getTypeMetadata();
                if (typeMetadata.isIntervalType() || 92 == typeMetadata.getType() || 93 == typeMetadata.getType()) {
                    dataWrapper.setSmallInt(typeMetadata.getPrecision());
                } else if (typeMetadata.isExactNumericType()) {
                    dataWrapper.setSmallInt(typeMetadata.getScale());
                } else if (typeMetadata.isIntegerType()) {
                    dataWrapper.setSmallInt(0);
                } else {
                    dataWrapper.setNull(5);
                }
                return false;
            }
            case NUM_PREC_RADIX: {
                TypeMetadata typeMetadata = iColumn.getTypeMetadata();
                Integer n = typeMetadata.isIntegerType() || typeMetadata.isExactNumericType() ? Integer.valueOf(10) : (typeMetadata.isApproximateNumericType() ? Integer.valueOf(2) : null);
                dataWrapper.setSmallInt(n);
                return false;
            }
            case NULLABLE: {
                dataWrapper.setSmallInt(iColumn.getNullable().ordinal());
                return false;
            }
            case REMARKS: {
                dataWrapper.setNull(12);
                return false;
            }
            case COLUMN_DEF: {
                dataWrapper.setNull(12);
                return false;
            }
            case SQL_DATA_TYPE: {
                short s = iColumn.getTypeMetadata().getType();
                dataWrapper.setSmallInt(TypeUtilities.getVerboseTypeFromConciseType(s));
                return false;
            }
            case SQL_DATETIME_SUB: {
                short s = iColumn.getTypeMetadata().getType();
                short s2 = TypeUtilities.getIntervalCodeFromConciseType(s);
                if (0 == s2) {
                    dataWrapper.setNull(5);
                } else {
                    dataWrapper.setSmallInt(s2);
                }
                return false;
            }
            case CHAR_OCTET_LENGTH: {
                TypeMetadata typeMetadata = iColumn.getTypeMetadata();
                short s = typeMetadata.getType();
                if (-8 == s || -9 == s || -10 == s) {
                    dataWrapper.setInteger(iColumn.getColumnLength() * 2L);
                } else if (typeMetadata.isCharacterOrBinaryType()) {
                    dataWrapper.setInteger(iColumn.getColumnLength());
                } else {
                    dataWrapper.setNull(4);
                }
                return false;
            }
            case ORDINAL_POSITION: {
                dataWrapper.setInteger(this.m_columnIndexes.peek().intValue());
                return false;
            }
            case IS_NULLABLE: {
                return DSITypeUtilities.outputVarCharStringData(this.nullableToIsNullable(iColumn.getNullable()), dataWrapper, l, l2);
            }
            case USER_DATA_TYPE: {
                dataWrapper.setSmallInt(0);
                return false;
            }
            case IS_AUTOINCREMENT: {
                return DSITypeUtilities.outputVarCharStringData(iColumn.isAutoUnique() ? "YES" : "NO", dataWrapper, l, l2);
            }
            case IS_GENERATEDCOLUMN: {
                return DSITypeUtilities.outputVarCharStringData("", dataWrapper, l, l2);
            }
        }
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_METADATA_COLUMN_TAG.name(), metadataSourceColumnTag.name());
    }

    @Override
    public boolean hasMoreRows() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_columns.size() > 1;
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_columns.poll();
        this.m_columnIndexes.poll();
        if (this.m_columns.size() == 1) {
            this.loadNext();
        }
        return this.m_columns.size() > 0;
    }

    private void loadNext() {
        Identifier identifier;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        while (this.m_columns.size() < 2 && (identifier = this.getNextProcedureOrTable()) != null) {
            ArrayList<? extends IColumn> arrayList;
            DSIExtJResultSet dSIExtJResultSet;
            try {
                dSIExtJResultSet = this.m_dataEngine.openTable(identifier.getCatalog(), identifier.getSchema(), identifier.getName(), OpenTableType.READ_ONLY);
            }
            catch (ErrorException errorException) {
                continue;
            }
            if (dSIExtJResultSet == null) continue;
            try {
                arrayList = dSIExtJResultSet.getSelectColumns();
            }
            catch (ErrorException errorException) {
                continue;
            }
            assert (arrayList != null);
            this.m_columns.addAll(arrayList);
            for (int i = 0; i < arrayList.size(); ++i) {
                this.m_columnIndexes.add(i + 1);
            }
        }
    }

    private String nullableToIsNullable(Nullable nullable) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{nullable});
        if (nullable == Nullable.NULLABLE) {
            return "YES";
        }
        if (nullable == Nullable.NO_NULLS) {
            return "NO";
        }
        return "";
    }
}

