/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.dsiext.dataengine.metadata;

import com.amazon.dsi.core.impl.DSIDriver;
import com.amazon.dsi.dataengine.interfaces.IMetadataSource;
import com.amazon.dsi.dataengine.utilities.DSITypeUtilities;
import com.amazon.dsi.dataengine.utilities.DataWrapper;
import com.amazon.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.amazon.dsi.utilities.DSIMessageKey;
import com.amazon.dsi.utilities.NullSafeStringComparator;
import com.amazon.sqlengine.dsiext.dataengine.IMetadataHelper;
import com.amazon.sqlengine.dsiext.dataengine.Identifier;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.Pair;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class DSIExtCatalogSchemasOnlyMetadataSource
implements IMetadataSource {
    private ILogger m_logger;
    private IMetadataHelper m_metadataHelper;
    private List<Pair<String, String>> m_catalogSchemaPairList;
    private int m_currRow = -1;
    private String m_catalogRestriction;
    private String m_schemaRestriction;

    public DSIExtCatalogSchemasOnlyMetadataSource(ILogger iLogger, Map<MetadataSourceColumnTag, String> map, IMetadataHelper iMetadataHelper) {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        this.m_logger = iLogger;
        this.m_metadataHelper = iMetadataHelper;
        this.m_catalogRestriction = map.get((Object)MetadataSourceColumnTag.CATALOG_NAME);
        this.m_schemaRestriction = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        this.findCatalogSchemas();
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public void closeCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, l, l2});
        Pair<String, String> pair = this.m_catalogSchemaPairList.get(this.m_currRow);
        switch (metadataSourceColumnTag) {
            case CATALOG_NAME: {
                return DSITypeUtilities.outputVarCharStringData(pair.key(), dataWrapper, l, l2);
            }
            case SCHEMA_NAME: {
                return DSITypeUtilities.outputVarCharStringData(pair.value(), dataWrapper, l, l2);
            }
        }
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_METADATA_COLUMN_TAG.name(), metadataSourceColumnTag.name());
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_currRow < this.m_catalogSchemaPairList.size() - 1;
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_currRow < this.m_catalogSchemaPairList.size()) {
            ++this.m_currRow;
        }
        return this.m_currRow < this.m_catalogSchemaPairList.size();
    }

    private void findCatalogSchemas() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        Comparator<Pair<String, String>> comparator = new Comparator<Pair<String, String>>(){

            @Override
            public int compare(Pair<String, String> pair, Pair<String, String> pair2) {
                NullSafeStringComparator nullSafeStringComparator = new NullSafeStringComparator();
                int n = nullSafeStringComparator.compare(pair.key(), pair2.key());
                return n == 0 ? nullSafeStringComparator.compare(pair.value(), pair2.value()) : n;
            }
        };
        Identifier identifier = new Identifier();
        TreeSet<Pair<String, String>> treeSet = new TreeSet<Pair<String, String>>(comparator);
        while (this.m_metadataHelper.getNextTable(identifier)) {
            if (this.m_catalogRestriction != null && !this.m_catalogRestriction.equalsIgnoreCase(identifier.getCatalog()) || this.m_schemaRestriction != null && !this.m_schemaRestriction.equalsIgnoreCase(identifier.getSchema())) continue;
            treeSet.add(new Pair<String, String>(identifier.getCatalog(), identifier.getSchema()));
        }
        this.m_catalogSchemaPairList = Collections.unmodifiableList(new ArrayList<Pair<String, String>>(treeSet));
    }
}

