/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.aeprocessor.aetree.value;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.dsi.dataengine.utilities.ColumnMetadata;
import com.amazon.dsi.dataengine.utilities.DataWrapper;
import com.amazon.dsi.dataengine.utilities.Nullable;
import com.amazon.dsi.dataengine.utilities.Searchable;
import com.amazon.dsi.dataengine.utilities.TypeMetadata;
import com.amazon.dsi.dataengine.utilities.TypeUtilities;
import com.amazon.dsi.exceptions.IncorrectTypeException;
import com.amazon.dsi.exceptions.NumericOverflowException;
import com.amazon.sqlengine.aeprocessor.aetree.IAEBinaryNode;
import com.amazon.sqlengine.aeprocessor.aetree.IAENode;
import com.amazon.sqlengine.aeprocessor.aetree.IAENodeVisitor;
import com.amazon.sqlengine.aeprocessor.aetree.bool.AEComparison;
import com.amazon.sqlengine.aeprocessor.aetree.bool.AEInPredicate;
import com.amazon.sqlengine.aeprocessor.aetree.bool.AELikePredicate;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AEProject;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AESelect;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AESort;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AETableConstructor;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AETop;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEAggrFn;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEBinaryValueExpr;
import com.amazon.sqlengine.aeprocessor.aetree.value.AECustomScalarFn;
import com.amazon.sqlengine.aeprocessor.aetree.value.AENegate;
import com.amazon.sqlengine.aeprocessor.aetree.value.AERename;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEScalarFn;
import com.amazon.sqlengine.aeprocessor.aetree.value.AESearchedCase;
import com.amazon.sqlengine.aeprocessor.aetree.value.AESearchedWhenClause;
import com.amazon.sqlengine.aeprocessor.aetree.value.AESimpleCase;
import com.amazon.sqlengine.aeprocessor.aetree.value.AESimpleWhenClause;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.amazon.sqlengine.dsiext.dataengine.SqlDataEngineContext;
import com.amazon.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.amazon.support.exceptions.ErrorException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class AEParameter
extends AEValueExpr {
    private int m_index;
    private long m_maxBinaryLiteralLen = 0L;
    private long m_maxLiteralCharLen = 0L;
    private ColumnMetadata m_colMetadata;
    private boolean m_metaHasBeenSet = false;
    private DataWrapper m_inputData;

    public AEParameter(int n, SqlDataEngineContext sqlDataEngineContext) throws ErrorException {
        this.m_index = n;
        try {
            this.m_maxBinaryLiteralLen = sqlDataEngineContext.getConnProperty(65).getLong();
            this.m_maxLiteralCharLen = sqlDataEngineContext.getConnProperty(67).getLong();
        }
        catch (NumericOverflowException numericOverflowException) {
        }
        catch (IncorrectTypeException incorrectTypeException) {
            // empty catch block
        }
    }

    protected AEParameter(AEParameter aEParameter) {
        this.m_index = aEParameter.m_index;
        this.m_maxBinaryLiteralLen = aEParameter.m_maxBinaryLiteralLen;
        this.m_maxLiteralCharLen = aEParameter.m_maxLiteralCharLen;
        this.m_inputData = aEParameter.m_inputData;
        this.m_metaHasBeenSet = aEParameter.m_metaHasBeenSet;
        if (null != aEParameter.m_colMetadata) {
            this.m_colMetadata = AEValueExpr.createColumnMetadata(aEParameter.m_colMetadata);
        }
    }

    private void initMetadata() throws ErrorException {
        IAENode iAENode = this.getParent();
        if (iAENode instanceof AETop) {
            AETop aETop = (AETop)this.getParent();
            this.m_colMetadata = aETop.isPercent() ? new ColumnMetadata(TypeMetadata.createTypeMetadata(8, true)) : new ColumnMetadata(TypeMetadata.createTypeMetadata(-5, true));
            this.m_colMetadata.setNullable(Nullable.NO_NULLS);
        } else if (iAENode instanceof AEValueExprList && (iAENode.getParent() instanceof AEScalarFn || iAENode.getParent() instanceof AECustomScalarFn)) {
            AEValueExprList aEValueExprList = (AEValueExprList)iAENode;
            IAENode iAENode2 = aEValueExprList.getParent();
            int n = aEValueExprList.findNode(this);
            if (n < 0) {
                throw SQLEngineExceptionFactory.invalidOperationException("Invalid AETree has been created and a valid path cannot be found.");
            }
            if (iAENode2 instanceof AEScalarFn) {
                AEScalarFn aEScalarFn = (AEScalarFn)iAENode2;
                List<IColumn> list = aEScalarFn.getExpectedArgMetadata();
                this.m_colMetadata = (ColumnMetadata)list.get(n);
            } else {
                AECustomScalarFn aECustomScalarFn = (AECustomScalarFn)iAENode2;
                this.m_colMetadata = ColumnMetadata.copyOf(aECustomScalarFn.getInputMetadata().get(n));
            }
            this.setMetadataDefaults(this.m_colMetadata);
        } else {
            IColumn iColumn = null;
            if (null != iAENode) {
                iColumn = this.findSiblingMetadata(iAENode, this);
            }
            if (null == iColumn) {
                this.m_colMetadata = new ColumnMetadata(TypeMetadata.createTypeMetadata(0));
            } else {
                this.m_colMetadata = AEValueExpr.createColumnMetadata(iColumn);
                TypeMetadata typeMetadata = this.m_colMetadata.getTypeMetadata();
                if (TypeUtilities.isCharacterType(typeMetadata.getType())) {
                    typeMetadata.setPrecision((short)Math.max((long)typeMetadata.getPrecision(), this.m_maxLiteralCharLen));
                } else if (TypeUtilities.isBinaryType(typeMetadata.getType())) {
                    typeMetadata.setPrecision((short)Math.max((long)typeMetadata.getPrecision(), this.m_maxBinaryLiteralLen));
                }
            }
            this.setMetadataDefaults(this.m_colMetadata);
        }
    }

    private void setMetadataDefaults(ColumnMetadata columnMetadata) {
        columnMetadata.setNullable(Nullable.UNKNOWN);
        columnMetadata.setSearchable(Searchable.SEARCHABLE);
        columnMetadata.setAutoUnique(false);
        if (TypeUtilities.isNumberType(columnMetadata.getTypeMetadata().getType())) {
            columnMetadata.getTypeMetadata().setSigned(true);
        }
    }

    private IColumn findSiblingMetadata(IAENode iAENode, IAENode iAENode2) throws ErrorException {
        assert (null != iAENode && null != iAENode2);
        switch (ParamAncestorType.getAncestorType(iAENode)) {
            case NEGATE: 
            case RENAME: {
                if (null != iAENode.getParent()) {
                    return this.findSiblingMetadata(iAENode.getParent(), iAENode);
                }
                return null;
            }
            case BINARY_VALUE_EXPR: 
            case BOOLEAN_EXPR: {
                IAEBinaryNode iAEBinaryNode = (IAEBinaryNode)((Object)iAENode);
                Object object = iAENode2 == iAEBinaryNode.getLeftOperand() ? iAEBinaryNode.getRightOperand() : iAEBinaryNode.getLeftOperand();
                if (object instanceof AEParameter) {
                    return null;
                }
                if (object instanceof AEValueExprList) {
                    return this.findSiblingMetadata((IAENode)object, iAENode);
                }
                assert (object instanceof AEValueExpr);
                return ((AEValueExpr)object).getColumn();
            }
            case VALUE_LIST: {
                ParamAncestorType paramAncestorType = ParamAncestorType.getAncestorType(iAENode.getParent());
                if (ParamAncestorType.RELATION != paramAncestorType) {
                    Iterator<? extends IAENode> iterator = iAENode.getChildItr();
                    while (iterator.hasNext()) {
                        IAENode iAENode3 = iterator.next();
                        if (this.isParameter(iAENode3)) continue;
                        return ((AEValueExpr)iAENode3).getColumn();
                    }
                }
                if (iAENode.getParent() != iAENode2 && ParamAncestorType.BOOLEAN_EXPR == paramAncestorType) {
                    return this.findSiblingMetadata(iAENode.getParent(), iAENode);
                }
                return null;
            }
        }
        return null;
    }

    public Iterator<IAENode> getChildItr() {
        return Collections.emptyList().iterator();
    }

    @Override
    public int getNumChildren() {
        return 0;
    }

    public int getIndex() {
        return this.m_index;
    }

    @Override
    public <T> T acceptVisitor(IAENodeVisitor<T> iAENodeVisitor) throws ErrorException {
        return iAENodeVisitor.visit(this);
    }

    @Override
    public boolean isEquivalent(IAENode iAENode) {
        if (this == iAENode) {
            return true;
        }
        if (!(iAENode instanceof AEParameter)) {
            return false;
        }
        return ((AEParameter)iAENode).m_index == this.m_index;
    }

    @Override
    public IColumn getColumn() {
        if (!this.m_metaHasBeenSet) {
            return NullMetadataInstance.INSTANCE;
        }
        return this.m_colMetadata;
    }

    public IColumn getInferredOrSetColumn() throws ErrorException {
        if (null == this.m_colMetadata) {
            this.initMetadata();
        }
        return this.m_colMetadata;
    }

    public void setColumn(IColumn iColumn) {
        assert (null != iColumn);
        this.m_metaHasBeenSet = true;
        this.m_colMetadata = AEValueExpr.createColumnMetadata(iColumn);
    }

    public boolean hasBeenSet() {
        return this.m_metaHasBeenSet;
    }

    @Override
    public void updateColumn() throws ErrorException {
    }

    public DataWrapper getInputData() {
        return this.m_inputData;
    }

    public void setInputData(DataWrapper dataWrapper) {
        this.m_inputData = dataWrapper;
    }

    @Override
    public AEValueExpr copy() {
        return new AEParameter(this);
    }

    private boolean isParameter(IAENode iAENode) {
        return iAENode instanceof AEParameter || iAENode instanceof AENegate && ((AENegate)iAENode).getOperand() instanceof AEParameter;
    }

    private static enum ParamAncestorType {
        NEGATE,
        RENAME,
        BINARY_VALUE_EXPR,
        BOOLEAN_EXPR,
        VALUE_LIST,
        RELATION,
        TOP,
        SORT,
        NULL,
        AGGREGATE_FN,
        CASE,
        TABLE_CONSTRUCTOR;


        public static ParamAncestorType getAncestorType(IAENode iAENode) throws ErrorException {
            if (null == iAENode) {
                return NULL;
            }
            if (iAENode instanceof AEBinaryValueExpr) {
                return BINARY_VALUE_EXPR;
            }
            if (iAENode instanceof AENegate) {
                return NEGATE;
            }
            if (iAENode instanceof AEComparison || iAENode instanceof AELikePredicate || iAENode instanceof AEInPredicate) {
                return BOOLEAN_EXPR;
            }
            if (iAENode instanceof AERename) {
                return RENAME;
            }
            if (iAENode instanceof AEProject || iAENode instanceof AESelect) {
                return RELATION;
            }
            if (iAENode instanceof AETop) {
                return TOP;
            }
            if (iAENode instanceof AESort) {
                return SORT;
            }
            if (iAENode instanceof AEValueExprList) {
                return VALUE_LIST;
            }
            if (iAENode instanceof AEAggrFn) {
                return AGGREGATE_FN;
            }
            if (iAENode instanceof AESimpleWhenClause || iAENode instanceof AESimpleCase || iAENode instanceof AESearchedWhenClause || iAENode instanceof AESearchedCase) {
                return CASE;
            }
            if (iAENode instanceof AETableConstructor) {
                return TABLE_CONSTRUCTOR;
            }
            throw SQLEngineExceptionFactory.featureNotImplementedException("Unknown ancestor of dynamic parameter node: " + iAENode.getClass().getName());
        }
    }

    private static class NullMetadataInstance {
        private static final ColumnMetadata INSTANCE;

        private NullMetadataInstance() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static {
            ColumnMetadata columnMetadata = null;
            try {
                columnMetadata = new ColumnMetadata(TypeMetadata.createTypeMetadata(0));
                columnMetadata.setName(null);
            }
            catch (ErrorException errorException) {
            }
            finally {
                INSTANCE = columnMetadata;
            }
        }
    }
}

