/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core.jdbc41;

import com.amazon.dsi.core.interfaces.IStatement;
import com.amazon.dsi.dataengine.utilities.DataWrapper;
import com.amazon.dsi.dataengine.utilities.ParameterMetadata;
import com.amazon.exceptions.ExceptionConverter;
import com.amazon.jdbc.common.SConnection;
import com.amazon.jdbc.jdbc41.S41CallableStatement;
import com.amazon.redshift.core.PGDSIOverrideHelper;
import com.amazon.redshift.core.PGJDBCStatement;
import com.amazon.support.LogUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;

public class PGJDBC41CallableStatement
extends S41CallableStatement {
    public static final int NOT_REGISTERED = -11111;
    private int registeredType = -11111;

    public PGJDBC41CallableStatement(String sql, IStatement statement, SConnection conn, int concurrency) throws SQLException {
        super(sql, statement, conn, concurrency);
    }

    @Override
    protected void checkValidParameterIndex(int parameterIndex) throws SQLException {
        PGDSIOverrideHelper.checkValidParameterIndex(this.m_numParameters, parameterIndex, (PGJDBCStatement)this.m_statement, this.m_warningListener);
    }

    @Override
    public synchronized void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex, sqlType, scale);
            this.checkIfOpen();
            this.checkValidParameterIndex(parameterIndex);
            this.checkTypeSupported(sqlType);
            PGDSIOverrideHelper.registerOutParameter(parameterIndex, sqlType, scale, this.m_warningListener, this.m_parameterTypes, this.m_parameterScale, scale, this.m_parameterMetadata);
            int outputIndex = this.getOutputParameterOnlyIndex(parameterIndex);
            this.registeredType = sqlType;
            this.m_parameterRegistered.set(outputIndex - 1, Boolean.TRUE);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    protected DataWrapper getOutputParameterValue(int parameterIndex) throws SQLException {
        ResultSet resultSet = null;
        if (this.m_resultSets != null) {
            resultSet = super.getResultSet();
        }
        return PGDSIOverrideHelper.getOutputParameterValue(parameterIndex, resultSet, parameterIndex, this.m_parameterMetadata, parameterIndex);
    }

    @Override
    public synchronized boolean execute() throws SQLException {
        ParameterMetadata output = (ParameterMetadata)this.m_parameterMetadata.get(0);
        PGDSIOverrideHelper.execute(this.m_parameterMetadata, this.m_parameterRegistered, this.m_logger, this.m_warningListener, output, this.registeredType);
        return super.execute();
    }
}

