/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.outbound;

import com.amazon.jdbc.communications.interfaces.AbstractOutboundMessage;
import com.amazon.redshift.api.PGDataTypeUtilities;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.core.IPGLogger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;

public class Parse
extends AbstractOutboundMessage
implements PGConstants {
    private final byte[] m_preparedStatementName;
    private final byte[] m_query;
    private final List<Integer> m_parameterDataTypes;

    public Parse(byte[] preparedStatementName, String query, List<Integer> parameterDataTypes, IPGLogger logger) {
        this.m_preparedStatementName = preparedStatementName;
        this.m_query = PGDataTypeUtilities.toUTF8ByteArray(query);
        this.m_parameterDataTypes = parameterDataTypes;
        if (logger.isExternalLoggerEnabled()) {
            this.logMessageContent(logger);
        }
    }

    @Override
    public void serialize(ByteBuffer buffer, byte[] sizebytes) {
        buffer.put((byte)80);
        buffer.put(sizebytes);
        if (null != this.m_preparedStatementName) {
            buffer.put(this.m_preparedStatementName);
        }
        buffer.put(TERMINATOR);
        buffer.put(this.m_query);
        buffer.put(TERMINATOR);
        if (null != this.m_parameterDataTypes && this.m_parameterDataTypes.size() > 0) {
            buffer.putShort((short)this.m_parameterDataTypes.size());
            for (int i : this.m_parameterDataTypes) {
                buffer.putInt(i);
            }
        } else {
            buffer.putShort((short)0);
        }
    }

    @Override
    public int getSize() {
        int size = 4 + (this.m_preparedStatementName != null ? this.m_preparedStatementName.length : 0) + 1 + this.m_query.length + 1 + 2;
        if (null != this.m_parameterDataTypes) {
            size += this.m_parameterDataTypes.size() * 4;
        }
        return size;
    }

    public void logMessageContent(IPGLogger logger) {
        String query = new String(this.m_query);
        String preparestatement = null;
        if (null != this.m_preparedStatementName) {
            preparestatement = new String(this.m_preparedStatementName);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("=>FE Parse(stmt=");
        sb.append(preparestatement);
        sb.append(",query=");
        sb.append(query);
        sb.append(",oids=");
        if (null != this.m_parameterDataTypes) {
            sb.append(Arrays.toString(this.m_parameterDataTypes.toArray()));
        }
        sb.append(")");
        logger.logDebugExternal(sb.toString());
    }
}

