/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.inbound;

import com.amazon.jdbc.communications.interfaces.AbstractInboundMessage;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.core.IPGLogger;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class ParameterDescription
extends AbstractInboundMessage
implements PGConstants {
    private final short m_numOfParameters;
    private final int[] m_parameterDataTypeOIDs;

    public ParameterDescription(ByteBuffer buffer, IPGLogger logger) {
        this.m_numOfParameters = buffer.getShort();
        this.m_parameterDataTypeOIDs = new int[this.m_numOfParameters];
        for (int i = 0; i < this.m_numOfParameters; ++i) {
            this.m_parameterDataTypeOIDs[i] = buffer.getInt();
        }
        if (logger.isExternalLoggerEnabled()) {
            this.logMessageContent(logger);
        }
    }

    public short getNumParameters() {
        return this.m_numOfParameters;
    }

    public int[] getParameterDataTypeOIDs() {
        return this.m_parameterDataTypeOIDs;
    }

    public void logMessageContent(IPGLogger logger) {
        String message = "<=BE ParameterDescription(" + this.m_numOfParameters + ")";
        logger.logDebugExternal(message);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("\nParameterDescription: getFieldName - ");
        str.append(this.m_numOfParameters);
        str.append("\ngetParameterDataTypeOIDs- ");
        str.append(Arrays.toString(this.getParameterDataTypeOIDs()));
        return str.toString();
    }
}

