/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.inbound;

import com.amazon.jdbc.communications.interfaces.AbstractInboundMessage;
import com.amazon.redshift.api.PGDataTypeUtilities;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.core.IPGLogger;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.nio.ByteBuffer;

public class DataRow
extends AbstractInboundMessage
implements PGConstants {
    public static final int COLUMN_NULL = -1;
    private final short m_numberOfColumns;
    private int m_messageLength;
    private final byte[] m_data;
    private int[] m_columnBeginIndexes;
    private int[] m_columnEndIndexes;
    private Object[] m_columnObjects;
    private int m_position;
    private final IPGLogger m_log;

    public DataRow(ByteBuffer buffer, IPGLogger logger, int messageLength) throws ErrorException {
        this.m_log = logger;
        this.m_numberOfColumns = buffer.getShort();
        this.m_columnObjects = new Object[this.m_numberOfColumns];
        this.m_messageLength = messageLength - 4 - 2;
        this.m_columnBeginIndexes = null;
        this.m_columnEndIndexes = null;
        try {
            this.m_data = new byte[this.m_messageLength];
        }
        catch (OutOfMemoryError ex) {
            LogUtilities.logFatal("OutOfMemoryError:DataRow:Size=" + messageLength + ":" + ex.getMessage(), (ILogger)this.m_log);
            ErrorException err = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), ex.getMessage() + ":DataRow:Size=" + messageLength, (Throwable)ex);
            throw err;
        }
        this.read(buffer);
        if (this.m_log.isExternalLoggerEnabled()) {
            this.logMessageContent(this.m_log);
        }
    }

    public void read(ByteBuffer buffer) {
        int chunk = this.m_data.length - this.m_position;
        if (buffer.remaining() < this.m_data.length - this.m_position) {
            chunk = buffer.remaining();
        }
        buffer.get(this.m_data, this.m_position, chunk);
        this.m_position += chunk;
        if (this.m_log.isEnabled()) {
            LogUtilities.logDebug("DataRow read " + this.m_position + " bytes of expected " + this.m_data.length, (ILogger)this.m_log);
        }
    }

    public byte[] getData() {
        return this.m_data;
    }

    public void setConvertedObject(int columnNumber, Object obj) {
        if (columnNumber <= this.m_numberOfColumns) {
            this.m_columnObjects[columnNumber] = obj;
        }
    }

    public Object getConvertedObject(int columnNumber) {
        if (columnNumber <= this.m_numberOfColumns) {
            return this.m_columnObjects[columnNumber];
        }
        return null;
    }

    public void buildColumnIndexes() throws ErrorException {
        if (null == this.m_columnBeginIndexes) {
            this.m_columnBeginIndexes = new int[this.m_numberOfColumns];
            this.m_columnEndIndexes = new int[this.m_numberOfColumns];
            int index = 0;
            for (int colIndex = 0; colIndex < this.m_numberOfColumns; ++colIndex) {
                int length = PGDataTypeUtilities.toInt(this.m_data, index);
                index += 4;
                if (-1 != length) {
                    this.m_columnBeginIndexes[colIndex] = index;
                    this.m_columnEndIndexes[colIndex] = length - 1 + index;
                    index += length;
                    continue;
                }
                this.m_columnBeginIndexes[colIndex] = -1;
                this.m_columnEndIndexes[colIndex] = -1;
            }
        }
    }

    public int getColumnBeginIndex(int column) throws ErrorException {
        this.buildColumnIndexes();
        return this.m_columnBeginIndexes[column];
    }

    public int getColumnEndIndex(int column) throws ErrorException {
        this.buildColumnIndexes();
        return this.m_columnEndIndexes[column];
    }

    public int getNumberOfColumns() {
        return this.m_numberOfColumns;
    }

    public static int getUniqueMessageSize() {
        return 2;
    }

    public boolean isRowComplete() {
        if (null == this.m_data) {
            return true;
        }
        return this.m_data.length == this.m_position;
    }

    public void logMessageContent(IPGLogger logger) {
        String message = "<=BE DataRow(" + this.m_messageLength + ")";
        logger.logDebugExternal(message);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("\nDataRow: getNumberOfColumns - ");
        str.append(this.getNumberOfColumns());
        return str.toString();
    }
}

