/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.inbound;

import com.amazon.jdbc.communications.interfaces.AbstractInboundMessage;
import com.amazon.redshift.api.PGDataTypeUtilities;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.core.IPGLogger;
import com.amazon.support.exceptions.ErrorException;
import java.nio.ByteBuffer;

public class CommandComplete
extends AbstractInboundMessage
implements PGConstants {
    private static final byte TAG_R = 82;
    private static final byte TAG_I = 73;
    private static final byte TAG_D = 68;
    private static final byte TAG_P = 80;
    private static final byte TAG_U = 85;
    private static final byte TAG_S = 83;
    private static final byte TAG_E = 69;
    private static final byte TAG_L = 76;
    private static final byte TAG_M = 77;
    private static final byte TAG_F = 70;
    private static final byte TAG_C = 67;
    private static final byte TAG_A = 65;
    private static final byte TAG_B = 66;
    private final byte[] m_commandTag;
    private boolean m_isInsert = false;
    private boolean m_isCreate = false;
    private boolean m_isDelete = false;
    private boolean m_isDrop = false;
    private boolean m_isUpdate = false;
    private boolean m_isSelect = false;
    private boolean m_isMove = false;
    private boolean m_isFetch = false;
    private boolean m_isCopy = false;
    private boolean m_isSavepoint = false;
    private boolean m_isBegin = false;
    private boolean m_isPrepare = false;
    private boolean m_isDeclareCursor = false;
    private boolean m_isCloseCursor = false;
    private int m_insertTableOID;
    private long m_numRows;

    protected CommandComplete() {
        this.m_commandTag = null;
    }

    public CommandComplete(ByteBuffer buffer, int length, IPGLogger logger) throws ErrorException {
        this.m_commandTag = new byte[length - 1 - 4];
        this.m_numRows = 0L;
        buffer.get(this.m_commandTag);
        buffer.position(buffer.position() + 1);
        String commandTag = PGDataTypeUtilities.toUTF8String(this.m_commandTag);
        String[] split = commandTag.split(" ");
        switch (this.m_commandTag[0]) {
            case 73: {
                this.m_isInsert = true;
                if (split.length > 1) {
                    this.m_insertTableOID = Integer.parseInt(split[1]);
                }
                if (split.length <= 2) break;
                this.m_numRows = Long.parseLong(split[2]);
                break;
            }
            case 68: {
                if (this.m_commandTag[3] == 80) {
                    this.m_isDrop = true;
                    if (split.length <= 1) break;
                    this.m_numRows = 0L;
                    break;
                }
                if (this.m_commandTag[3] == 69) {
                    this.m_isDelete = true;
                    if (split.length <= 1) break;
                    this.m_numRows = Long.parseLong(split[1]);
                    break;
                }
                if (this.m_commandTag[3] == 76) {
                    this.m_isDeclareCursor = true;
                    this.m_numRows = 0L;
                    break;
                }
            }
            case 85: {
                this.m_isUpdate = true;
                if (split.length <= 1) break;
                this.m_numRows = Long.parseLong(split[1]);
                break;
            }
            case 83: {
                switch (this.m_commandTag[1]) {
                    case 65: {
                        this.m_isSavepoint = true;
                        break;
                    }
                    case 69: {
                        this.m_isSelect = true;
                        if (split.length <= 1) break;
                        this.m_numRows = Long.parseLong(split[1]);
                    }
                }
                break;
            }
            case 77: {
                this.m_isMove = true;
                if (split.length <= 1) break;
                this.m_numRows = Long.parseLong(split[1]);
                break;
            }
            case 70: {
                this.m_isFetch = true;
                if (split.length <= 1) break;
                this.m_numRows = Long.parseLong(split[1]);
                break;
            }
            case 67: {
                if (this.m_commandTag[1] == 82) {
                    this.m_isCreate = true;
                    if (split.length <= 1) break;
                    this.m_numRows = 0L;
                    break;
                }
                if (this.m_commandTag[1] == 76) {
                    this.m_isCloseCursor = true;
                    this.m_numRows = 0L;
                    break;
                }
                this.m_isCopy = true;
                if (split.length <= 1) break;
                this.m_numRows = Long.parseLong(split[1]);
                break;
            }
            case 66: {
                this.m_isBegin = true;
                break;
            }
            case 80: {
                this.m_isPrepare = true;
            }
        }
        if (logger.isExternalLoggerEnabled()) {
            this.logMessageContent(logger);
        }
    }

    public boolean isPrepare() {
        return this.m_isPrepare;
    }

    public boolean isInsert() {
        return this.m_isInsert;
    }

    public boolean isCreate() {
        return this.m_isCreate;
    }

    public boolean isDelete() {
        return this.m_isDelete;
    }

    public boolean isDrop() {
        return this.m_isDrop;
    }

    public boolean isUpdate() {
        return this.m_isUpdate;
    }

    public boolean isSelect() {
        return this.m_isSelect;
    }

    public boolean isMove() {
        return this.m_isMove;
    }

    public boolean isFetch() {
        return this.m_isFetch;
    }

    public boolean isCopy() {
        return this.m_isCopy;
    }

    public boolean isSavepoint() {
        return this.m_isSavepoint;
    }

    public boolean isBegin() {
        return this.m_isBegin;
    }

    public int getInsertTableOID() {
        return this.m_insertTableOID;
    }

    public long getNumRows() {
        return this.m_numRows;
    }

    public void logMessageContent(IPGLogger logger) {
        String message = "<=BE CommandStatus(" + new String(this.m_commandTag) + ")";
        logger.logDebugExternal(message);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("\nCommandComplete: getCommandTag - ");
        str.append(new String(this.m_commandTag));
        str.append(" - numRows :");
        str.append(this.getNumRows());
        str.append(" - isInsert :");
        str.append(this.isInsert());
        str.append(" - isCreate :");
        str.append(this.isCreate());
        str.append(" - isUpdate :");
        str.append(this.isUpdate());
        str.append(" - isSelect :");
        str.append(this.isSelect());
        str.append(" - isDelete :");
        str.append(this.isDelete());
        str.append(" - isDrop :");
        str.append(this.isDrop());
        str.append(" - isFetch :");
        str.append(this.isFetch());
        str.append(" - isMove :");
        str.append(this.isMove());
        str.append(" - isCopy :");
        str.append(this.isCopy());
        str.append(" - isSavepoint :");
        str.append(this.isSavepoint());
        str.append(" - isBegin :");
        str.append(this.isBegin());
        str.append(" - isPrepare :");
        str.append(this.isPrepare());
        return str.toString();
    }
}

