/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jdbc.utils;

import java.util.ArrayList;
import java.util.List;

public class ParseQueryUtils {
    public static List<String> splitQueries(String query, boolean isDollarQuoted) {
        ArrayList<SubstringBounds> substrings = new ArrayList<SubstringBounds>();
        boolean inSingleQuote = false;
        boolean inDoubleQuote = false;
        int startingIndex = 0;
        int i = 0;
        block9: for (i = 0; i < query.length(); ++i) {
            switch (query.charAt(i)) {
                case ';': {
                    if (inDoubleQuote || inSingleQuote) continue block9;
                    substrings.add(new SubstringBounds(startingIndex, i));
                    startingIndex = i + 1;
                    continue block9;
                }
                case '\"': {
                    if (inSingleQuote) continue block9;
                    inDoubleQuote = !inDoubleQuote;
                    continue block9;
                }
                case '\'': {
                    if (inDoubleQuote) continue block9;
                    inSingleQuote = !inSingleQuote;
                    continue block9;
                }
                case '\\': {
                    ++i;
                    continue block9;
                }
                case '-': {
                    if (inDoubleQuote || inSingleQuote || query.charAt(i + 1) != '-') continue block9;
                    int j = query.indexOf(10, i + 2);
                    if (-1 == j) {
                        i = query.length();
                        continue block9;
                    }
                    i = j;
                    continue block9;
                }
                case '/': {
                    int j;
                    if (inDoubleQuote || inSingleQuote || query.charAt(i + 1) != '*' || -1 == (j = query.indexOf("*/", i + 2))) continue block9;
                    i = j + 1;
                    continue block9;
                }
                case '$': {
                    if (inDoubleQuote || inSingleQuote || !isDollarQuoted || i + 1 >= query.length() || query.charAt(i + 1) != '$') continue block9;
                    int j = query.indexOf("$$", i + 2);
                    i = j < 0 ? query.length() : j + 1;
                }
            }
        }
        if (startingIndex != query.length()) {
            substrings.add(new SubstringBounds(startingIndex, query.length()));
        }
        ArrayList<String> results = new ArrayList<String>();
        for (SubstringBounds bounds : substrings) {
            String individualQuery = query.substring(bounds.m_begin, bounds.m_end);
            if (individualQuery.trim().isEmpty()) continue;
            results.add(individualQuery);
        }
        return results;
    }

    public static List<String> splitQueries(String query) {
        return ParseQueryUtils.splitQueries(query, false);
    }

    @Deprecated
    public static String removeComments(String query) {
        String result = query;
        if (query.contains("/*")) {
            StringBuilder sb = new StringBuilder();
            int commentStart = query.indexOf("/*");
            int commentStop = query.indexOf("*/");
            sb.append(query.substring(0, commentStart));
            if (-1 != commentStop) {
                sb.append(query.substring(commentStop, query.length()));
            }
            result = sb.toString().trim();
        } else if (query.contains("--")) {
            StringBuilder sb = new StringBuilder();
            int commentStart = query.indexOf("--");
            int commentStop = query.indexOf("\n");
            sb.append(query.substring(0, commentStart));
            if (-1 != commentStop) {
                sb.append(query.substring(commentStop + 1, query.length()));
            }
            result = sb.toString().trim();
        } else if (query.contains("#")) {
            StringBuilder sb = new StringBuilder();
            int commentStart = query.indexOf("#");
            int commentStop = query.indexOf("\n");
            sb.append(query.substring(0, commentStart));
            if (-1 != commentStop) {
                sb.append(query.substring(commentStop + 1, query.length()));
            }
            result = sb.toString().trim();
        }
        return result;
    }

    public static String parseCommentsOnSingleQuery(String sql) {
        StringBuilder result = new StringBuilder();
        boolean inSingle = false;
        boolean inDouble = false;
        int queryLength = sql.length();
        block7: for (int i = 0; i < queryLength; ++i) {
            char cur = sql.charAt(i);
            switch (cur) {
                case '\'': {
                    if (!inDouble) {
                        inSingle = !inSingle;
                    }
                    result.append(cur);
                    continue block7;
                }
                case '\"': {
                    if (!inSingle) {
                        inDouble = !inDouble;
                    }
                    result.append(cur);
                    continue block7;
                }
                case '/': {
                    if (!inSingle && !inDouble && i + 1 < queryLength && '*' == sql.charAt(i + 1)) {
                        int end = sql.indexOf("*/", i);
                        if (end <= 0) {
                            return sql;
                        }
                        i = end + 1;
                        continue block7;
                    }
                    result.append(cur);
                    continue block7;
                }
                case '-': {
                    int ret;
                    if (!inSingle && !inDouble && i + 1 < queryLength && '-' == sql.charAt(i + 1)) {
                        ret = sql.indexOf("\n", i);
                        if (ret == -1) {
                            i = queryLength;
                            continue block7;
                        }
                        i = ret;
                        continue block7;
                    }
                    result.append(cur);
                    continue block7;
                }
                case '#': {
                    int ret;
                    if (!inSingle && !inDouble) {
                        ret = sql.indexOf("\n", i);
                        if (ret == -1) {
                            i = queryLength;
                            continue block7;
                        }
                        i = ret;
                        continue block7;
                    }
                    result.append(cur);
                    continue block7;
                }
                default: {
                    result.append(cur);
                }
            }
        }
        return result.toString();
    }

    private static class SubstringBounds {
        public final int m_begin;
        public final int m_end;

        public SubstringBounds(int begin, int end) {
            this.m_begin = begin;
            this.m_end = end;
        }
    }
}

