/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jdbc.communications;

import com.amazon.jdbc.communications.InboundMessagesContainer;
import com.amazon.jdbc.communications.exceptions.InboundErrorMessage;
import com.amazon.jdbc.communications.interfaces.AbstractInboundDataHandler;
import com.amazon.jdbc.communications.interfaces.IInboundMessage;
import com.amazon.jdbc.communications.interfaces.SocketCloseListener;
import com.amazon.jdbc.communications.interfaces.SocketCloseObservable;
import com.amazon.support.ILogger;
import com.amazon.support.IWarningListener;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class InboundMessagesPipeline
implements Closeable,
SocketCloseObservable {
    private static final int BLOCKING_QUEUE_CAPACITY = 1;
    protected static final int TIMEOUT_MS_WAIT = 20;
    public static final int TIMEOUT_MS_BLOCKING_QUEUE = 20;
    public static final int NO_REQUESTED_TIMEOUT = 0;
    private static final int NEXT_PEEK_TIMEOUT_MS = 50;
    private static final int MESSAGE_GRAB_TIMEOUT_MS = 200;
    public BlockingQueue<InboundMessagesContainer> m_messageContainersQueue;
    protected InboundMessagesContainer m_currentMessagesContainer;
    public IWarningListener m_warningListener;
    private AtomicBoolean m_hasOpenOperation = new AtomicBoolean(false);
    protected int m_nRowMode;
    public long m_currentMessageCount;
    public long m_totalMessageCount;
    protected ILogger m_log;
    protected AtomicBoolean m_close;
    public String m_query;
    public IInboundMessage m_peekedMessage = null;
    private List<SocketCloseListener> listeners = new ArrayList<SocketCloseListener>();
    private ErrorException m_fatalException = null;

    public InboundMessagesPipeline(int nRowMode, ILogger logger, IWarningListener warningListener) {
        this.m_log = logger;
        this.m_close = new AtomicBoolean(false);
        this.m_warningListener = warningListener;
        this.m_nRowMode = nRowMode;
        this.m_currentMessageCount = 0L;
        if (nRowMode > 0) {
            this.m_currentMessagesContainer = new InboundMessagesContainer(this.m_nRowMode);
            this.m_currentMessagesContainer.setInQueue();
        } else {
            this.initializeMessagesContainersQueue();
        }
    }

    protected abstract boolean handleMessage(IInboundMessage var1) throws ErrorException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getNextMessageOfClass(Class cl, int timeoutMS) throws ErrorException {
        boolean returnAfterTimeout = false;
        if (timeoutMS == 0) {
            timeoutMS = 50;
        } else {
            returnAfterTimeout = true;
        }
        while (!this.m_close.get() && (this.m_hasOpenOperation.get() || this.m_currentMessageCount < this.m_totalMessageCount)) {
            if (null != this.m_peekedMessage || this.validateCurrentContainer()) {
                IInboundMessage message = null;
                if (null != this.m_peekedMessage) {
                    message = this.m_peekedMessage;
                    this.m_peekedMessage = null;
                } else {
                    InboundMessagesPipeline inboundMessagesPipeline = this;
                    synchronized (inboundMessagesPipeline) {
                        if (this.isClosed()) {
                            return false;
                        }
                        message = this.m_currentMessagesContainer.next(timeoutMS);
                    }
                }
                if (null != message) {
                    ++this.m_currentMessageCount;
                    if (!this.handleMessage(message)) {
                        return false;
                    }
                    if (cl == null || cl.isInstance(message)) {
                        return true;
                    }
                } else {
                    LogUtilities.logDebug("No message found", this.m_log);
                }
            }
            if (!returnAfterTimeout) continue;
            return false;
        }
        return false;
    }

    public IInboundMessage peekNextMessage(int timeoutMS) throws ErrorException {
        if (null != this.m_peekedMessage) {
            return this.m_peekedMessage;
        }
        while (!this.m_close.get()) {
            if (!this.validateCurrentContainer()) continue;
            this.m_peekedMessage = this.m_currentMessagesContainer.next(timeoutMS);
            if (null != this.m_peekedMessage) {
                return this.m_peekedMessage;
            }
            if (timeoutMS <= 0) continue;
            return null;
        }
        return null;
    }

    public boolean validateCurrentContainer() {
        if (this.m_nRowMode > 0) {
            return null != this.m_currentMessagesContainer && !this.m_currentMessagesContainer.isClosed();
        }
        if (null != this.m_currentMessagesContainer && !this.m_currentMessagesContainer.isClosed() && this.m_currentMessagesContainer.hasNext()) {
            return true;
        }
        this.m_currentMessagesContainer = null;
        while (!(this.m_close.get() || null != this.m_currentMessagesContainer || this.m_messageContainersQueue.isEmpty() && this.m_messageContainersQueue.isEmpty() && !this.m_hasOpenOperation.get())) {
            try {
                this.m_currentMessagesContainer = this.m_messageContainersQueue.poll(20L, TimeUnit.MILLISECONDS);
                if (null != this.m_currentMessagesContainer) {
                    return true;
                }
                if (!this.m_log.isEnabled()) continue;
                LogUtilities.logDebug("InboundMessagePipeline waited", this.m_log);
            }
            catch (InterruptedException interruptedException) {}
        }
        return false;
    }

    public void openCurrentOperation() {
        this.m_hasOpenOperation.set(true);
    }

    public void closeCurrentOperation() {
        this.m_hasOpenOperation.set(false);
    }

    public boolean hasOpenOperation() {
        return this.m_hasOpenOperation.get();
    }

    public void setWarningListener(IWarningListener m_warningListener) {
        this.m_warningListener = m_warningListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        InboundMessagesPipeline inboundMessagesPipeline = this;
        synchronized (inboundMessagesPipeline) {
            this.m_close.set(true);
            if (null != this.m_currentMessagesContainer) {
                this.m_currentMessagesContainer.close();
            }
            while (this.validateCurrentContainer()) {
                if (null == this.m_currentMessagesContainer) continue;
                this.m_currentMessagesContainer.close();
            }
        }
    }

    @Override
    public void addSocketCloseListener(SocketCloseListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeSocketCloseListener(SocketCloseListener listener) {
        this.listeners.remove(listener);
    }

    public void close(ErrorException error) {
        for (SocketCloseListener listener : this.listeners) {
            listener.socketClosed(error);
        }
        if (null != error) {
            this.m_fatalException = error;
        }
        this.close();
    }

    public int getNRowMode() {
        return this.m_nRowMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNRowMode(int nRowMode, AbstractInboundDataHandler dataHandler) throws InboundErrorMessage {
        block12: {
            LogUtilities.logFunctionEntrance(this.m_log, nRowMode);
            dataHandler.m_addToPipelineLock.lock();
            try {
                if (nRowMode == this.m_nRowMode) {
                    return;
                }
                this.m_nRowMode = nRowMode;
                if (null == this.m_currentMessagesContainer) {
                    this.m_currentMessagesContainer = new InboundMessagesContainer(this.m_nRowMode);
                    this.m_currentMessagesContainer.setInQueue();
                } else {
                    InboundMessagesContainer tempContainer = this.m_currentMessagesContainer;
                    this.m_currentMessagesContainer = new InboundMessagesContainer(this.m_nRowMode);
                    while (tempContainer.hasNext()) {
                        this.m_currentMessagesContainer.add(tempContainer.next(200));
                    }
                    this.m_currentMessagesContainer.setInQueue();
                }
                if (null == this.m_messageContainersQueue && 0 == this.m_nRowMode) {
                    this.initializeMessagesContainersQueue();
                }
                if (null == this.m_messageContainersQueue) break block12;
                InboundMessagesContainer oldContainer = null;
                try {
                    oldContainer = this.m_messageContainersQueue.poll(200L, TimeUnit.MILLISECONDS);
                    while (null != oldContainer && oldContainer.hasNext()) {
                        this.m_currentMessagesContainer.add(oldContainer.next(200));
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            finally {
                dataHandler.m_addToPipelineLock.unlock();
            }
        }
    }

    private boolean isClosed() throws ErrorException {
        if (this.m_close.get()) {
            if (null != this.m_fatalException) {
                throw this.m_fatalException;
            }
            return true;
        }
        return false;
    }

    public ErrorException receivedFatalExeption() {
        return this.m_fatalException;
    }

    public InboundMessagesContainer getCurrentMessagesContainer() {
        return this.m_currentMessagesContainer;
    }

    private void initializeMessagesContainersQueue() {
        this.m_messageContainersQueue = new ArrayBlockingQueue<InboundMessagesContainer>(1, true);
    }
}

