/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.handler;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceSQL;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetSaveReport;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetSaveSettings;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;

class SaveScriptDialog
extends BaseDialog {
    private static final String DIALOG_ID = "DBeaver.RSV.SaveScriptDialog";
    private ResultSetViewer viewer;
    private Object sqlPanel;
    private ResultSetSaveSettings saveSettings;
    private ResultSetSaveReport saveReport;
    private String scriptText;

    SaveScriptDialog(ResultSetViewer viewer, ResultSetSaveReport saveReport) {
        super(viewer.getControl().getShell(), "Preview changes", (DBPImage)UIIcon.SQL_SCRIPT);
        this.viewer = viewer;
        this.saveSettings = new ResultSetSaveSettings();
        this.saveReport = saveReport;
    }

    public ResultSetSaveSettings getSaveSettings() {
        return this.saveSettings;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return null;
    }

    protected Composite createDialogArea(Composite parent) {
        Composite messageGroup = super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        gd.minimumWidth = 400;
        messageGroup.setLayoutData((Object)gd);
        UIServiceSQL serviceSQL = (UIServiceSQL)DBWorkbench.getService(UIServiceSQL.class);
        if (serviceSQL != null) {
            Composite sqlContainer = new Composite(messageGroup, 0);
            gd = new GridData(1808);
            sqlContainer.setLayout((Layout)new FillLayout());
            gd.widthHint = 500;
            gd.heightHint = 400;
            sqlContainer.setLayoutData((Object)gd);
            try {
                this.sqlPanel = serviceSQL.createSQLPanel((Object)this.viewer.getSite(), (Object)sqlContainer, (DBPContextProvider)this.viewer, UINavigatorMessages.editors_entity_dialog_preview_title, true, "");
            }
            catch (Exception e) {
                DBWorkbench.getPlatformUI().showError("Can't create SQL panel", "Error creating SQL panel", (Throwable)e);
            }
        }
        this.populateSQL();
        boolean useDeleteCascade = this.saveReport.isHasReferences() && this.saveReport.getDeletes() > 0;
        SaveScriptDialog.createDeleteCascadeControls(messageGroup, this.saveSettings, useDeleteCascade, this::populateSQL);
        return messageGroup;
    }

    public static void createDeleteCascadeControls(Composite messageGroup, final ResultSetSaveSettings settings, boolean enableControls, final Runnable settingsRefreshHandler) {
        Composite settingsComposite = UIUtils.createComposite((Composite)messageGroup, (int)3);
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        settingsComposite.setLayoutData((Object)gd);
        final Button useFQNamesCheck = UIUtils.createCheckbox((Composite)settingsComposite, (String)"Use fully qualified names", (String)"", (boolean)settings.isUseFullyQualifiedNames(), (int)1);
        final Button deleteCascadeCheck = UIUtils.createCheckbox((Composite)settingsComposite, (String)"Delete cascade", (String)"Delete rows from all tables referencing this table by foreign keys", (boolean)settings.isDeleteCascade(), (int)1);
        final Button deleteDeepCascadeCheck = UIUtils.createCheckbox((Composite)settingsComposite, (String)"Deep cascade", (String)"Delete cascade recursively (deep references)", (boolean)settings.isDeepCascade(), (int)1);
        if (!enableControls) {
            useFQNamesCheck.setEnabled(false);
            deleteCascadeCheck.setEnabled(false);
            deleteDeepCascadeCheck.setEnabled(false);
        } else {
            useFQNamesCheck.setEnabled(true);
            useFQNamesCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    settings.setUseFullyQualifiedNames(useFQNamesCheck.getSelection());
                    settingsRefreshHandler.run();
                }
            });
            deleteCascadeCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (deleteCascadeCheck.getSelection()) {
                        settings.setDeleteCascade(true);
                    } else {
                        settings.setDeleteCascade(false);
                        settings.setDeepCascade(false);
                        deleteDeepCascadeCheck.setSelection(false);
                    }
                    settingsRefreshHandler.run();
                }
            });
            deleteDeepCascadeCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (deleteDeepCascadeCheck.getSelection()) {
                        settings.setDeleteCascade(true);
                        settings.setDeepCascade(true);
                        deleteCascadeCheck.setSelection(true);
                    } else {
                        settings.setDeepCascade(false);
                    }
                    settingsRefreshHandler.run();
                }
            });
            deleteDeepCascadeCheck.setEnabled(false);
        }
    }

    private static String appendReportLine(String report, int count, String info) {
        if (!report.isEmpty()) {
            report = String.valueOf(report) + ", ";
        }
        return String.valueOf(report) + count + " " + info;
    }

    protected String getDetailsLabel(boolean show) {
        return show ? "SQL >>" : "SQL <<";
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button persistButton = this.createButton(parent, 0, "Persist", false);
        ((GridData)persistButton.getLayoutData()).horizontalAlignment = 1;
        Label spacer = new Label(parent, 0);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.minimumWidth = 50;
        spacer.setLayoutData((Object)gd);
        ++((GridLayout)parent.getLayout()).numColumns;
        ((GridLayout)parent.getLayout()).makeColumnsEqualWidth = false;
        this.createButton(parent, 13, "Copy", false);
        this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, true);
    }

    private void populateSQL() {
        try {
            ArrayList sqlScript = new ArrayList();
            UIUtils.runInProgressService(monitor -> {
                List<DBEPersistAction> script = this.viewer.generateChangesScript(monitor, this.saveSettings);
                if (script != null) {
                    sqlScript.addAll(script);
                }
            });
            this.scriptText = "";
            if (!sqlScript.isEmpty()) {
                this.scriptText = SQLUtils.generateScript((DBPDataSource)this.viewer.getDataSource(), (DBEPersistAction[])sqlScript.toArray(new DBEPersistAction[0]), (boolean)false);
                this.scriptText = String.valueOf(SQLUtils.generateCommentLine((DBPDataSource)this.viewer.getDataSource(), (String)("Auto-generated SQL script #" + new SimpleDateFormat("yyyyMMddHHmm").format(new Date())))) + this.scriptText;
                UIServiceSQL serviceSQL = (UIServiceSQL)DBWorkbench.getService(UIServiceSQL.class);
                if (serviceSQL != null) {
                    serviceSQL.setSQLPanelText(this.sqlPanel, this.scriptText);
                }
            }
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError("Can't generate SQL script", "Error generating SQL script from data changes", (Throwable)e);
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 13) {
            ResultSetUtils.copyToClipboard(this.scriptText);
            super.buttonPressed(1);
        }
        super.buttonPressed(buttonId);
    }
}

