/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import org.eclipse.jface.action.Action;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.ui.controls.resultset.FilterByAttributeType;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;

class FilterByAttributeAction
extends Action {
    private ResultSetViewer resultSetViewer;
    private final DBCLogicalOperator operator;
    private final FilterByAttributeType type;
    private final DBDAttributeBinding attribute;

    FilterByAttributeAction(ResultSetViewer resultSetViewer, DBCLogicalOperator operator, FilterByAttributeType type, DBDAttributeBinding attribute) {
        super(String.valueOf(attribute.getName()) + " " + resultSetViewer.translateFilterPattern(operator, type, attribute), type.icon);
        this.resultSetViewer = resultSetViewer;
        this.operator = operator;
        this.type = type;
        this.attribute = attribute;
    }

    public void run() {
        Object value = this.type.getValue(this.resultSetViewer, this.attribute, this.operator, false);
        if (this.operator.getArgumentCount() != 0 && value == null) {
            return;
        }
        DBDDataFilter filter = new DBDDataFilter(this.resultSetViewer.getModel().getDataFilter());
        DBDAttributeConstraint constraint = filter.getConstraint(this.attribute);
        if (constraint != null) {
            constraint.setOperator(this.operator);
            constraint.setValue(value);
            this.resultSetViewer.setDataFilter(filter, true);
        }
    }
}

