/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadVisualizer;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.css.CSSUtils;
import org.jkiss.dbeaver.ui.editors.TextEditorUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

abstract class ActiveStatusMessage
extends Composite {
    private static final Log log = Log.getLog(ActiveStatusMessage.class);
    private final ResultSetViewer viewer;
    private final Image actionImage;
    private final Text messageText;
    private final ToolItem actionItem;
    private ILoadService<String> loadService;

    public ActiveStatusMessage(@NotNull Composite parent, Image actionImage, String actionText, @Nullable ResultSetViewer viewer) {
        super(parent, 0);
        this.viewer = viewer;
        this.actionImage = actionImage;
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 1;
        this.setLayout((Layout)layout);
        ToolBar tb = new ToolBar((Composite)this, 0x800100);
        CSSUtils.setCSSClass((Widget)tb, (String)"coloredByConnectionType");
        this.actionItem = new ToolItem(tb, 0);
        this.actionItem.setImage(this.actionImage);
        if (actionText != null) {
            this.actionItem.setToolTipText(actionText);
        }
        this.actionItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActiveStatusMessage.this.executeAction();
            }
        });
        this.messageText = new Text((Composite)this, 8);
        if (RuntimeUtils.isPlatformWindows()) {
            this.messageText.setBackground(null);
        } else {
            this.messageText.setBackground(parent.getBackground());
        }
        GridData gd = new GridData(768);
        this.messageText.setLayoutData((Object)gd);
        if (viewer != null) {
            TextEditorUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)viewer.getSite(), (Control)this.messageText);
            UIUtils.addDefaultEditActionsSupport((IServiceLocator)viewer.getSite(), (Control)this.messageText);
        }
    }

    public void setMessage(String message) {
        if (this.messageText.isDisposed()) {
            return;
        }
        this.messageText.setText(message);
    }

    public String getMessage() {
        return this.messageText.getText();
    }

    public void updateActionState() {
        if (!this.actionItem.isDisposed()) {
            this.actionItem.setEnabled(this.isActionEnabled());
        }
    }

    public void executeAction() {
        if (this.loadService != null) {
            try {
                this.loadService.cancel();
            }
            catch (InvocationTargetException e) {
                log.error((Object)e.getTargetException());
            }
            this.loadService = null;
        } else {
            this.loadService = this.createLoadService();
            LoadingJob.createService(this.loadService, (ILoadVisualizer)new LoadVisualizer()).schedule();
        }
    }

    protected abstract boolean isActionEnabled();

    protected abstract ILoadService<String> createLoadService();

    private class LoadVisualizer
    implements ILoadVisualizer<String> {
        private boolean completed;

        private LoadVisualizer() {
        }

        public DBRProgressMonitor overwriteMonitor(DBRProgressMonitor monitor) {
            return monitor;
        }

        public boolean isCompleted() {
            return this.completed || ActiveStatusMessage.this.isDisposed();
        }

        public void visualizeLoading() {
            ActiveStatusMessage.this.actionItem.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.CLOSE));
        }

        public void completeLoading(String message) {
            this.completed = true;
            if (!CommonUtils.equalObjects((Object)ActiveStatusMessage.this.getMessage(), (Object)message)) {
                ActiveStatusMessage.this.setMessage(message);
                ActiveStatusMessage.this.getParent().layout(true, true);
            }
            ActiveStatusMessage.this.actionItem.setImage(ActiveStatusMessage.this.actionImage);
            ActiveStatusMessage.this.loadService = null;
        }
    }
}

