/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.driver;

import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBIconComposite;
import org.jkiss.dbeaver.model.DBPDataSourceProvider;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverDependencies;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocationManager;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNode;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.OSDescriptor;
import org.jkiss.dbeaver.model.sql.SQLDialectMetadata;
import org.jkiss.dbeaver.registry.DataSourceProviderDescriptor;
import org.jkiss.dbeaver.registry.NativeClientDescriptor;
import org.jkiss.dbeaver.registry.VersionUtils;
import org.jkiss.dbeaver.registry.driver.DriverClassLoader;
import org.jkiss.dbeaver.registry.driver.DriverDependencies;
import org.jkiss.dbeaver.registry.driver.DriverDescriptorSerializerLegacy;
import org.jkiss.dbeaver.registry.driver.DriverDescriptorSerializerModern;
import org.jkiss.dbeaver.registry.driver.DriverFileSource;
import org.jkiss.dbeaver.registry.driver.DriverLibraryAbstract;
import org.jkiss.dbeaver.registry.driver.DriverUtils;
import org.jkiss.dbeaver.registry.driver.RemoteNativeClientLocation;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.XMLBuilder;

public class DriverDescriptor
extends AbstractDescriptor
implements DBPDriver {
    private static final Log log = Log.getLog(DriverDescriptor.class);
    private static final String DRIVERS_FOLDER = "drivers";
    private static final String PROP_DRIVERS_LOCATION = "DRIVERS_LOCATION";
    private static final String LICENSE_ACCEPT_KEY = "driver.license.accept.";
    private final DataSourceProviderDescriptor providerDescriptor;
    private final String id;
    private String category;
    private List<String> categories;
    private final String origName;
    private final String origDescription;
    private final String origClassName;
    private final String origDefaultPort;
    private final String origSampleURL;
    private String name;
    private String description;
    private String driverClassName;
    private String driverDefaultPort;
    private String sampleURL;
    private String webURL;
    private String propertiesWebURL;
    private DBPImage iconPlain;
    private DBPImage iconNormal;
    private DBPImage iconError;
    private DBPImage iconBig;
    private boolean embedded;
    private boolean clientRequired;
    private boolean supportsDriverProperties;
    private boolean anonymousAccess;
    private boolean allowsEmptyPassword;
    private boolean licenseRequired;
    private boolean customDriverLoader;
    private boolean useURLTemplate;
    private boolean custom;
    private boolean modified;
    private boolean disabled;
    private boolean temporary;
    private int promoted;
    private final List<DBPNativeClientLocation> nativeClientHomes = new ArrayList<DBPNativeClientLocation>();
    private final List<DriverFileSource> fileSources = new ArrayList<DriverFileSource>();
    private final List<DBPDriverLibrary> libraries = new ArrayList<DBPDriverLibrary>();
    private final List<DBPDriverLibrary> origFiles = new ArrayList<DBPDriverLibrary>();
    private final List<DBPPropertyDescriptor> connectionPropertyDescriptors = new ArrayList<DBPPropertyDescriptor>();
    private final List<OSDescriptor> supportedSystems = new ArrayList<OSDescriptor>();
    private final List<ReplaceInfo> driverReplacements = new ArrayList<ReplaceInfo>();
    private DriverDescriptor replacedBy;
    private final Map<Object, Object> defaultParameters = new HashMap<Object, Object>();
    private final Map<Object, Object> customParameters = new HashMap<Object, Object>();
    private final Map<Object, Object> defaultConnectionProperties = new HashMap<Object, Object>();
    private final Map<Object, Object> customConnectionProperties = new HashMap<Object, Object>();
    private Map<DBPDriverLibrary, List<DriverFileInfo>> resolvedFiles = new HashMap<DBPDriverLibrary, List<DriverFileInfo>>();
    private Class driverClass;
    private boolean isLoaded;
    private Object driverInstance;
    private DriverClassLoader classLoader;
    private transient boolean isFailed = false;

    static {
        File driversHome = DriverDescriptor.getCustomDriversHome();
        System.setProperty(PROP_DRIVERS_LOCATION, driversHome.getAbsolutePath());
    }

    public DriverDescriptor(DataSourceProviderDescriptor providerDescriptor, String id) {
        this(providerDescriptor, id, null);
    }

    public DriverDescriptor(DataSourceProviderDescriptor providerDescriptor, String id, DriverDescriptor copyFrom) {
        super(providerDescriptor.getPluginId());
        this.providerDescriptor = providerDescriptor;
        this.id = id;
        this.custom = true;
        this.useURLTemplate = true;
        this.promoted = 0;
        this.origName = null;
        this.origDescription = null;
        this.origClassName = null;
        this.origDefaultPort = null;
        this.origSampleURL = null;
        this.iconPlain = providerDescriptor.getIcon();
        if (this.iconPlain == null) {
            this.iconPlain = DBIcon.DATABASE_DEFAULT;
        }
        this.iconBig = DBIcon.DATABASE_BIG_DEFAULT;
        this.makeIconExtensions();
        if (copyFrom != null) {
            this.category = copyFrom.category;
            this.categories = new ArrayList<String>(copyFrom.categories);
            this.name = copyFrom.name;
            this.description = copyFrom.description;
            this.driverClassName = copyFrom.driverClassName;
            this.driverDefaultPort = copyFrom.driverDefaultPort;
            this.sampleURL = copyFrom.sampleURL;
            this.webURL = copyFrom.webURL;
            this.propertiesWebURL = copyFrom.webURL;
            this.embedded = copyFrom.embedded;
            this.clientRequired = copyFrom.clientRequired;
            this.supportsDriverProperties = copyFrom.supportsDriverProperties;
            this.anonymousAccess = copyFrom.anonymousAccess;
            this.allowsEmptyPassword = copyFrom.allowsEmptyPassword;
            this.licenseRequired = copyFrom.licenseRequired;
            this.customDriverLoader = copyFrom.customDriverLoader;
            this.useURLTemplate = copyFrom.customDriverLoader;
            this.promoted = copyFrom.promoted;
            this.nativeClientHomes.addAll(copyFrom.nativeClientHomes);
            for (DriverFileSource fs : copyFrom.fileSources) {
                this.fileSources.add(new DriverFileSource(fs));
            }
            for (DBPDriverLibrary library : copyFrom.libraries) {
                if (library instanceof DriverLibraryAbstract) {
                    this.libraries.add(((DriverLibraryAbstract)library).copyLibrary(this));
                    continue;
                }
                this.libraries.add(library);
            }
            this.connectionPropertyDescriptors.addAll(copyFrom.connectionPropertyDescriptors);
            this.defaultParameters.putAll(copyFrom.defaultParameters);
            this.customParameters.putAll(copyFrom.customParameters);
            this.defaultConnectionProperties.putAll(copyFrom.defaultConnectionProperties);
            this.customConnectionProperties.putAll(copyFrom.customConnectionProperties);
        } else {
            this.categories = new ArrayList<String>();
            this.name = "";
        }
    }

    public DriverDescriptor(DataSourceProviderDescriptor providerDescriptor, IConfigurationElement config) {
        super(providerDescriptor.getPluginId());
        IConfigurationElement[] replaceElements;
        String paramValue;
        String paramName;
        IConfigurationElement[] paramElements;
        IConfigurationElement[] propElements;
        IConfigurationElement[] osElements;
        IConfigurationElement lib;
        this.providerDescriptor = providerDescriptor;
        this.id = CommonUtils.notEmpty((String)config.getAttribute("id"));
        this.category = CommonUtils.notEmpty((String)config.getAttribute("category"));
        this.categories = Arrays.asList(CommonUtils.split((String)config.getAttribute("categories"), (String)","));
        this.origName = this.name = CommonUtils.notEmpty((String)config.getAttribute("label"));
        this.origDescription = this.description = config.getAttribute("description");
        this.origClassName = this.driverClassName = config.getAttribute("class");
        if (!CommonUtils.isEmpty((String)config.getAttribute("defaultPort"))) {
            this.origDefaultPort = this.driverDefaultPort = config.getAttribute("defaultPort");
        } else {
            this.driverDefaultPort = null;
            this.origDefaultPort = null;
        }
        this.origSampleURL = this.sampleURL = config.getAttribute("sampleURL");
        this.webURL = config.getAttribute("webURL");
        this.propertiesWebURL = config.getAttribute("propertiesURL");
        this.clientRequired = CommonUtils.getBoolean((String)config.getAttribute("clientRequired"), (boolean)false);
        this.customDriverLoader = CommonUtils.getBoolean((String)config.getAttribute("customDriverLoader"), (boolean)false);
        this.useURLTemplate = CommonUtils.getBoolean((String)config.getAttribute("useURL"), (boolean)true);
        this.promoted = CommonUtils.toInt((Object)config.getAttribute("promoted"), (int)0);
        this.supportsDriverProperties = CommonUtils.getBoolean((String)config.getAttribute("supportsDriverProperties"), (boolean)true);
        this.embedded = CommonUtils.getBoolean((String)config.getAttribute("embedded"));
        this.anonymousAccess = CommonUtils.getBoolean((String)config.getAttribute("anonymous"));
        this.allowsEmptyPassword = CommonUtils.getBoolean((String)"allowsEmptyPassword");
        this.licenseRequired = CommonUtils.getBoolean((String)config.getAttribute("licenseRequired"));
        this.custom = false;
        this.isLoaded = false;
        IConfigurationElement[] iConfigurationElementArray = config.getChildren("file");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            lib = iConfigurationElementArray[n2];
            DriverLibraryAbstract library = DriverLibraryAbstract.createFromConfig(this, lib);
            if (library != null) {
                this.libraries.add(library);
            }
            ++n2;
        }
        this.origFiles.addAll(this.libraries);
        iConfigurationElementArray = config.getChildren("fileSource");
        n = iConfigurationElementArray.length;
        n2 = 0;
        while (n2 < n) {
            lib = iConfigurationElementArray[n2];
            this.fileSources.add(new DriverFileSource(lib));
            ++n2;
        }
        this.iconPlain = this.iconToImage(config.getAttribute("icon"));
        if (this.iconPlain == null) {
            this.iconPlain = providerDescriptor.getIcon();
        }
        this.iconBig = this.iconPlain;
        if (config.getAttribute("iconBig") != null) {
            this.iconBig = this.iconToImage(config.getAttribute("iconBig"));
        }
        this.makeIconExtensions();
        IConfigurationElement[] iConfigurationElementArray2 = osElements = config.getChildren("os");
        int n3 = osElements.length;
        n = 0;
        while (n < n3) {
            IConfigurationElement os = iConfigurationElementArray2[n];
            this.supportedSystems.add(new OSDescriptor(os.getAttribute("name"), os.getAttribute("arch")));
            ++n;
        }
        iConfigurationElementArray2 = propElements = config.getChildren("propertyGroup");
        n3 = propElements.length;
        n = 0;
        while (n < n3) {
            IConfigurationElement prop = iConfigurationElementArray2[n];
            this.connectionPropertyDescriptors.addAll(PropertyDescriptor.extractProperties((IConfigurationElement)prop));
            ++n;
        }
        iConfigurationElementArray2 = paramElements = config.getChildren("parameter");
        n3 = paramElements.length;
        n = 0;
        while (n < n3) {
            IConfigurationElement param = iConfigurationElementArray2[n];
            paramName = param.getAttribute("name");
            paramValue = param.getAttribute("value");
            if (CommonUtils.isEmpty((String)paramValue)) {
                paramValue = param.getValue();
            }
            if (!CommonUtils.isEmpty((String)paramName) && !CommonUtils.isEmpty((String)paramValue)) {
                this.setDriverParameter(paramName, paramValue, true);
            }
            ++n;
        }
        iConfigurationElementArray2 = propElements = config.getChildren("property");
        n3 = propElements.length;
        n = 0;
        while (n < n3) {
            IConfigurationElement param = iConfigurationElementArray2[n];
            paramName = param.getAttribute("name");
            paramValue = param.getAttribute("value");
            if (CommonUtils.isEmpty((String)paramValue)) {
                paramValue = param.getValue();
            }
            if (!CommonUtils.isEmpty((String)paramName) && !CommonUtils.isEmpty((String)paramValue)) {
                this.defaultConnectionProperties.put(paramName, paramValue);
                if (!paramName.startsWith("@dbeaver-")) {
                    this.customConnectionProperties.put(paramName, paramValue);
                }
            }
            ++n;
        }
        iConfigurationElementArray2 = replaceElements = config.getChildren("replace");
        n3 = replaceElements.length;
        n = 0;
        while (n < n3) {
            IConfigurationElement replace = iConfigurationElementArray2[n];
            String providerId = replace.getAttribute("provider");
            String driverId = replace.getAttribute("driver");
            if (!CommonUtils.isEmpty((String)providerId) && !CommonUtils.isEmpty((String)driverId)) {
                this.driverReplacements.add(new ReplaceInfo(providerId, driverId));
            }
            ++n;
        }
    }

    Map<Object, Object> getDefaultParameters() {
        return this.defaultParameters;
    }

    Map<Object, Object> getCustomParameters() {
        return this.customParameters;
    }

    Map<Object, Object> getCustomConnectionProperties() {
        return this.customConnectionProperties;
    }

    Map<DBPDriverLibrary, List<DriverFileInfo>> getResolvedFiles() {
        return this.resolvedFiles;
    }

    List<DBPNativeClientLocation> getNativeClientHomes() {
        return this.nativeClientHomes;
    }

    public DriverDescriptor getReplacedBy() {
        return this.replacedBy;
    }

    public void setReplacedBy(DriverDescriptor replaceBy) {
        this.replacedBy = replaceBy;
    }

    public boolean replaces(DriverDescriptor driver) {
        for (ReplaceInfo replaceInfo : this.driverReplacements) {
            if (!driver.getProviderDescriptor().getId().equals(replaceInfo.providerId) || !driver.getId().equals(replaceInfo.driverId)) continue;
            return true;
        }
        return false;
    }

    private void makeIconExtensions() {
        this.iconNormal = this.isCustom() ? new DBIconComposite(this.iconPlain, false, null, null, (DBPImage)DBIcon.OVER_LAMP, null) : this.iconPlain;
        this.iconError = new DBIconComposite(this.iconPlain, false, null, null, (DBPImage)(this.isCustom() ? DBIcon.OVER_LAMP : null), (DBPImage)DBIcon.OVER_ERROR);
    }

    @Nullable
    public DriverClassLoader getClassLoader() {
        return this.classLoader;
    }

    public DataSourceProviderDescriptor getProviderDescriptor() {
        return this.providerDescriptor;
    }

    @NotNull
    public DBPDataSourceProvider getDataSourceProvider() {
        return this.providerDescriptor.getInstance(this);
    }

    @Nullable
    public DBPNativeClientLocationManager getNativeClientManager() {
        DBPDataSourceProvider provider = this.getDataSourceProvider();
        if (provider instanceof DBPNativeClientLocationManager) {
            return (DBPNativeClientLocationManager)provider;
        }
        return null;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    public String getProviderId() {
        return this.providerDescriptor.getId();
    }

    @Property(viewable=true, order=2)
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public List<String> getCategories() {
        return new ArrayList<String>(this.categories);
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Property(viewable=true, multiline=true, order=100)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @NotNull
    public String getFullName() {
        if (CommonUtils.isEmpty((String)this.category) || this.name.contains(this.category)) {
            return this.name;
        }
        return String.valueOf(this.category) + " / " + this.name;
    }

    @NotNull
    public DBPImage getPlainIcon() {
        return this.iconPlain;
    }

    @NotNull
    public DBPImage getIcon() {
        if (!this.isLoaded && this.isFailed) {
            return this.iconError;
        }
        return this.iconNormal;
    }

    public DBPImage getIconBig() {
        return this.iconBig;
    }

    public boolean isCustom() {
        return this.custom;
    }

    public void setCustom(boolean custom) {
        this.custom = custom;
    }

    public boolean isModified() {
        return !this.isTemporary() && this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    @Property(viewable=true, order=2)
    @Nullable
    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        if (this.driverClassName == null || !this.driverClassName.equals(driverClassName)) {
            this.driverClassName = driverClassName;
            this.resetDriverInstance();
        }
    }

    @NotNull
    public Object getDriverInstance(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.driverInstance == null) {
            this.loadDriver(monitor);
        }
        if (this.isInternalDriver() && this.driverInstance == null) {
            return this.createDriverInstance();
        }
        return this.driverInstance;
    }

    private void resetDriverInstance() {
        this.driverInstance = null;
        this.driverClass = null;
        this.isLoaded = false;
        this.resolvedFiles.clear();
    }

    private Object createDriverInstance() throws DBException {
        try {
            return this.driverClass.newInstance();
        }
        catch (InstantiationException ex) {
            throw new DBException("Can't instantiate driver class", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new DBException("Illegal access", (Throwable)ex);
        }
        catch (ClassCastException ex) {
            throw new DBException("Bad driver class name specified", (Throwable)ex);
        }
        catch (Throwable ex) {
            throw new DBException("Error during driver instantiation", ex);
        }
    }

    @Nullable
    public String getDefaultPort() {
        return this.driverDefaultPort;
    }

    public void setDriverDefaultPort(String driverDefaultPort) {
        this.driverDefaultPort = driverDefaultPort;
    }

    @Property(viewable=true, order=3)
    @Nullable
    public String getSampleURL() {
        return this.sampleURL;
    }

    public void setSampleURL(String sampleURL) {
        this.sampleURL = sampleURL;
    }

    @Nullable
    public String getWebURL() {
        return this.webURL;
    }

    @Nullable
    public String getPropertiesWebURL() {
        return this.propertiesWebURL;
    }

    @NotNull
    public SQLDialectMetadata getScriptDialect() {
        return this.providerDescriptor.getScriptDialect();
    }

    public boolean isClientRequired() {
        return this.clientRequired;
    }

    public boolean supportsDriverProperties() {
        return this.supportsDriverProperties;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public void setEmbedded(boolean embedded) {
        this.embedded = embedded;
    }

    public boolean isAnonymousAccess() {
        return this.anonymousAccess;
    }

    public void setAnonymousAccess(boolean anonymousAccess) {
        this.anonymousAccess = anonymousAccess;
    }

    public boolean isAllowsEmptyPassword() {
        return this.allowsEmptyPassword;
    }

    public void setAllowsEmptyPassword(boolean allowsEmptyPassword) {
        this.allowsEmptyPassword = allowsEmptyPassword;
    }

    public boolean isLicenseRequired() {
        return this.licenseRequired;
    }

    public boolean isCustomDriverLoader() {
        return this.customDriverLoader;
    }

    void setCustomDriverLoader(boolean customDriverLoader) {
        this.customDriverLoader = customDriverLoader;
    }

    public boolean isUseURL() {
        return this.useURLTemplate;
    }

    public void setUseURL(boolean useURLTemplate) {
        this.useURLTemplate = useURLTemplate;
    }

    public int getPromotedScore() {
        return this.promoted;
    }

    public boolean isInstantiable() {
        return !CommonUtils.isEmpty((String)this.driverClassName);
    }

    public boolean isTemporary() {
        return this.temporary || this.providerDescriptor.isTemporary();
    }

    public void setTemporary(boolean temporary) {
        this.temporary = temporary;
    }

    @Nullable
    public DBXTreeNode getNavigatorRoot() {
        return this.providerDescriptor.getTreeDescriptor();
    }

    public boolean isManagable() {
        return this.getProviderDescriptor().isDriversManagable();
    }

    public boolean isInternalDriver() {
        return this.driverClassName != null && this.driverClassName.contains("sun.jdbc");
    }

    @NotNull
    public List<DBPNativeClientLocation> getNativeClientLocations() {
        ArrayList<DBPNativeClientLocation> ids = new ArrayList<DBPNativeClientLocation>();
        for (NativeClientDescriptor nc : this.getProviderDescriptor().getNativeClients()) {
            if (nc.findDistribution() == null) continue;
            ids.add(new RemoteNativeClientLocation(nc));
        }
        ids.addAll(this.nativeClientHomes);
        return ids;
    }

    public void setNativeClientLocations(Collection<DBPNativeClientLocation> locations) {
        this.nativeClientHomes.clear();
        this.nativeClientHomes.addAll(locations);
    }

    void addNativeClientLocation(DBPNativeClientLocation location) {
        if (!this.nativeClientHomes.contains(location)) {
            this.nativeClientHomes.add(location);
        }
    }

    @NotNull
    public List<? extends DBPDriverLibrary> getDriverLibraries() {
        return this.libraries;
    }

    public List<DBPDriverLibrary> getEnabledDriverLibraries() {
        ArrayList<DBPDriverLibrary> filtered = new ArrayList<DBPDriverLibrary>();
        for (DBPDriverLibrary lib : this.libraries) {
            if (lib.isDisabled()) continue;
            filtered.add(lib);
        }
        return filtered;
    }

    DBPDriverLibrary getDriverLibrary(String path) {
        for (DBPDriverLibrary lib : this.libraries) {
            if (!lib.getPath().equals(path)) continue;
            return lib;
        }
        return null;
    }

    void addLibraryFile(DBPDriverLibrary library, DriverFileInfo fileInfo) {
        List files = this.resolvedFiles.computeIfAbsent(library, k -> new ArrayList());
        files.add(fileInfo);
    }

    public DBPDriverLibrary addDriverLibrary(String path, DBPDriverLibrary.FileType fileType) {
        DBPDriverLibrary lib2;
        for (DBPDriverLibrary lib2 : this.libraries) {
            if (!lib2.getPath().equals(path)) continue;
            return lib2;
        }
        lib2 = DriverLibraryAbstract.createFromPath(this, fileType, path, null);
        this.addDriverLibrary(lib2, true);
        return lib2;
    }

    public boolean addDriverLibrary(DBPDriverLibrary descriptor, boolean resetCache) {
        if (!this.libraries.contains(descriptor)) {
            if (resetCache) {
                this.resetDriverInstance();
            }
            this.libraries.add(descriptor);
            return true;
        }
        return false;
    }

    public boolean removeDriverLibrary(DBPDriverLibrary lib) {
        this.resetDriverInstance();
        if (!lib.isCustom()) {
            lib.setDisabled(true);
            return true;
        }
        return this.libraries.remove(lib);
    }

    @NotNull
    public List<DriverFileSource> getDriverFileSources() {
        return this.fileSources;
    }

    @NotNull
    public List<DBPPropertyDescriptor> getConnectionPropertyDescriptors() {
        return this.connectionPropertyDescriptors;
    }

    @NotNull
    public Map<Object, Object> getDefaultConnectionProperties() {
        return this.defaultConnectionProperties;
    }

    @NotNull
    public Map<Object, Object> getConnectionProperties() {
        return this.customConnectionProperties;
    }

    public void setConnectionProperty(String name, String value) {
        this.customConnectionProperties.put(name, value);
    }

    public void setConnectionProperties(Map<Object, Object> parameters) {
        this.customConnectionProperties.clear();
        this.customConnectionProperties.putAll(parameters);
    }

    public Map<Object, Object> getDefaultDriverParameters() {
        return this.defaultParameters;
    }

    @NotNull
    public Map<Object, Object> getDriverParameters() {
        return this.customParameters;
    }

    @Nullable
    public Object getDriverParameter(String name) {
        DBPPropertyDescriptor defProperty;
        Object value = this.customParameters.get(name);
        if (value == null && (defProperty = this.providerDescriptor.getDriverProperty(name)) != null) {
            return defProperty.getDefaultValue();
        }
        return value;
    }

    public void setDriverParameter(String name, String value, boolean setDefault) {
        DBPPropertyDescriptor prop = this.getProviderDescriptor().getDriverProperty(name);
        String valueObject = prop == null ? value : GeneralUtils.convertString((String)value, (Class)prop.getDataType());
        this.customParameters.put(name, valueObject);
        if (setDefault) {
            this.defaultParameters.put(name, valueObject);
        }
    }

    public void setDriverParameters(Map<Object, Object> parameters) {
        this.customParameters.clear();
        this.customParameters.putAll(parameters);
    }

    public boolean isSupportedByLocalSystem() {
        if (this.supportedSystems.isEmpty()) {
            return true;
        }
        OSDescriptor localSystem = DBWorkbench.getPlatform().getLocalSystem();
        for (OSDescriptor system : this.supportedSystems) {
            if (!system.matches(localSystem)) continue;
            return true;
        }
        return false;
    }

    public String getLicense() {
        for (DBPDriverLibrary file : this.libraries) {
            File licenseFile;
            if (file.getType() != DBPDriverLibrary.FileType.license || (licenseFile = file.getLocalFile()) == null || !licenseFile.exists()) continue;
            try {
                return ContentUtils.readFileToString((File)licenseFile);
            }
            catch (IOException e) {
                log.warn((Object)e);
            }
        }
        return null;
    }

    public void loadDriver(DBRProgressMonitor monitor) throws DBException {
        this.loadDriver(monitor, false);
    }

    private void loadDriver(DBRProgressMonitor monitor, boolean forceReload) throws DBException {
        block6: {
            String licenseText;
            if (this.isLoaded && !forceReload) {
                return;
            }
            this.isLoaded = false;
            this.loadLibraries();
            if (this.licenseRequired && !CommonUtils.isEmpty((String)(licenseText = this.getLicense())) && !this.acceptLicense(licenseText)) {
                throw new DBException("You have to accept driver '" + this.getFullName() + "' license to be able to connect");
            }
            try {
                if (this.isCustomDriverLoader()) break block6;
                try {
                    this.driverClass = Class.forName(this.driverClassName, true, this.classLoader);
                }
                catch (Throwable ex) {
                    throw new DBException("Error creating driver '" + this.getFullName() + "' instance.\nMost likely required jar files are missing.\nYou should configure jars in driver settings.\n\nReason: can't load driver class '" + this.driverClassName + "'", ex);
                }
                this.driverInstance = this.createDriverInstance();
                this.isLoaded = true;
                this.isFailed = false;
            }
            catch (DBException e) {
                this.isFailed = true;
                throw e;
            }
        }
    }

    private void loadLibraries() throws DBException {
        this.classLoader = null;
        List<File> allLibraryFiles = this.validateFilesPresence(false);
        ArrayList<URL> libraryURLs = new ArrayList<URL>();
        for (File file : allLibraryFiles) {
            URL url;
            try {
                url = file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                log.error((Object)e);
                continue;
            }
            libraryURLs.add(url);
        }
        this.classLoader = new DriverClassLoader(this, libraryURLs.toArray(new URL[0]), this.getDataSourceProvider().getClass().getClassLoader());
    }

    public void updateFiles() {
        this.validateFilesPresence(true);
    }

    @NotNull
    private List<File> validateFilesPresence(boolean resetVersions) {
        boolean localLibsExists = false;
        ArrayList<DBPDriverLibrary> downloadCandidates = new ArrayList<DBPDriverLibrary>();
        for (DBPDriverLibrary library : this.libraries) {
            if (library.isDisabled() || !library.matchesCurrentPlatform()) continue;
            if (library.isDownloadable()) {
                boolean allExists = true;
                if (resetVersions) {
                    allExists = false;
                } else {
                    List<DriverFileInfo> files = this.resolvedFiles.get(library);
                    if (files == null) {
                        allExists = false;
                    } else {
                        for (DriverFileInfo driverFileInfo : files) {
                            if (driverFileInfo.file != null && driverFileInfo.file.exists()) continue;
                            allExists = false;
                            break;
                        }
                    }
                }
                if (allExists) continue;
                downloadCandidates.add(library);
                continue;
            }
            localLibsExists = true;
        }
        boolean downloaded = false;
        if (!downloadCandidates.isEmpty() || !localLibsExists && !this.fileSources.isEmpty()) {
            DriverDependencies dependencies = new DriverDependencies(downloadCandidates);
            boolean downloadOk = DBWorkbench.getPlatformUI().downloadDriverFiles((DBPDriver)this, (DBPDriverDependencies)dependencies);
            if (!downloadOk) {
                return Collections.emptyList();
            }
            if (resetVersions) {
                this.resetDriverInstance();
            }
            downloaded = true;
            for (DBPDriverDependencies.DependencyNode node : dependencies.getLibraryMap()) {
                ArrayList<DriverFileInfo> info = new ArrayList<DriverFileInfo>();
                this.resolvedFiles.put(node.library, info);
                this.collectLibraryFiles(node, info);
            }
            this.providerDescriptor.getRegistry().saveDrivers();
        }
        ArrayList<File> result = new ArrayList<File>();
        for (DBPDriverLibrary library : this.libraries) {
            if (library.isDisabled() || !library.matchesCurrentPlatform()) continue;
            if (library.isDownloadable()) {
                List<DriverFileInfo> list = this.resolvedFiles.get(library);
                if (list == null) continue;
                for (DriverFileInfo file : list) {
                    if (file.file == null) continue;
                    result.add(file.file);
                }
                continue;
            }
            if (library.getLocalFile() == null) continue;
            result.add(library.getLocalFile());
        }
        if (DBWorkbench.getPlatform().getPreferenceStore().getBoolean("ui.drivers.version.update")) {
            // empty if block
        }
        return DriverUtils.extractZipArchives(result);
    }

    List<DriverFileInfo> getCachedFiles(DBPDriverLibrary library) {
        return this.resolvedFiles.get(library);
    }

    private void checkDriverVersion(DBRProgressMonitor monitor) throws IOException {
        for (DBPDriverLibrary library : this.libraries) {
            Collection availableVersions = library.getAvailableVersions(monitor);
            if (CommonUtils.isEmpty((Collection)availableVersions)) continue;
            String curVersion = library.getVersion();
            String latestVersion = VersionUtils.findLatestVersion(availableVersions);
            if (latestVersion == null || latestVersion.equals(curVersion)) continue;
            log.debug((Object)("Update driver " + this.getName() + " " + curVersion + "->" + latestVersion));
        }
    }

    public boolean isLibraryResolved(DBPDriverLibrary library) {
        return !library.isDownloadable() || !CommonUtils.isEmpty((Collection)this.resolvedFiles.get(library));
    }

    public Collection<DriverFileInfo> getLibraryFiles(DBPDriverLibrary library) {
        return this.resolvedFiles.get(library);
    }

    private void collectLibraryFiles(DBPDriverDependencies.DependencyNode node, List<DriverFileInfo> files) {
        if (node.duplicate) {
            return;
        }
        files.add(new DriverFileInfo(node.library));
        for (DBPDriverDependencies.DependencyNode sub : node.dependencies) {
            this.collectLibraryFiles(sub, files);
        }
    }

    private boolean acceptLicense(String licenseText) {
        DBPPreferenceStore prefs = DBWorkbench.getPlatform().getPreferenceStore();
        String acceptedStr = prefs.getString(LICENSE_ACCEPT_KEY + this.getId());
        if (!CommonUtils.isEmpty((String)acceptedStr)) {
            return true;
        }
        if (DBWorkbench.getPlatformUI().acceptLicense("You have to accept license of '" + this.getFullName() + " ' to continue", licenseText)) {
            prefs.setValue(LICENSE_ACCEPT_KEY + this.getId(), "true:" + System.currentTimeMillis() + ":" + System.getProperty("user.name"));
            return true;
        }
        return false;
    }

    public String getOrigName() {
        return this.origName;
    }

    public String getOrigDescription() {
        return this.origDescription;
    }

    public String getOrigClassName() {
        return this.origClassName;
    }

    public String getOrigDefaultPort() {
        return this.origDefaultPort;
    }

    public String getOrigSampleURL() {
        return this.origSampleURL;
    }

    public List<DBPDriverLibrary> getOrigFiles() {
        return this.origFiles;
    }

    public static File getDriversContribFolder() throws IOException {
        return new File(Platform.getInstallLocation().getDataArea(DRIVERS_FOLDER).toExternalForm());
    }

    public void serialize(JsonWriter json, boolean export) throws IOException {
        new DriverDescriptorSerializerModern(this).serialize(json, export);
    }

    @Deprecated
    public void serialize(XMLBuilder xml, boolean export) throws IOException {
        new DriverDescriptorSerializerLegacy(this).serialize(xml, export);
    }

    public DBPNativeClientLocation getDefaultClientLocation() {
        DBPNativeClientLocationManager clientManager = this.getNativeClientManager();
        if (clientManager != null) {
            return clientManager.getDefaultLocalClientLocation();
        }
        return null;
    }

    public static File getCustomDriversHome() {
        String driversHome = DBWorkbench.getPlatform().getPreferenceStore().getString("ui.drivers.home");
        File homeFolder = !CommonUtils.isEmpty((String)driversHome) ? new File(driversHome) : new File(DBWorkbench.getPlatform().getWorkspace().getAbsolutePath().getParent(), DRIVERS_FOLDER);
        if (!homeFolder.exists() && !homeFolder.mkdirs()) {
            log.warn((Object)("Can't create drivers folder '" + homeFolder.getAbsolutePath() + "'"));
        }
        return homeFolder;
    }

    public static String[] getDriversSources() {
        String sourcesString = DBWorkbench.getPlatform().getPreferenceStore().getString("ui.drivers.sources");
        List pathList = CommonUtils.splitString((String)sourcesString, (char)'|');
        return pathList.toArray(new String[0]);
    }

    public static String getDriversPrimarySource() {
        String sourcesString = DBWorkbench.getPlatform().getPreferenceStore().getString("ui.drivers.sources");
        int divPos = sourcesString.indexOf(124);
        return divPos == -1 ? sourcesString : sourcesString.substring(0, divPos);
    }

    public String toString() {
        return this.name;
    }

    public static class DriverFileInfo {
        private final String id;
        private final String version;
        private final File file;

        DriverFileInfo(String id, String version, File file) {
            this.id = id;
            this.version = version;
            this.file = file;
        }

        DriverFileInfo(DBPDriverLibrary library) {
            this.id = library.getId();
            this.version = library.getVersion();
            this.file = library.getLocalFile();
        }

        public File getFile() {
            return this.file;
        }

        public String getId() {
            return this.id;
        }

        public String getVersion() {
            return this.version;
        }

        public String toString() {
            return this.file.getName();
        }
    }

    private static class ReplaceInfo {
        String providerId;
        String driverId;

        private ReplaceInfo(String providerId, String driverId) {
            this.providerId = providerId;
            this.driverId = driverId;
        }
    }
}

