/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.tools.transfer.IDataTransferNode;
import org.jkiss.dbeaver.tools.transfer.IDataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferProcessorDescriptor;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DataTransferNodeDescriptor
extends AbstractDescriptor {
    @NotNull
    private final String id;
    @NotNull
    private final String name;
    private final String description;
    @NotNull
    private final DBPImage icon;
    private final NodeType nodeType;
    private final AbstractDescriptor.ObjectType implType;
    private final AbstractDescriptor.ObjectType settingsType;
    private final List<AbstractDescriptor.ObjectType> sourceTypes = new ArrayList<AbstractDescriptor.ObjectType>();
    private final List<DataTransferProcessorDescriptor> processors = new ArrayList<DataTransferProcessorDescriptor>();

    public DataTransferNodeDescriptor(IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("id");
        this.name = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.icon = this.iconToImage(config.getAttribute("icon"), (DBPImage)DBIcon.TYPE_UNKNOWN);
        this.nodeType = (NodeType)CommonUtils.valueOf(NodeType.class, (String)config.getAttribute("type").toUpperCase(Locale.ENGLISH), (Enum)NodeType.PRODUCER);
        this.implType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        this.settingsType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("settings"));
        for (IConfigurationElement typeCfg : ArrayUtils.safeArray((Object[])config.getChildren("sourceType"))) {
            this.sourceTypes.add(new AbstractDescriptor.ObjectType((AbstractDescriptor)this, typeCfg.getAttribute("type")));
        }
        this.loadNodeConfigurations(config);
    }

    void loadNodeConfigurations(IConfigurationElement config) {
        ArrayList<DataTransferProcessorDescriptor> procList = new ArrayList<DataTransferProcessorDescriptor>();
        for (IConfigurationElement processorConfig : ArrayUtils.safeArray((Object[])config.getChildren("processor"))) {
            procList.add(new DataTransferProcessorDescriptor(this, processorConfig));
        }
        procList.sort(Comparator.comparing(DataTransferProcessorDescriptor::getName));
        this.processors.addAll(procList);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    @NotNull
    public DBPImage getIcon() {
        return this.icon;
    }

    public Class<? extends IDataTransferNode> getNodeClass() {
        return this.implType.getObjectClass(IDataTransferNode.class);
    }

    public IDataTransferNode createNode() throws DBException {
        this.implType.checkObjectClass(IDataTransferNode.class);
        try {
            return (IDataTransferNode)this.implType.getObjectClass(IDataTransferNode.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            throw new DBException("Can't create data transformer node", e);
        }
    }

    public IDataTransferSettings createSettings() throws DBException {
        this.settingsType.checkObjectClass(IDataTransferSettings.class);
        try {
            return (IDataTransferSettings)this.settingsType.getObjectClass(IDataTransferSettings.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            throw new DBException("Can't create node settings", e);
        }
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public boolean appliesToType(Class objectType) {
        if (!this.sourceTypes.isEmpty()) {
            for (AbstractDescriptor.ObjectType sourceType : this.sourceTypes) {
                if (!sourceType.matchesType(objectType)) continue;
                return true;
            }
        }
        for (DataTransferProcessorDescriptor processor : this.processors) {
            if (!processor.appliesToType(objectType)) continue;
            return true;
        }
        return false;
    }

    public DataTransferProcessorDescriptor[] getProcessors() {
        return this.processors.toArray(new DataTransferProcessorDescriptor[0]);
    }

    public Collection<DataTransferProcessorDescriptor> getAvailableProcessors(Collection<DBSObject> sourceObjects) {
        ArrayList<DataTransferProcessorDescriptor> editors = new ArrayList<DataTransferProcessorDescriptor>();
        for (DataTransferProcessorDescriptor descriptor : this.processors) {
            boolean supports = true;
            for (DBSObject sourceObject : sourceObjects) {
                if (descriptor.appliesToType(sourceObject.getClass())) continue;
                boolean adapts = false;
                if (sourceObject instanceof IAdaptable && descriptor.adaptsToType((IAdaptable)sourceObject)) {
                    adapts = true;
                }
                if (adapts) continue;
                supports = false;
                break;
            }
            if (!supports) continue;
            editors.add(descriptor);
        }
        return editors;
    }

    public DataTransferProcessorDescriptor getProcessor(String id) {
        for (DataTransferProcessorDescriptor descriptor : this.processors) {
            if (!descriptor.getId().equals(id)) continue;
            return descriptor;
        }
        return null;
    }

    public String toString() {
        return this.id;
    }

    public static enum NodeType {
        PRODUCER,
        CONSUMER;

    }
}

