/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleGlobalObject;
import org.jkiss.dbeaver.ext.oracle.model.OracleObject;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class OracleUserProfile
extends OracleGlobalObject {
    private static final Log log = Log.getLog(OracleUserProfile.class);
    private String name;
    private List<ProfileResource> resources;

    public OracleUserProfile(OracleDataSource dataSource, ResultSet resultSet) {
        super(dataSource, resultSet != null);
        this.name = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"PROFILE");
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Association
    public Collection<ProfileResource> getResources(DBRProgressMonitor monitor) throws DBException {
        if (this.resources == null) {
            this.getDataSource().profileCache.loadChildren(monitor, (DBSObject)this.getDataSource(), this);
        }
        return this.resources;
    }

    boolean isResourcesCached() {
        return this.resources != null;
    }

    void setResources(List<ProfileResource> resources) {
        this.resources = resources;
    }

    public static class ProfileResource
    extends OracleObject<OracleUserProfile> {
        private static final Log log = Log.getLog(ProfileResource.class);
        private String type;
        private String limit;

        public ProfileResource(OracleUserProfile profile, ResultSet resultSet) {
            super(profile, JDBCUtils.safeGetString((ResultSet)resultSet, (String)"RESOURCE_NAME"), true);
            this.type = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"RESOURCE_TYPE");
            this.limit = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"LIMIT");
        }

        @Override
        @Property(viewable=true, order=1)
        @NotNull
        public String getName() {
            return super.getName();
        }

        @Property(viewable=true, order=2)
        public String getType() {
            return this.type;
        }

        @Property(viewable=true, order=3)
        public String getLimit() {
            return this.limit;
        }
    }
}

