/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tasks;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreNativeToolHandler;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreScriptExecuteSettings;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.registry.task.TaskPreferenceStore;
import org.jkiss.dbeaver.tasks.nativetool.AbstractNativeToolHandler;
import org.jkiss.dbeaver.tasks.nativetool.AbstractNativeToolSettings;

public class PostgreScriptExecuteHandler
extends PostgreNativeToolHandler<PostgreScriptExecuteSettings, DBSObject, PostgreDatabase> {
    public Collection<PostgreDatabase> getRunInfo(PostgreScriptExecuteSettings settings) {
        return Collections.singletonList(settings.getDatabase());
    }

    protected PostgreScriptExecuteSettings createTaskSettings(DBRRunnableContext context, DBTTask task) throws DBException {
        PostgreScriptExecuteSettings settings = new PostgreScriptExecuteSettings();
        settings.loadSettings(context, (DBPPreferenceStore)new TaskPreferenceStore(task));
        return settings;
    }

    protected boolean needsModelRefresh() {
        return true;
    }

    @Override
    public boolean isVerbose() {
        return false;
    }

    @Override
    public void fillProcessParameters(PostgreScriptExecuteSettings settings, PostgreDatabase arg, List<String> cmd) throws IOException {
        super.fillProcessParameters(settings, arg, cmd);
        if (arg.getDataSource().isServerVersionAtLeast(9, 5)) {
            cmd.add("--echo-errors");
        }
    }

    @Override
    protected boolean isExportWizard() {
        return false;
    }

    protected List<String> getCommandLine(PostgreScriptExecuteSettings settings, PostgreDatabase arg) throws IOException {
        ArrayList<String> cmd = new ArrayList<String>();
        this.fillProcessParameters(settings, arg, cmd);
        cmd.add(arg.getName());
        return cmd;
    }

    protected boolean isLogInputStream() {
        return true;
    }

    protected void startProcessHandler(DBRProgressMonitor monitor, DBTTask task, PostgreScriptExecuteSettings settings, PostgreDatabase arg, ProcessBuilder processBuilder, Process process, Log log) throws IOException {
        super.startProcessHandler(monitor, task, (AbstractNativeToolSettings)settings, (Object)arg, processBuilder, process, log);
        new AbstractNativeToolHandler.BinaryFileTransformerJob(monitor, task, new File(settings.getInputFile()), process.getOutputStream(), log).start();
    }
}

