/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tasks;

import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.tasks.nativetool.AbstractImportExportSettings;
import org.jkiss.utils.CommonUtils;

public class PostgreBackupRestoreSettings
extends AbstractImportExportSettings<DBSObject> {
    private ExportFormat format = ExportFormat.CUSTOM;

    public ExportFormat getFormat() {
        return this.format;
    }

    public void setFormat(ExportFormat format) {
        this.format = format;
    }

    public void loadSettings(DBRRunnableContext runnableContext, DBPPreferenceStore store) throws DBException {
        super.loadSettings(runnableContext, store);
        this.format = (ExportFormat)CommonUtils.valueOf(ExportFormat.class, (String)store.getString("pg.format"), (Enum)ExportFormat.CUSTOM);
    }

    public void saveSettings(DBRRunnableContext runnableContext, DBPPreferenceStore store) {
        super.saveSettings(runnableContext, store);
        store.setValue("pg.format", this.format == null ? null : this.format.name());
    }

    public static enum ExportFormat {
        PLAIN("p", "Plain"),
        CUSTOM("c", "Custom"),
        DIRECTORY("d", "Directory"),
        TAR("t", "Tar");

        private final String id;
        private String title;

        private ExportFormat(String id, String title) {
            this.id = id;
            this.title = title;
        }

        public String getId() {
            return this.id;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

