/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.auth.DBAAuthModel;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class AuthModelPgPass
implements DBAAuthModel {
    private static final Log log = Log.getLog(AuthModelPgPass.class);
    public static final String PGPASSFILE_ENV_VARIABLE = "PGPASSFILE";

    public void initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) throws DBException {
        this.loadPasswordFromPgPass(configuration);
    }

    public void endAuthentication(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) {
    }

    /*
     * Unable to fully structure code
     */
    private void loadPasswordFromPgPass(DBPConnectionConfiguration configuration) throws DBException {
        pgPassPath = System.getenv("PGPASSFILE");
        if (CommonUtils.isEmpty((String)pgPassPath)) {
            if (RuntimeUtils.isPlatformWindows()) {
                appData = System.getenv("AppData");
                if (appData == null) {
                    appData = System.getProperty("user.home");
                }
                pgPassPath = String.valueOf(appData) + "/postgresql/pgpass.conf";
            } else {
                pgPassPath = String.valueOf(System.getProperty("user.home")) + "/.pgpass";
            }
        }
        if (!(pgPassFile = new File(pgPassPath)).exists()) {
            throw new DBException("PgPass file '" + pgPassFile.getAbsolutePath() + "' not found");
        }
        try {
            var4_4 = null;
            var5_7 = null;
            try {
                r = new InputStreamReader((InputStream)new FileInputStream(pgPassFile), GeneralUtils.UTF8_CHARSET);
                try {
                    passString = IOUtils.readToString((Reader)r);
                    var12_12 = lines = passString.split("\n");
                    var11_13 = lines.length;
                    var10_14 = 0;
                    while (true) {
                        line = var12_12[var10_14];
                        if (!(line = line.trim()).isEmpty() && !line.startsWith("#") && (params = line.split(":")).length >= 5) {
                            host = params[0];
                            port = params[1];
                            database = params[2];
                            user = params[3];
                            password = params[4];
                            if (AuthModelPgPass.matchParam(configuration.getHostName(), host) && AuthModelPgPass.matchParam(configuration.getHostPort(), port) && AuthModelPgPass.matchParam(configuration.getDatabaseName(), database) && AuthModelPgPass.matchParam(configuration.getUserName(), user)) {
                                if (!user.equals("*")) {
                                    configuration.setUserName(user);
                                }
                                configuration.setUserPassword(password);
                                return;
                            }
                        }
                        ++var10_14;
                        break;
                    }
                }
                finally {
                    if (var10_14 < var11_13) ** continue;
                }
            }
            catch (Throwable var5_8) {
                if (var4_4 == null) {
                    var4_4 = var5_8;
                } else if (var4_4 != var5_8) {
                    var4_4.addSuppressed(var5_8);
                }
                throw var4_4;
            }
        }
        catch (IOException e) {
            throw new DBException("Error reading pgpass", (Throwable)e);
        }
        throw new DBException("No matches in pgpass");
    }

    private static boolean matchParam(String cfgParam, String passParam) {
        return passParam.equals("*") || passParam.equalsIgnoreCase(cfgParam);
    }
}

