/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericTableConstraintColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericUniqueKey;
import org.jkiss.dbeaver.ext.generic.model.GenericUtils;
import org.jkiss.dbeaver.ext.generic.model.TableCache;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaObject;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCCompositeCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

class ConstraintKeysCache
extends JDBCCompositeCache<GenericStructContainer, GenericTableBase, GenericUniqueKey, GenericTableConstraintColumn> {
    private final GenericMetaObject pkObject;

    ConstraintKeysCache(TableCache tableCache) {
        super((JDBCStructCache)tableCache, GenericTableBase.class, GenericUtils.getColumn(tableCache.getDataSource(), "primary-key", "TABLE_NAME"), GenericUtils.getColumn(tableCache.getDataSource(), "primary-key", "PK_NAME"));
        this.pkObject = tableCache.getDataSource().getMetaObject("primary-key");
    }

    @NotNull
    protected JDBCStatement prepareObjectsStatement(JDBCSession session, GenericStructContainer owner, GenericTableBase forParent) throws SQLException {
        try {
            return owner.getDataSource().getMetaModel().prepareUniqueConstraintsLoadStatement(session, owner, forParent);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            if (forParent == null) {
                throw new SQLException("Global primary keys read not supported", e);
            }
            throw new SQLException(e);
        }
    }

    protected String getDefaultObjectName(JDBCResultSet dbResult, String parentName) {
        GenericUtils.safeGetInt(this.pkObject, (ResultSet)dbResult, "KEY_SEQ");
        return String.valueOf(parentName.toUpperCase(Locale.ENGLISH)) + "_PK";
    }

    @Nullable
    protected GenericUniqueKey fetchObject(JDBCSession session, GenericStructContainer owner, GenericTableBase parent, String pkName, JDBCResultSet dbResult) throws SQLException, DBException {
        return new GenericUniqueKey(parent, pkName, null, owner.getDataSource().getMetaModel().getUniqueConstraintType(dbResult), true);
    }

    @Nullable
    protected GenericTableConstraintColumn[] fetchObjectRow(JDBCSession session, GenericTableBase parent, GenericUniqueKey object, JDBCResultSet dbResult) throws SQLException, DBException {
        String columnName = GenericUtils.safeGetStringTrimmed(this.pkObject, (ResultSet)dbResult, "COLUMN_NAME");
        if (CommonUtils.isEmpty((String)columnName)) {
            log.debug((Object)("Null primary key column for '" + object.getName() + "'"));
            return null;
        }
        if (columnName.startsWith("[") && columnName.endsWith("]") || columnName.startsWith("\"") && columnName.endsWith("\"")) {
            columnName = columnName.substring(1, columnName.length() - 1);
        }
        int keySeq = GenericUtils.safeGetInt(this.pkObject, (ResultSet)dbResult, "KEY_SEQ");
        GenericTableColumn tableColumn = parent.getAttribute(session.getProgressMonitor(), columnName);
        if (tableColumn == null) {
            log.warn((Object)("Column '" + columnName + "' not found in table '" + parent.getFullyQualifiedName(DBPEvaluationContext.DDL) + "' for PK '" + object.getFullyQualifiedName(DBPEvaluationContext.DDL) + "'"));
            return null;
        }
        return new GenericTableConstraintColumn[]{new GenericTableConstraintColumn(object, tableColumn, keySeq)};
    }

    protected void cacheChildren(DBRProgressMonitor monitor, GenericUniqueKey primaryKey, List<GenericTableConstraintColumn> rows) {
        primaryKey.setColumns(rows);
    }
}

