/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.registry;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.registry.SQLPresentationDescriptor;

public class SQLPresentationRegistry {
    static final String TAG_PRESENTATION = "presentation";
    private static SQLPresentationRegistry instance = null;
    private final List<SQLPresentationDescriptor> presentations = new ArrayList<SQLPresentationDescriptor>();

    public static synchronized SQLPresentationRegistry getInstance() {
        if (instance == null) {
            instance = new SQLPresentationRegistry();
            instance.loadExtensions(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private SQLPresentationRegistry() {
    }

    private void loadExtensions(IExtensionRegistry registry) {
        IConfigurationElement[] extConfigs;
        IConfigurationElement[] iConfigurationElementArray = extConfigs = registry.getConfigurationElementsFor("org.jkiss.dbeaver.sqlPresentation");
        int n = extConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if (TAG_PRESENTATION.equals(ext.getName())) {
                SQLPresentationDescriptor presentationDescriptor = new SQLPresentationDescriptor(ext);
                this.presentations.add(presentationDescriptor);
            }
            ++n2;
        }
    }

    public void dispose() {
        this.presentations.clear();
    }

    public List<SQLPresentationDescriptor> getPresentations() {
        return new ArrayList<SQLPresentationDescriptor>(this.presentations);
    }

    public SQLPresentationDescriptor getPresentation(SQLEditor editor) {
        return this.presentations.isEmpty() ? null : this.presentations.get(0);
    }
}

