/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.handlers;

import java.io.IOException;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.AbstractDataSourceHandler;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;

public class SQLEditorHandlerSeparateConnectionOption
extends AbstractDataSourceHandler
implements IElementUpdater {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        DBPPreferenceStore prefs;
        prefs.setValue("database.editor.separate.connection", !(prefs = this.getPreferenceStore(event)).getBoolean("database.editor.separate.connection"));
        try {
            prefs.save();
        }
        catch (IOException e) {
            throw new ExecutionException("Error saving configuration", (Throwable)e);
        }
        return null;
    }

    @NotNull
    private DBPPreferenceStore getPreferenceStore(ExecutionEvent event) {
        DBPDataSourceContainer dsContainer = SQLEditorHandlerSeparateConnectionOption.getActiveDataSourceContainer((ExecutionEvent)event, (boolean)false);
        return dsContainer == null ? DBWorkbench.getPlatform().getPreferenceStore() : dsContainer.getPreferenceStore();
    }

    public void updateElement(UIElement element, Map parameters) {
        element.setText(SQLEditorMessages.pref_page_sql_editor_label_separate_connection_each_editor);
        element.setTooltip(SQLEditorMessages.pref_page_sql_editor_label_separate_connection_each_editor);
        IEditorPart activeEditor = UIUtils.getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        DBPDataSourceContainer dsContainer = activeEditor == null ? null : SQLEditorHandlerSeparateConnectionOption.getDataSourceContainerFromPart((IWorkbenchPart)activeEditor);
        DBPPreferenceStore prefStore = dsContainer == null ? DBWorkbench.getPlatform().getPreferenceStore() : dsContainer.getPreferenceStore();
        element.setChecked(prefStore.getBoolean("database.editor.separate.connection"));
    }
}

