/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.generator;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithResult;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;

public abstract class SQLGenerator<OBJECT>
extends DBRRunnableWithResult<String> {
    protected List<OBJECT> objects;
    private boolean fullyQualifiedNames = true;
    private boolean compactSQL = false;
    private Map<String, Object> generatorOptions = new LinkedHashMap<String, Object>();

    public void initGenerator(List<OBJECT> objects) {
        this.objects = objects;
    }

    public List<OBJECT> getObjects() {
        return this.objects;
    }

    public boolean isFullyQualifiedNames() {
        return this.fullyQualifiedNames;
    }

    public void setFullyQualifiedNames(boolean fullyQualifiedNames) {
        this.fullyQualifiedNames = fullyQualifiedNames;
    }

    public boolean isCompactSQL() {
        return this.compactSQL;
    }

    public void setCompactSQL(boolean compactSQL) {
        this.compactSQL = compactSQL;
    }

    public Object getGeneratorOption(String name) {
        return this.generatorOptions.get(name);
    }

    public void setGeneratorOption(String name, Object value) {
        if (value == null) {
            this.generatorOptions.remove(name);
        } else {
            this.generatorOptions.put(name, value);
        }
    }

    protected String getLineSeparator() {
        return this.compactSQL ? " " : "\n";
    }

    protected String getEntityName(DBSEntity entity) {
        if (this.fullyQualifiedNames) {
            return DBUtils.getObjectFullName((DBPNamedObject)entity, (DBPEvaluationContext)DBPEvaluationContext.DML);
        }
        return DBUtils.getQuotedIdentifier((DBSObject)entity);
    }

    protected void addOptions(Map<String, Object> options) {
        options.put("useFQN", this.isFullyQualifiedNames());
        options.put("script.format.compact", this.isCompactSQL());
        options.putAll(this.generatorOptions);
    }

    public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        StringBuilder sql = new StringBuilder(100);
        try {
            for (OBJECT object : this.objects) {
                this.generateSQL(monitor, sql, object);
            }
        }
        catch (DBException e) {
            throw new InvocationTargetException(e);
        }
        this.result = sql.toString();
    }

    protected abstract void generateSQL(DBRProgressMonitor var1, StringBuilder var2, OBJECT var3) throws DBException;
}

