/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.jobs;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.jobs.KeepAlivePingJob;

public class KeepAliveListenerJob
extends AbstractJob {
    private static final int MONITOR_INTERVAL = 3000;
    private static final Log log = Log.getLog(KeepAliveListenerJob.class);
    private final DBPPlatform platform;
    private Map<String, Long> checkCache = new HashMap<String, Long>();
    private final Set<String> pingCache = new HashSet<String>();

    public KeepAliveListenerJob(DBPPlatform platform) {
        super("Keep-Alive monitor");
        this.setUser(false);
        this.setSystem(true);
        this.platform = platform;
    }

    @Override
    protected IStatus run(DBRProgressMonitor monitor) {
        if (this.platform.isShuttingDown()) {
            return Status.OK_STATUS;
        }
        DBPWorkspace workspace = this.platform.getWorkspace();
        for (DBPProject project : workspace.getProjects()) {
            if (!project.isOpen() || !project.isRegistryLoaded()) continue;
            DBPDataSourceRegistry dataSourceRegistry = project.getDataSourceRegistry();
            for (DBPDataSourceContainer dBPDataSourceContainer : dataSourceRegistry.getDataSources()) {
                this.checkDataSourceAlive(dBPDataSourceContainer);
            }
        }
        if (!this.platform.isShuttingDown()) {
            this.scheduleMonitor();
        }
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDataSourceAlive(DBPDataSourceContainer dataSourceDescriptor) {
        Date connectTime;
        Long lastCheckTime;
        if (!dataSourceDescriptor.isConnected()) {
            return;
        }
        int keepAliveInterval = dataSourceDescriptor.getConnectionConfiguration().getKeepAliveInterval();
        if (keepAliveInterval <= 0) {
            return;
        }
        final String dsId = dataSourceDescriptor.getId();
        KeepAliveListenerJob keepAliveListenerJob = this;
        synchronized (keepAliveListenerJob) {
            if (this.pingCache.contains(dsId)) {
                return;
            }
        }
        DBPDataSource dataSource = dataSourceDescriptor.getDataSource();
        if (dataSource == null) {
            return;
        }
        KeepAliveListenerJob keepAliveListenerJob2 = this;
        synchronized (keepAliveListenerJob2) {
            lastCheckTime = this.checkCache.get(dsId);
        }
        if (lastCheckTime == null && (connectTime = dataSourceDescriptor.getConnectTime()) != null) {
            lastCheckTime = connectTime.getTime();
        }
        if (lastCheckTime == null) {
            log.debug("Can't determine last check time for " + dsId);
            return;
        }
        long curTime = System.currentTimeMillis();
        if ((curTime - lastCheckTime) / 1000L > (long)keepAliveInterval) {
            KeepAlivePingJob pingJob = new KeepAlivePingJob(dataSource);
            pingJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void done(IJobChangeEvent event) {
                    KeepAliveListenerJob keepAliveListenerJob = KeepAliveListenerJob.this;
                    synchronized (keepAliveListenerJob) {
                        KeepAliveListenerJob.this.checkCache.put(dsId, System.currentTimeMillis());
                        KeepAliveListenerJob.this.pingCache.remove(dsId);
                    }
                }
            });
            KeepAliveListenerJob keepAliveListenerJob3 = this;
            synchronized (keepAliveListenerJob3) {
                this.pingCache.add(dsId);
            }
            pingJob.schedule();
        }
    }

    public void scheduleMonitor() {
        this.schedule(3000L);
    }
}

