/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.virtual;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBPEventListener;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.virtual.DBVContainer;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVEntityForeignKey;
import org.jkiss.dbeaver.model.virtual.DBVModelSerializerLegacy;
import org.jkiss.dbeaver.model.virtual.DBVModelSerializerModern;
import org.jkiss.dbeaver.model.virtual.DBVObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.xml.SAXListener;
import org.jkiss.utils.xml.XMLBuilder;

public class DBVModel
extends DBVContainer {
    private DBPDataSourceContainer dataSourceContainer;
    @NotNull
    private String id;
    private static final Map<String, List<DBVEntityForeignKey>> globalReferenceCache = new HashMap<String, List<DBVEntityForeignKey>>();

    public DBVModel(@NotNull String id, @NotNull Map<String, Object> map) {
        super(null, id, map);
        this.id = id;
    }

    public DBVModel(@NotNull DBPDataSourceContainer dataSourceContainer) {
        super(null, dataSourceContainer.getId());
        this.dataSourceContainer = dataSourceContainer;
        this.id = dataSourceContainer.getId();
    }

    public DBVModel(@NotNull DBPDataSourceContainer dataSourceContainer, @NotNull DBVModel source) {
        this(dataSourceContainer);
        this.copyFrom(source);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    public void setId(@NotNull String id) {
        this.id = id;
    }

    @Override
    public DBPDataSourceContainer getDataSourceContainer() {
        return this.dataSourceContainer;
    }

    public void setDataSourceContainer(DBPDataSourceContainer dataSourceContainer) {
        this.dataSourceContainer = dataSourceContainer;
    }

    @Override
    public DBSObjectContainer getRealContainer(DBRProgressMonitor monitor) throws DBException {
        DBPDataSource dataSource = this.dataSourceContainer.getDataSource();
        if (dataSource == null) {
            this.dataSourceContainer.connect(monitor, true, true);
            dataSource = this.dataSourceContainer.getDataSource();
        }
        if (dataSource instanceof DBSObjectContainer) {
            return (DBSObjectContainer)((Object)dataSource);
        }
        log.warn("Datasource '" + dataSource + "' is not an object container");
        return null;
    }

    @Override
    @Nullable
    public DBPDataSource getDataSource() {
        return this.dataSourceContainer == null ? null : this.dataSourceContainer.getDataSource();
    }

    public DBVEntity findEntity(DBSEntity entity, boolean createNew) {
        return this.findEntity(entity, entity.getName(), createNew);
    }

    DBVEntity findEntity(DBSEntity entity, String entityName, boolean createNew) {
        DBSObject[] path = DBUtils.getObjectPath(entity, false);
        if (path.length == 0) {
            log.warn("Empty entity path");
            return null;
        }
        if (path[0] != this.dataSourceContainer) {
            log.warn("Entity's root must be datasource container '" + this.dataSourceContainer.getName() + "'");
            return null;
        }
        DBVContainer container = this;
        int i = 1;
        while (i < path.length) {
            DBSObject item = path[i];
            if ((container = container.getContainer(item.getName(), createNew)) == null) {
                return null;
            }
            ++i;
        }
        return container.getEntity(entityName, createNew);
    }

    public DBVObject findObject(DBSObject source, boolean create) {
        DBSObject[] path = DBUtils.getObjectPath(source, true);
        if (path.length == 0) {
            log.warn("Empty entity path");
            return null;
        }
        if (path[0] != this.dataSourceContainer) {
            log.warn("Entity's root must be datasource container '" + this.dataSourceContainer.getName() + "'");
            return null;
        }
        DBVContainer container = this;
        int i = 1;
        while (i < path.length) {
            DBSObject item = path[i];
            DBVContainer childContainer = container.getContainer(item.getName(), create);
            if (childContainer == null) {
                if (i == path.length - 1) {
                    return container.getEntity(item.getName(), create);
                }
                return null;
            }
            container = childContainer;
            ++i;
        }
        return container;
    }

    public void serialize(DBRProgressMonitor monitor, JsonWriter json) throws IOException, DBException {
        DBVModelSerializerModern.serializeContainer(monitor, json, this);
    }

    @Deprecated
    public void serialize(XMLBuilder xml) throws IOException {
        DBVModelSerializerLegacy.serializeContainer(xml, this);
    }

    @Deprecated
    public SAXListener getModelParser() {
        return new DBVModelSerializerLegacy.ModelParser(this);
    }

    public void copyFrom(DBVModel model) {
        super.copyFrom(model, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, List<DBVEntityForeignKey>> getGlobalReferenceCache() {
        Map<String, List<DBVEntityForeignKey>> map = globalReferenceCache;
        synchronized (map) {
            return new HashMap<String, List<DBVEntityForeignKey>>(globalReferenceCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static List<DBVEntityForeignKey> getGlobalReferences(DBNDatabaseNode databaseNode) {
        Map<String, List<DBVEntityForeignKey>> map = globalReferenceCache;
        synchronized (map) {
            return globalReferenceCache.get(databaseNode.getNodeItemPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addToCache(@NotNull DBVEntityForeignKey foreignKey) {
        Map<String, List<DBVEntityForeignKey>> map = globalReferenceCache;
        synchronized (map) {
            List fkList = globalReferenceCache.computeIfAbsent(foreignKey.getRefEntityId(), s -> new ArrayList());
            fkList.add(foreignKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeFromCache(@NotNull DBVEntityForeignKey foreignKey) {
        Map<String, List<DBVEntityForeignKey>> map = globalReferenceCache;
        synchronized (map) {
            String refEntityId = foreignKey.getRefEntityId();
            List<DBVEntityForeignKey> fkList = globalReferenceCache.get(refEntityId);
            if (fkList != null) {
                fkList.remove(foreignKey);
                if (fkList.isEmpty()) {
                    globalReferenceCache.remove(refEntityId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renameEntityInGlobalCache(String newRefEntityId, String oldName, String newName) {
        String oldRefEntityId = newRefEntityId.replace("/" + newName, "/" + oldName);
        Map<String, List<DBVEntityForeignKey>> map = globalReferenceCache;
        synchronized (map) {
            List<DBVEntityForeignKey> fkList = globalReferenceCache.get(oldRefEntityId);
            if (fkList != null) {
                globalReferenceCache.remove(oldRefEntityId);
                globalReferenceCache.put(newRefEntityId, fkList);
                for (DBVEntityForeignKey fk : fkList) {
                    fk.setRefEntityId(newRefEntityId);
                    fk.getEntity().persistConfiguration();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkGlobalCacheIsEmpty() {
        Map<String, List<DBVEntityForeignKey>> map = globalReferenceCache;
        synchronized (map) {
            if (!globalReferenceCache.isEmpty()) {
                log.error("Virtual references cache is not empty. Possible memory leak: " + globalReferenceCache);
            }
        }
    }

    private static void handleEntityRename(DBSEntity object, String oldName, String newName) {
        DBVModel vModel;
        DBVEntity vEntity;
        DBNDatabaseNode objectNode = DBWorkbench.getPlatform().getNavigatorModel().getNodeByObject(object);
        if (objectNode != null) {
            String objectNodePath = objectNode.getNodeItemPath();
            DBVModel.renameEntityInGlobalCache(objectNodePath, oldName, newName);
        }
        if (object.getDataSource() != null && (vEntity = (vModel = object.getDataSource().getContainer().getVirtualModel()).findEntity(object, oldName, false)) != null) {
            vEntity.handleRename(oldName, newName);
            vEntity.persistConfiguration();
        }
    }

    public static class ModelChangeListener
    implements DBPEventListener {
        @Override
        public void handleDataSourceEvent(DBPEvent event) {
            Map<String, Object> options;
            DBSObject object = event.getObject();
            if (event.getAction() == DBPEvent.Action.OBJECT_UPDATE && object instanceof DBSEntity && (options = event.getOptions()) != null) {
                String oldName = (String)options.get("oldName");
                String newName = (String)options.get("newName");
                if (oldName != null && newName != null) {
                    DBVModel.handleEntityRename((DBSEntity)object, oldName, newName);
                }
            }
        }
    }
}

