/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.struct.cache;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.DBPUniqueObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.meta.PropertyGroup;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.BeanUtils;

public abstract class AbstractObjectCache<OWNER extends DBSObject, OBJECT extends DBSObject>
implements DBSObjectCache<OWNER, OBJECT> {
    private static final Log log = Log.getLog(AbstractObjectCache.class);
    private List<OBJECT> objectList;
    private Map<String, OBJECT> objectMap;
    protected volatile boolean fullCache = false;
    protected volatile boolean caseSensitive = true;
    protected Comparator<OBJECT> listOrderComparator;

    protected AbstractObjectCache() {
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public Comparator<OBJECT> getListOrderComparator() {
        return this.listOrderComparator;
    }

    public void setListOrderComparator(Comparator<OBJECT> listOrderComparator) {
        this.listOrderComparator = listOrderComparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<OBJECT> getCachedObjects() {
        AbstractObjectCache abstractObjectCache = this;
        synchronized (abstractObjectCache) {
            return this.objectList == null ? Collections.emptyList() : this.objectList;
        }
    }

    public <SUB_TYPE> Collection<SUB_TYPE> getTypedObjects(DBRProgressMonitor monitor, OWNER owner, Class<SUB_TYPE> type) throws DBException {
        ArrayList<SUB_TYPE> result = new ArrayList<SUB_TYPE>();
        for (DBSObject object : this.getAllObjects(monitor, owner)) {
            if (!type.isInstance(object)) continue;
            result.add(type.cast(object));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public OBJECT getCachedObject(@NotNull String name) {
        AbstractObjectCache abstractObjectCache = this;
        synchronized (abstractObjectCache) {
            return (OBJECT)(this.objectList == null || name == null ? null : (DBSObject)this.getObjectMap().get(this.caseSensitive ? name : name.toUpperCase()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCacheSize() {
        AbstractObjectCache abstractObjectCache = this;
        synchronized (abstractObjectCache) {
            return this.objectList == null ? 0 : this.objectList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cacheObject(@NotNull OBJECT object) {
        AbstractObjectCache abstractObjectCache = this;
        synchronized (abstractObjectCache) {
            if (this.objectList == null) {
                this.objectList = new ArrayList<OBJECT>();
            }
            this.detectCaseSensitivity((DBSObject)object);
            this.objectList.add(object);
            if (this.objectMap != null) {
                String name = this.getObjectName(object);
                this.checkDuplicateName(name, object);
                this.objectMap.put(name, object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeObject(@NotNull OBJECT object, boolean resetFullCache) {
        AbstractObjectCache abstractObjectCache = this;
        synchronized (abstractObjectCache) {
            if (this.objectList != null) {
                this.detectCaseSensitivity((DBSObject)object);
                this.objectList.remove(object);
                if (this.objectMap != null) {
                    this.objectMap.remove(this.getObjectName(object));
                }
            }
            if (resetFullCache) {
                this.fullCache = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameObject(@NotNull OBJECT object, @NotNull String oldName, @NotNull String newName) {
        AbstractObjectCache abstractObjectCache = this;
        synchronized (abstractObjectCache) {
            if (this.objectMap != null) {
                if (!this.caseSensitive) {
                    oldName = oldName.toUpperCase(Locale.ENGLISH);
                    newName = newName.toUpperCase(Locale.ENGLISH);
                }
                if (this.objectMap.remove(oldName) == object) {
                    this.objectMap.put(newName, object);
                }
            }
        }
    }

    @Nullable
    public <SUB_TYPE> SUB_TYPE getObject(DBRProgressMonitor monitor, OWNER owner, String name, Class<SUB_TYPE> type) throws DBException {
        Object object = this.getObject(monitor, owner, name);
        return type.isInstance(object) ? (SUB_TYPE)type.cast(object) : null;
    }

    @Override
    public boolean isFullyCached() {
        return this.fullCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        AbstractObjectCache abstractObjectCache = this;
        synchronized (abstractObjectCache) {
            this.objectList = null;
            this.objectMap = null;
            this.fullCache = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCache(List<OBJECT> objects) {
        AbstractObjectCache abstractObjectCache = this;
        synchronized (abstractObjectCache) {
            this.objectList = objects;
            this.objectMap = null;
            this.fullCache = true;
        }
    }

    protected void addCustomObjects(List<OBJECT> objectList) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergeCache(List<OBJECT> objects) {
        AbstractObjectCache abstractObjectCache = this;
        synchronized (abstractObjectCache) {
            if (this.objectList != null) {
                objects = new ArrayList<OBJECT>(objects);
                int i = 0;
                while (i < objects.size()) {
                    DBSObject newObject = (DBSObject)objects.get(i);
                    String newObjectName = this.getObjectName(newObject);
                    int k = 0;
                    while (k < this.objectList.size()) {
                        DBSObject oldObject = (DBSObject)this.objectList.get(k);
                        String oldObjectName = this.getObjectName(oldObject);
                        if (newObjectName.equals(oldObjectName)) {
                            objects.set(i, oldObject);
                            break;
                        }
                        ++k;
                    }
                    ++i;
                }
            }
        }
        this.setCache(objects);
    }

    private synchronized Map<String, OBJECT> getObjectMap() {
        if (this.objectMap == null) {
            this.objectMap = new HashMap<String, OBJECT>();
            for (DBSObject object : this.objectList) {
                String name = this.getObjectName(object);
                this.checkDuplicateName(name, object);
                this.objectMap.put(name, object);
            }
        }
        return this.objectMap;
    }

    private void checkDuplicateName(String name, OBJECT object) {
        if (this.objectMap.containsKey(name)) {
            log.debug("Duplicate object name '" + name + "' in cache " + this.getClass().getSimpleName() + ". Last value: " + DBUtils.getObjectFullName(object, DBPEvaluationContext.DDL));
        }
    }

    protected void detectCaseSensitivity(DBSObject object) {
        DBPDataSource dataSource;
        if (this.caseSensitive && (dataSource = object.getDataSource()) != null && dataSource.getSQLDialect().storesUnquotedCase() == DBPIdentifierCase.MIXED) {
            this.caseSensitive = false;
        }
    }

    protected void invalidateObjects(DBRProgressMonitor monitor, OWNER owner, Iterator<OBJECT> objectIter) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearChildrenOf(DBSObject parent) {
        AbstractObjectCache abstractObjectCache = this;
        synchronized (abstractObjectCache) {
            if (this.objectList == null) {
                return;
            }
            int i = 0;
            while (i < this.objectList.size()) {
                DBSObject object = (DBSObject)this.objectList.get(i);
                if (object.getParentObject() == parent) {
                    this.objectList.remove(object);
                    if (this.objectMap != null) {
                        this.objectMap.remove(this.getObjectName(object));
                    }
                    this.fullCache = false;
                    continue;
                }
                ++i;
            }
        }
    }

    @NotNull
    protected String getObjectName(@NotNull OBJECT object) {
        String name = object instanceof DBPUniqueObject ? ((DBPUniqueObject)object).getUniqueName() : object.getName();
        if (name == null) {
            return null;
        }
        if (!this.caseSensitive) {
            return name.toUpperCase();
        }
        return name;
    }

    protected void deepCopyCachedObject(@NotNull Object srcObject, @NotNull Object dstObject) {
        if (srcObject.getClass() != dstObject.getClass()) {
            log.error("Can't make object copy: src class " + srcObject.getClass().getName() + "' != dest class '" + dstObject.getClass().getName() + "'");
            return;
        }
        try {
            Class<?> theClass = srcObject.getClass();
            while (theClass != Object.class) {
                Field[] fields;
                Field[] fieldArray = fields = theClass.getDeclaredFields();
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    Field field = fieldArray[n2];
                    int modifiers = field.getModifiers();
                    if (!Modifier.isStatic(modifiers)) {
                        field.setAccessible(true);
                        Object srcValue = field.get(srcObject);
                        Object dstValue = field.get(dstObject);
                        if (DBSObjectCache.class.isAssignableFrom(field.getType())) {
                            if (dstValue != null) {
                                ((DBSObjectCache)dstValue).clearCache();
                            }
                        } else if (AbstractObjectCache.isPropertyGroupField(field)) {
                            if (dstValue != null && srcValue != null && dstValue.getClass() == srcValue.getClass()) {
                                this.deepCopyCachedObject(srcValue, dstValue);
                            }
                        } else if (!Modifier.isFinal(modifiers)) {
                            field.set(dstObject, srcValue);
                        }
                    }
                    ++n2;
                }
                theClass = theClass.getSuperclass();
            }
        }
        catch (Throwable e) {
            log.error("Error copying object state", e);
        }
    }

    public static boolean isPropertyGroupField(Field field) {
        String getterName = "get" + Character.toUpperCase(field.getName().charAt(0)) + field.getName().substring(1);
        Method[] methodArray = field.getDeclaringClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method getter = methodArray[n2];
            if (getter.getName().equals(getterName) && AbstractObjectCache.isPropertyGetter(getter) && getter.getAnnotation(PropertyGroup.class) != null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isPropertyGetter(Method method) {
        if (BeanUtils.isGetterName((String)method.getName())) {
            return method.getParameterTypes().length == 0 || method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == DBRProgressMonitor.class;
        }
        return false;
    }

    protected class CacheIterator
    implements Iterator<OBJECT> {
        private Iterator<OBJECT> listIterator;
        private OBJECT curObject;

        public CacheIterator() {
            this.listIterator = AbstractObjectCache.this.objectList.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.listIterator.hasNext();
        }

        @Override
        public OBJECT next() {
            this.curObject = (DBSObject)this.listIterator.next();
            return this.curObject;
        }

        @Override
        public void remove() {
            this.listIterator.remove();
            if (AbstractObjectCache.this.objectMap != null) {
                AbstractObjectCache.this.objectMap.remove(AbstractObjectCache.this.getObjectName(this.curObject));
            }
        }
    }
}

