/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.data.DBDBinaryFormatter;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.sql.SQLStateType;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameter;
import org.jkiss.utils.Pair;

public interface SQLDialect {
    public static final int USAGE_NONE = 0;
    public static final int USAGE_DML = 1;
    public static final int USAGE_DDL = 2;
    public static final int USAGE_PROC = 4;
    public static final int USAGE_INDEX = 8;
    public static final int USAGE_PRIV = 8;
    public static final int USAGE_ALL = Integer.MAX_VALUE;

    @NotNull
    public String getDialectName();

    @Nullable
    public String[][] getIdentifierQuoteStrings();

    @NotNull
    public String[][] getStringQuoteStrings();

    @NotNull
    public String[] getQueryKeywords();

    @NotNull
    public String[] getExecuteKeywords();

    @NotNull
    public String[] getDDLKeywords();

    @NotNull
    public String[] getDMLKeywords();

    @NotNull
    public Set<String> getReservedWords();

    @NotNull
    public Set<String> getFunctions(@Nullable DBPDataSource var1);

    @NotNull
    public Set<String> getDataTypes(@Nullable DBPDataSource var1);

    @Nullable
    public DBPKeywordType getKeywordType(@NotNull String var1);

    @NotNull
    public List<String> getMatchedKeywords(@NotNull String var1);

    public boolean isKeywordStart(@NotNull String var1);

    public boolean isEntityQueryWord(@NotNull String var1);

    public boolean isAttributeQueryWord(@NotNull String var1);

    public int getKeywordNextLineIndent(@NotNull String var1);

    @NotNull
    public String getSearchStringEscape();

    public char getStringEscapeCharacter();

    public int getCatalogUsage();

    public int getSchemaUsage();

    @NotNull
    public String getCatalogSeparator();

    public char getStructSeparator();

    @NotNull
    public String[] getParametersPrefixes();

    @NotNull
    public String getScriptDelimiter();

    @Nullable
    public String getScriptDelimiterRedefiner();

    @Nullable
    public String[][] getBlockBoundStrings();

    @Nullable
    public String[] getBlockHeaderStrings();

    public boolean isCatalogAtStart();

    @NotNull
    public SQLStateType getSQLStateType();

    public boolean validIdentifierStart(char var1);

    public boolean validIdentifierPart(char var1, boolean var2);

    public boolean useCaseInsensitiveNameLookup();

    public boolean supportsUnquotedMixedCase();

    public boolean supportsQuotedMixedCase();

    public boolean supportsSubqueries();

    public boolean supportsAliasInSelect();

    public boolean supportsAliasInUpdate();

    public boolean supportsTableDropCascade();

    public boolean supportsOrderByIndex();

    public boolean supportsCommentQuery();

    public boolean supportsNullability();

    @NotNull
    public DBPIdentifierCase storesUnquotedCase();

    @NotNull
    public DBPIdentifierCase storesQuotedCase();

    @NotNull
    public String getTypeCastClause(DBSAttributeBase var1, String var2);

    @NotNull
    public String escapeString(String var1);

    @NotNull
    public String unEscapeString(String var1);

    @NotNull
    public String escapeScriptValue(DBSAttributeBase var1, @NotNull Object var2, @NotNull String var3);

    @NotNull
    public MultiValueInsertMode getMultiValueInsertMode();

    public String addFiltersToQuery(DBPDataSource var1, String var2, DBDDataFilter var3);

    @Nullable
    public Pair<String, String> getMultiLineComments();

    public String[] getSingleLineComments();

    public boolean isDelimiterAfterQuery();

    public boolean isDelimiterAfterBlock();

    public boolean isQuoteReservedWords();

    public boolean isCRLFBroken();

    @NotNull
    public DBDBinaryFormatter getNativeBinaryFormatter();

    @Nullable
    public String getTestSQL();

    @Nullable
    public String getDualTableName();

    public boolean isTransactionModifyingQuery(String var1);

    @Nullable
    public String[] getTransactionCommitKeywords();

    @Nullable
    public String[] getTransactionRollbackKeywords();

    @Nullable
    public String getColumnTypeModifiers(DBPDataSource var1, @NotNull DBSTypedObject var2, @NotNull String var3, @NotNull DBPDataKind var4);

    public String formatStoredProcedureCall(DBPDataSource var1, String var2);

    public void generateStoredProcedureCall(StringBuilder var1, DBSProcedure var2, Collection<? extends DBSProcedureParameter> var3);

    public boolean isDisableScriptEscapeProcessing();

    public boolean supportsAlterTableConstraint();

    public static enum MultiValueInsertMode {
        NOT_SUPPORTED,
        GROUP_ROWS,
        PLAIN;

    }
}

