/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.qm.meta;

import org.jkiss.dbeaver.model.exec.DBCSavepoint;
import org.jkiss.dbeaver.model.qm.meta.QMMObject;
import org.jkiss.dbeaver.model.qm.meta.QMMSessionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionSavepointInfo;

public class QMMTransactionInfo
extends QMMObject {
    private final QMMSessionInfo session;
    private final QMMTransactionInfo previous;
    private boolean committed;
    private QMMTransactionSavepointInfo savepointStack;

    QMMTransactionInfo(QMMSessionInfo session, QMMTransactionInfo previous) {
        this.session = session;
        this.previous = previous;
        this.savepointStack = new QMMTransactionSavepointInfo(this, null, null, null);
    }

    void commit() {
        this.committed = true;
        QMMTransactionSavepointInfo sp = this.savepointStack;
        while (sp != null) {
            if (!sp.isClosed()) {
                sp.close(true);
            }
            sp = sp.getPrevious();
        }
        super.close();
    }

    void rollback(DBCSavepoint toSavepoint) {
        this.committed = false;
        QMMTransactionSavepointInfo sp = this.savepointStack;
        while (sp != null) {
            sp.close(false);
            if (toSavepoint != null && sp.getReference() == toSavepoint) break;
            sp = sp.getPrevious();
        }
        super.close();
    }

    public QMMSessionInfo getSession() {
        return this.session;
    }

    public QMMTransactionInfo getPrevious() {
        return this.previous;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public QMMTransactionSavepointInfo getCurrentSavepoint() {
        return this.savepointStack;
    }

    public QMMObject getSavepoint(DBCSavepoint savepoint) {
        QMMTransactionSavepointInfo sp = this.savepointStack;
        while (sp != null) {
            if (sp.getReference() == savepoint) {
                return sp;
            }
            sp = sp.getPrevious();
        }
        return null;
    }

    public String toString() {
        return "TRANSACTION";
    }

    @Override
    public String getText() {
        return this.session.getText();
    }
}

