/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.meta.IPropertyValueTransformer;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class DBObjectNameCaseTransformer
implements IPropertyValueTransformer<DBSObject, String> {
    @Override
    public String transform(DBSObject object, String value) {
        return DBObjectNameCaseTransformer.transformName(object.getDataSource(), value);
    }

    public static String transformObjectName(DBSObject object, String value) {
        return DBObjectNameCaseTransformer.transformName(object.getDataSource(), value);
    }

    @Nullable
    public static String transformName(@NotNull DBPDataSource dataSource, @Nullable String value) {
        boolean isNameCaseSensitive;
        if (value == null) {
            return null;
        }
        SQLDialect dialect = dataSource.getSQLDialect();
        boolean bl = isNameCaseSensitive = dataSource.getContainer().getPreferenceStore().getBoolean("database.meta.casesensitive") || dialect.storesUnquotedCase() == DBPIdentifierCase.MIXED;
        if (isNameCaseSensitive) {
            return value;
        }
        if (DBUtils.isQuotedIdentifier(dataSource, value)) {
            if (dialect.supportsQuotedMixedCase() || dialect.supportsUnquotedMixedCase()) {
                return value;
            }
            value = DBUtils.getUnQuotedIdentifier(dataSource, value);
        } else if (dialect.supportsUnquotedMixedCase() || dialect.storesUnquotedCase() == null) {
            return value;
        }
        String xName = dialect.storesUnquotedCase().transform(value);
        if (!DBUtils.getQuotedIdentifier(dataSource, xName).equals(xName)) {
            return value;
        }
        return xName;
    }
}

