/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.tools;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.mysql.tools.MySQLExportWizard;
import org.jkiss.dbeaver.ext.mysql.tools.MySQLScriptExecuteWizard;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseItem;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskConfigPanel;
import org.jkiss.dbeaver.model.task.DBTTaskConfigurator;
import org.jkiss.dbeaver.model.task.DBTTaskType;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tasks.nativetool.AbstractImportExportSettings;
import org.jkiss.dbeaver.tasks.ui.nativetool.AbstractImportExportWizard;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ClientHomesSelector;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseObjectsSelectorPanel;
import org.jkiss.utils.CommonUtils;

public class MySQLTaskConfigurator
implements DBTTaskConfigurator {
    private static final Log log = Log.getLog(MySQLTaskConfigurator.class);

    public ConfigPanel createInputConfigurator(DBRRunnableContext runnableContext, @NotNull DBTTaskType taskType) {
        return new ConfigPanel(runnableContext, taskType);
    }

    public IWizard createTaskConfigWizard(@NotNull DBTTask taskConfiguration) {
        switch (taskConfiguration.getType().getId()) {
            case "mysqlDatabaseBackup": {
                return new MySQLExportWizard(taskConfiguration);
            }
            case "mysqlDatabaseRestore": {
                return new MySQLScriptExecuteWizard(taskConfiguration, true);
            }
            case "mysqlScriptExecute": {
                return new MySQLScriptExecuteWizard(taskConfiguration, false);
            }
        }
        return null;
    }

    private static class ConfigPanel
    implements DBTTaskConfigPanel {
        private final DBRRunnableContext runnableContext;
        private final DBTTaskType taskType;
        private AbstractImportExportWizard<?, ?> ieWizard;
        private ClientHomesSelector homesSelector;
        private MySQLCatalog selectedCatalog;
        private DBPDataSource curDataSource;
        private DatabaseObjectsSelectorPanel selectorPanel;

        public ConfigPanel(DBRRunnableContext runnableContext, DBTTaskType taskType) {
            this.runnableContext = runnableContext;
            this.taskType = taskType;
        }

        public void createControl(Object parent, Object wizard, final Runnable propertyChangeListener) {
            this.ieWizard = (AbstractImportExportWizard)wizard;
            Group databasesGroup = UIUtils.createControlGroup((Composite)((Composite)parent), (String)"Select target database", (int)1, (int)1808, (int)0);
            this.selectorPanel = new DatabaseObjectsSelectorPanel((Composite)databasesGroup, false, this.runnableContext){

                protected boolean isDatabaseFolderVisible(DBNDatabaseFolder folder) {
                    return folder.getChildrenClass() == MySQLCatalog.class;
                }

                protected boolean isDatabaseObjectVisible(DBSObject obj) {
                    return obj instanceof MySQLCatalog;
                }

                protected void onSelectionChange(Object element) {
                    selectedCatalog = element instanceof DBNDatabaseItem && ((DBNDatabaseItem)element).getObject() instanceof MySQLCatalog ? (MySQLCatalog)((DBNDatabaseItem)element).getObject() : null;
                    ieWizard.getDatabaseObjects().clear();
                    if (selectedCatalog != null) {
                        ieWizard.getDatabaseObjects().add(selectedCatalog);
                    }
                    this.updateHomeSelector();
                    propertyChangeListener.run();
                }

                protected boolean isFolderVisible(DBNLocalFolder folder) {
                    for (DBNDataSource ds : folder.getNestedDataSources()) {
                        if (!this.isDataSourceVisible(ds)) continue;
                        return true;
                    }
                    return false;
                }

                protected boolean isDataSourceVisible(DBNDataSource dataSource) {
                    String driverId = dataSource.getDataSourceContainer().getDriver().getName().toLowerCase(Locale.ENGLISH);
                    return driverId.contains("mysql") || driverId.contains("mariadb");
                }
            };
            Group clientGroup = UIUtils.createControlGroup((Composite)((Composite)parent), (String)"Client files", (int)1, (int)768, (int)0);
            this.homesSelector = new ClientHomesSelector((Composite)clientGroup, "Native client");
            this.homesSelector.getPanel().setLayoutData((Object)new GridData(768));
        }

        private void updateHomeSelector() {
            MySQLDataSource newDataSource;
            MySQLDataSource mySQLDataSource = newDataSource = this.selectedCatalog != null ? this.selectedCatalog.getDataSource() : null;
            if (newDataSource != null && this.curDataSource != newDataSource) {
                this.homesSelector.populateHomes(newDataSource.getContainer().getDriver(), newDataSource.getContainer().getConnectionConfiguration().getClientHomeId(), true);
            }
            this.curDataSource = newDataSource;
        }

        public void loadSettings() {
            List databaseObjects = ((AbstractImportExportSettings)this.ieWizard.getSettings()).getDatabaseObjects();
            if (!CommonUtils.isEmpty((Collection)databaseObjects)) {
                for (DBSObject obj : databaseObjects) {
                    if (!(obj instanceof MySQLCatalog)) continue;
                    this.selectedCatalog = (MySQLCatalog)obj;
                }
            }
            if (this.selectorPanel != null && this.selectedCatalog != null) {
                try {
                    DBNDatabaseNode[] catalogNode = new DBNDatabaseNode[1];
                    this.ieWizard.getRunnableContext().run(true, true, monitor -> {
                        dBNDatabaseNodeArray[0] = DBNUtils.getNodeByObject((DBRProgressMonitor)monitor, (DBSObject)this.selectedCatalog, (boolean)false);
                    });
                    if (catalogNode[0] != null) {
                        List<DBNDatabaseNode> selCatalogs = Collections.singletonList(catalogNode[0]);
                        this.selectorPanel.setSelection(selCatalogs);
                    }
                }
                catch (InvocationTargetException e) {
                    DBWorkbench.getPlatformUI().showError("Catalogs", " Error loading catalog list", e.getTargetException());
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void saveSettings() {
        }

        public boolean isComplete() {
            return this.homesSelector.getSelectedHome() != null && this.selectedCatalog != null;
        }
    }
}

