/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.regex.Matcher;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericObjectContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCRemoteInstance;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class GenericExecutionContext
extends JDBCExecutionContext
implements DBCExecutionContextDefaults<GenericCatalog, GenericSchema> {
    private static final Log log = Log.getLog(GenericExecutionContext.class);
    private String selectedEntityName;

    public GenericExecutionContext(@NotNull JDBCRemoteInstance instance, String purpose) {
        super(instance, purpose);
    }

    @NotNull
    public GenericDataSource getDataSource() {
        return (GenericDataSource)super.getDataSource();
    }

    @Nullable
    public DBCExecutionContextDefaults getContextDefaults() {
        return this;
    }

    void determineSelectedEntity(DBRProgressMonitor monitor) {
        GenericDataSource dataSource;
        block41: {
            dataSource = this.getDataSource();
            this.selectedEntityName = null;
            Throwable throwable = null;
            Object var4_5 = null;
            try (JDBCSession session = this.openSession(monitor, DBCExecutionPurpose.META, "Determine default catalog/schema");){
                if (CommonUtils.isEmpty((String)dataSource.getQueryGetActiveDB())) {
                    try {
                        this.selectedEntityName = session.getCatalog();
                        if (dataSource.getSelectedEntityType() == null && !CommonUtils.isEmpty((String)this.selectedEntityName)) {
                            dataSource.setSelectedEntityType("catalog");
                            dataSource.setSelectedEntityFromAPI(true);
                        }
                    }
                    catch (Throwable e) {
                        log.debug((Object)e);
                    }
                    if (!CommonUtils.isEmpty((String)this.selectedEntityName)) break block41;
                    try {
                        this.selectedEntityName = session.getSchema();
                        if (dataSource.getSelectedEntityType() == null && !CommonUtils.isEmpty((String)this.selectedEntityName)) {
                            dataSource.setSelectedEntityType("schema");
                            dataSource.setSelectedEntityFromAPI(true);
                        }
                        break block41;
                    }
                    catch (Throwable e) {
                        log.debug((Object)e);
                    }
                    break block41;
                }
                try {
                    Throwable e = null;
                    Object var7_13 = null;
                    try (JDBCPreparedStatement dbStat = session.prepareStatement(dataSource.getQueryGetActiveDB());){
                        Throwable throwable2 = null;
                        Object var10_18 = null;
                        try (JDBCResultSet resultSet = dbStat.executeQuery();){
                            int divPos;
                            resultSet.next();
                            this.selectedEntityName = JDBCUtils.safeGetStringTrimmed((ResultSet)resultSet, (int)1);
                            if (!CommonUtils.isEmpty((String)this.selectedEntityName) && (divPos = this.selectedEntityName.lastIndexOf(44)) != -1) {
                                this.selectedEntityName = this.selectedEntityName.substring(divPos + 1);
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (e == null) {
                            e = throwable4;
                        } else if (e != throwable4) {
                            e.addSuppressed(throwable4);
                        }
                        throw e;
                    }
                }
                catch (SQLException e) {
                    log.debug((Object)e);
                    this.selectedEntityName = null;
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        if (CommonUtils.isEmpty((String)this.selectedEntityName)) {
            if (dataSource.hasCatalogs() && dataSource.getCatalogs().size() == 1) {
                dataSource.setSelectedEntityType("catalog");
                this.selectedEntityName = dataSource.getCatalogs().get(0).getName();
            } else if (dataSource.hasSchemas() && dataSource.getSchemas().size() == 1) {
                dataSource.setSelectedEntityType("schema");
                this.selectedEntityName = dataSource.getSchemas().get(0).getName();
            }
        }
    }

    void initDefaultsFrom(DBRProgressMonitor monitor, GenericExecutionContext context) throws DBCException {
        GenericCatalog defaultCatalog = context.getDefaultCatalog();
        String entityName = null;
        if (defaultCatalog != null && context.supportsCatalogChange()) {
            entityName = defaultCatalog.getName();
        } else if (context.supportsSchemaChange()) {
            GenericSchema defaultSchema = context.getDefaultSchema();
            entityName = defaultSchema.getName();
        }
        if (entityName == null) {
            log.error((Object)"Can't determine default entity type");
        } else {
            block29: {
                GenericDataSource dataSource = this.getDataSource();
                try {
                    Throwable throwable = null;
                    Object var7_9 = null;
                    try (JDBCSession session = this.openSession(monitor, DBCExecutionPurpose.UTIL, "Set active catalog");){
                        if (dataSource.isSelectedEntityFromAPI()) {
                            if (context.supportsCatalogChange()) {
                                session.setCatalog(entityName);
                            } else {
                                session.setSchema(entityName);
                            }
                            break block29;
                        }
                        if (CommonUtils.isEmpty((String)dataSource.getQuerySetActiveDB())) {
                            throw new DBCException("Active database can't be changed for this kind of datasource!");
                        }
                        String changeQuery = dataSource.getQuerySetActiveDB().replaceFirst("\\?", Matcher.quoteReplacement(entityName));
                        Throwable throwable2 = null;
                        Object var11_15 = null;
                        try (JDBCPreparedStatement dbStat = session.prepareStatement(changeQuery);){
                            dbStat.execute();
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e) {
                    throw new DBCException(e, (DBPDataSource)dataSource);
                }
            }
            this.selectedEntityName = entityName;
        }
    }

    public GenericCatalog getDefaultCatalog() {
        GenericDataSource dataSource;
        if (!CommonUtils.isEmpty((String)this.selectedEntityName) && (dataSource = this.getDataSource()).hasCatalogs() && (dataSource.getSelectedEntityType() == null || dataSource.getSelectedEntityType().equals("catalog") || !dataSource.hasSchemas())) {
            return this.getDataSource().getCatalog(this.selectedEntityName);
        }
        return null;
    }

    public GenericSchema getDefaultSchema() {
        GenericDataSource dataSource;
        if (!(CommonUtils.isEmpty((String)this.selectedEntityName) || (dataSource = this.getDataSource()).hasCatalogs() || !dataSource.hasSchemas() || dataSource.getSelectedEntityType() != null && !dataSource.getSelectedEntityType().equals("schema") && dataSource.hasCatalogs())) {
            return dataSource.getSchema(this.selectedEntityName);
        }
        return null;
    }

    public boolean supportsCatalogChange() {
        GenericDataSource dataSource = this.getDataSource();
        if (dataSource.isSelectedEntityFromAPI() || !CommonUtils.isEmpty((String)dataSource.getQuerySetActiveDB())) {
            if (CommonUtils.isEmpty((String)dataSource.getSelectedEntityType())) {
                return dataSource.hasCatalogs();
            }
            if (dataSource.hasCatalogs()) {
                return "catalog".equals(dataSource.getSelectedEntityType()) || !dataSource.hasSchemas();
            }
        }
        return false;
    }

    public boolean supportsSchemaChange() {
        GenericDataSource dataSource = this.getDataSource();
        if (dataSource.isSelectedEntityFromAPI() || !CommonUtils.isEmpty((String)dataSource.getQuerySetActiveDB())) {
            if (CommonUtils.isEmpty((String)dataSource.getSelectedEntityType())) {
                return !dataSource.hasCatalogs() && dataSource.hasSchemas();
            }
            if (dataSource.hasSchemas()) {
                return "schema".equals(dataSource.getSelectedEntityType()) || !dataSource.hasCatalogs();
            }
        }
        return false;
    }

    public void setDefaultCatalog(DBRProgressMonitor monitor, GenericCatalog catalog, GenericSchema schema) throws DBCException {
        GenericCatalog oldSelectedCatalog;
        GenericDataSource dataSource;
        block24: {
            if (catalog == null) {
                log.debug((Object)"Null current catalog");
                return;
            }
            dataSource = this.getDataSource();
            oldSelectedCatalog = this.getDefaultCatalog();
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (JDBCSession session = this.openSession(monitor, DBCExecutionPurpose.UTIL, "Set active catalog");){
                    if (dataSource.isSelectedEntityFromAPI()) {
                        session.setCatalog(catalog.getName());
                        break block24;
                    }
                    if (CommonUtils.isEmpty((String)dataSource.getQuerySetActiveDB())) {
                        throw new DBCException("Active catalog can't be changed for this kind of datasource!");
                    }
                    String changeQuery = dataSource.getQuerySetActiveDB().replaceFirst("\\?", Matcher.quoteReplacement(catalog.getName()));
                    Throwable throwable2 = null;
                    Object var11_15 = null;
                    try (JDBCPreparedStatement dbStat = session.prepareStatement(changeQuery);){
                        dbStat.execute();
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBCException(e, (DBPDataSource)this.getDataSource());
            }
        }
        this.selectedEntityName = catalog.getName();
        dataSource.setSelectedEntityType("catalog");
        if (oldSelectedCatalog != null) {
            DBUtils.fireObjectSelect((DBSObject)oldSelectedCatalog, (boolean)false);
        }
        DBUtils.fireObjectSelect((DBSObject)catalog, (boolean)true);
    }

    public void setDefaultSchema(DBRProgressMonitor monitor, GenericSchema schema) throws DBCException {
        GenericSchema oldSelectedSchema;
        GenericDataSource dataSource;
        block24: {
            if (schema == null) {
                log.debug((Object)"Null current schema");
                return;
            }
            dataSource = this.getDataSource();
            oldSelectedSchema = this.getDefaultSchema();
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (JDBCSession session = this.openSession(monitor, DBCExecutionPurpose.UTIL, "Set active schema");){
                    if (dataSource.isSelectedEntityFromAPI()) {
                        session.setSchema(schema.getName());
                        break block24;
                    }
                    if (CommonUtils.isEmpty((String)dataSource.getQuerySetActiveDB())) {
                        throw new DBCException("Active schema can't be changed for this kind of datasource!");
                    }
                    String changeQuery = dataSource.getQuerySetActiveDB().replaceFirst("\\?", Matcher.quoteReplacement(schema.getName()));
                    Throwable throwable2 = null;
                    Object var10_14 = null;
                    try (JDBCPreparedStatement dbStat = session.prepareStatement(changeQuery);){
                        dbStat.execute();
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBCException(e, (DBPDataSource)dataSource);
            }
        }
        this.selectedEntityName = schema.getName();
        dataSource.setSelectedEntityType("schema");
        if (oldSelectedSchema != null) {
            DBUtils.fireObjectSelect((DBSObject)oldSelectedSchema, (boolean)false);
        }
        DBUtils.fireObjectSelect((DBSObject)schema, (boolean)true);
    }

    public boolean refreshDefaults(DBRProgressMonitor monitor) throws DBException {
        GenericObjectContainer newDefaultObject;
        String oldEntityName = this.selectedEntityName;
        GenericObjectContainer oldDefaultObject = this.getDefaultObject();
        try {
            this.determineSelectedEntity(monitor);
        }
        catch (Throwable e) {
            log.debug((Object)"Error detecting active object", e);
            return false;
        }
        if (!CommonUtils.equalObjects((Object)oldEntityName, (Object)this.selectedEntityName) && (newDefaultObject = this.getDefaultObject()) != null) {
            DBUtils.fireObjectSelectionChange((DBSObject)oldDefaultObject, (DBSObject)newDefaultObject);
            return true;
        }
        return false;
    }

    public GenericObjectContainer getDefaultObject() {
        if (!CommonUtils.isEmpty((String)this.selectedEntityName)) {
            GenericDataSource dataSource = this.getDataSource();
            if (dataSource.hasCatalogs()) {
                if (dataSource.getSelectedEntityType() == null || dataSource.getSelectedEntityType().equals("catalog")) {
                    return dataSource.getCatalog(this.selectedEntityName);
                }
            } else if (dataSource.hasSchemas()) {
                return dataSource.getSchema(this.selectedEntityName);
            }
        }
        return null;
    }
}

