/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseItem;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.runtime.TasksJob;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectBase;

public class NavigatorHandlerSetActiveObject
extends NavigatorHandlerObjectBase {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection structSelection;
        Object element;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && (element = (structSelection = (IStructuredSelection)selection).getFirstElement()) instanceof DBNDatabaseNode) {
            this.markObjectAsActive((DBNDatabaseNode)element);
        }
        return null;
    }

    private void markObjectAsActive(DBNDatabaseNode databaseNode) {
        DBNNode parentNode = databaseNode.getParentNode();
        if (parentNode instanceof DBNDatabaseItem) {
            this.markObjectAsActive((DBNDatabaseNode)((DBNDatabaseItem)parentNode));
        }
        DBSObject object = databaseNode.getObject();
        DBPDataSource dataSource = object.getDataSource();
        DBCExecutionContext defaultContext = dataSource.getDefaultInstance().getDefaultContext((DBRProgressMonitor)new VoidProgressMonitor(), true);
        TasksJob.runTask((String)"Select active object", monitor -> {
            try {
                DBExecUtils.tryExecuteRecover((Object)monitor, (DBPDataSource)dataSource, param -> {
                    block4: {
                        try {
                            DBCExecutionContextDefaults contextDefaults = defaultContext.getContextDefaults();
                            if (contextDefaults == null) break block4;
                            if (object instanceof DBSCatalog && contextDefaults.supportsCatalogChange()) {
                                contextDefaults.setDefaultCatalog(monitor, (DBSCatalog)object, null);
                                break block4;
                            }
                            if (object instanceof DBSSchema && contextDefaults.supportsSchemaChange()) {
                                contextDefaults.setDefaultSchema(monitor, (DBSSchema)object);
                                break block4;
                            }
                            throw new DBCException("Internal error: active object change not supported");
                        }
                        catch (DBException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                });
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        });
    }
}

